<?php 

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_LatestComments extends NucleusPlugin { 

   function getEventList() { return array(); } 
   function getName() { return 'Latest Comments'; } 
   function getAuthor()  { return 'anand, mod by Radek HULAN and Alf mit i'; } 
   function getURL()  { return 'http://www.itismylife.com/'; } 
   function getVersion() { return '0.92'; } 
   function getDescription() { 
      return 'This plugin can be used to display the last few comments. - Special speed up version - use word counting in SQL, instead of Character counting via PHP - mod by Alfred "Alf mit i" Scheibl'; 
   } 

function supportsFeature($feature) { 
    switch($feature) { 
      case 'SqlTablePrefix': 
        return 1; 
      default: 
        return 0; 
    } 
} 

function install() { 
    $this->createOption('option1','Show short member names instead of real member names?','yesno','yes'); 
    $this->createOption('option2','Max number of words in each comment:','text','20'); 
}    

function cut_words($data,$size) {
	return implode(" ",array_slice(explode(' ',strip_tags($data)),0,$size));
}

// skinvar plugin can have a blogname as second parameter 
function doSkinVar($skinType) { 
	global $manager, $blog, $catid, $CONF; 
	$params = func_get_args(); 
	$option1 = $this->getOption('option1'); 
	$option2 = $this->getOption('option2'); 

	// Get defaults or set paramas 
	$numberOfComments = !empty($params[1]) ? $params[1] : 5; 
	$numberOfWords    = $option2 ? $option2 : 20;
	
	$condition='';
	if (intval($catid)>0) $condition.=' AND I.icat='.$catid.' '; 
	   
	$query = "SELECT C.cnumber as cnumber, C.cuser as cuser, C.citem as citem, C.cmember as cmember, C.cbody AS cbody ". 
			 'FROM '.sql_table('comment').' AS C, '.sql_table('item').' AS I '. 
			 'WHERE I.inumber = C.citem '.$condition. 
			 'ORDER by C.ctime DESC LIMIT 0,'.$numberOfComments; 

	$comments = sql_query($query); 
	$num=0; 
	while($row = sql_fetch_object($comments)) { 
		 if (!$row->cmember) { 
			$myname = $row->cuser; 
		 } else { 
			$mem = new MEMBER; 
			$mem->readFromID(intval($row->cmember));             
			// show short or real member names        
			$myname = $option1 == "yes" ?  $mem->getDisplayName() : $mem->getRealName(); 
		 } 
		 $itemlink = fancyLink($row->citem);
		 if ($num==0) echo "<ul id='articlestats2'>\n";
		 $num++; 
		 echo "<li><a href=\"".$itemlink."#comment".strval($row->cnumber)."\">".htmlspecialchars(strip_tags($myname))."</a>"; 
		 echo ": "; 
		 $ctext  = $this->cut_words($row->cbody,$numberOfWords); 
		 $ctext=str_replace("\\",' ',$ctext); 
		 $ctext=str_replace("/",' ',$ctext); 
		 echo $ctext; 
		 echo "...</li>\n"; 
	} 
	if ($num>0) echo  "</ul>\n"; 
}
  
} 
?>