<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_LatestItems extends NucleusPlugin {

   function getName() {   return 'LatestItems';    }
   function getAuthor()  { return 'Radek HULAN'; }
   function getURL() { return 'http://hulan.cz/blog/'; }
   function getVersion() {   return '0.1'; }
   function getDescription() {
      return 'This plugin displays the last 5 items.';
   }

	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

   function doSkinVar($skinType, $numOfPosts= '5') {
      $blogid = strval(getCurrentBlogId());
	  global $catid;
	  if (intval($catid)>0) $s=" AND icat=$catid "; else $s='';
      $query = sql_query('SELECT inumber, ititle, iurltitle, UNIX_TIMESTAMP(itime) as itime FROM '.sql_table('item').' WHERE iblog='.$blogid.$s.' AND idraft=0 AND itime<=NOW() ORDER by itime DESC LIMIT 0,'.strval($numOfPosts));
      $num = 1;
      global $blog;
      while ($msg = sql_fetch_array($query)) {
        $itemlink = fancyTitle($msg['inumber'],$msg['iurltitle'],$msg['itime']);
		if ($num==1) echo "<ul id='articlestats3'>\n";
        echo "<li><a href=\"".$itemlink."\">".strip_tags($msg['ititle'])."</a></li>\n";
        $num++;
     }
     if ($num>1) echo "</ul>\n";
   }
}
?>