<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_MailToAFriend extends NucleusPlugin {

	function getName() {	return 'Mail to a friend'; 	}
	function getAuthor()  { return 'Appie Verschoor'; 	}
	function getURL() {		return 'http://xiffy.nl/weblog/'; }
	function getVersion() {	return '0.9'; }
	function getDescription() { 
		return 'Template var to add a link to a friend link or button. Use &lt;%MailToAFriend(Email to a friend OR &lt;img src=....&gt)%&gt; inside your item template';
	}
	
	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

	function install() {
		$this->createOption('defaultLook','If no argument given, how does the link look?','text','[email]');
		$this->createOption('defaultMessage','What should be the initial message to send?','text',"Look at this interesting article ");
		$this->createOption('template','Which template should be used to display an item?','text',"print");
	}
	
	function doTemplateVar(&$item, $look) {
		global $manager, $blog, $CONF;
        if ($blogName) {
			$b =& $manager->getBlog(getBlogIDFromName($params[2]));
		} else if ($blog) {
			$b =& $blog;
		} else {
			$b =& $manager->getBlog($CONF['DefaultBlog']);
		}
        if (! $b) { echo "Wrong"; }
		if ($look == "") {
		    $look = $this->getOption('defaultLook');
		}
		$adminURL = $this->getAdminURL();
		$curItem = $item->itemid;
		
        echo "<a href=\"".$adminURL."mailfriend.php?itemid=".$curItem."\" onclick=\"window.open(this.href, 'popupwindow', 'width=640,height=480,scrollbars,resizable'); return false; \">".$look."</a>";
	}

} 

?>