<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_MostKarma extends NucleusPlugin {

    function getName() { 
        return 'Most Karma'; 
    }
    function getAuthor()  { 
        return 'Mikko Saari';
    }
    function getURL()  { 
        return 'http://www.melankolia.net/nucleusplugins/';
    }
    function getVersion() { 
        return '1.1';
    }
    function getDescription() {
        return 'This plugin displays a list of articles with the '
             . 'biggest karma total. Usage: &lt;%MostKarma(n,sort)%&gt; '
             . 'where n is the number of articles to list (default '
             . 'is five) and sort is the direction (asc = ascending, '
             . 'from bottom to top or desc = descending, from top to '
             . 'bottom; default is desc).';
    }
    function getMinNucleusVersion() {
        // Uses version 2.0 karma
        return 200;
    }

	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

    // skinvar plugin can have a blogname as second parameter
    function doSkinVar($skinType, $param1 = 5, $param2 = 'desc') {
        global $manager, $blog, $CONF;

        if ($param1) {
            $articlesToShow = $param1;
        }
        else {
            $articlesToShow = 5;
        }

        $sortDirection = $param2;

        if ($blog)
            $b =& $blog;
        else {
            $b =& $manager->getBlog($CONF['DefaultBlog']);
        }

        $blogid = strval(getCurrentBlogId());

		global $catid;
		if (intval($catid)>0) $s=" AND icat=$catid "; else $s='';
        $query = ' SELECT inumber as itemid, ititle as title, iurltitle, UNIX_TIMESTAMP(itime) as itime, '
               . ' ikarmapos-ikarmaneg as karma'
               . ' FROM '.sql_table('item')
               . ' WHERE iblog='.$blogid.$s
               . ' and idraft=0' // exclude drafts
               . ' and itime<=' . mysqldate($b->getCorrectTime())
               . ' and itime>'.mysqldate($b->getCorrectTime()-14*24*60*60);

        // Sort order
        if ($sortDirection == 'desc') {
            $query = $query . ' ORDER BY karma DESC, itime DESC';
        }
        else {
            $query = $query . ' ORDER BY karma ASC, itime DESC';
        }

        // Number of articles to show
        $query = $query . " LIMIT $articlesToShow";

        $entries = sql_query($query);

        $i=0;
        while ($row = sql_fetch_array($entries)) {
            $itemlink = fancyTitle($row['itemid'],$row['iurltitle'],$row['itime']);
			if ($i==0) echo "<ul id='articlestats4'>\n";
            $i++;
            echo "<li><a href=\"$itemlink\">";
            if ($row['title'])
                echo strip_tags($row['title'])."</a>";
            else
                echo "no title</a>";

            echo " [".$row['karma']."]";
            echo "</li>\n";
        }
        if ($i>0) echo "</ul>\n";
    }
}
?>