<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_MostViewed extends NucleusPlugin { 

   function getName() {   return 'Most Viewed';    } 
   function getAuthor()  { return 'Radek HULAN'; } 
   function getURL() { return 'http://hulan.cz/blog'; } 
   function getVersion() {   return '0.1'; } 
   function getDescription() { 
      return 'This plugin displays the most viewed items.'; 
   } 

	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

   function doSkinVar($skinType) { 
      $blogid = strval(getCurrentBlogId());
	  global $catid;
	  if (intval($catid)>0) $s=" and i.icat=$catid "; else $s='';
      $query = sql_query("SELECT v.id as itemid, v.views as total, i.ititle as title, iurltitle, UNIX_TIMESTAMP(itime) as time "
                           ."FROM ".sql_table('plugin_views')." as v, ".sql_table('item')." as i "
                           ."WHERE v.id=i.inumber and i.iblog=$blogid $s and i.itime>".mysqldate(time()-14*24*60*60)." ORDER by v.views DESC LIMIT 0,5"); 
      $num = 0; 
      global $blog;
      while ($msg = sql_fetch_array($query)) { 
        $itemlink = fancyTitle($msg['itemid'],$msg['iurltitle'],$msg['itime']);
		if ($num==0) echo "<ul id='articlestats5'>\n";
        $num++; 
        echo "<li><a href=\"".$itemlink."\">".strip_tags($msg['title'])."</a> [".$msg['total']."x]</li>\n"; 
      } 
     if ($num>0) echo "</ul>\n";
   } 
} 
?>