<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_New extends NucleusPlugin {

var $count;

 function getName() { return 'New';  }
 function getAuthor()  { return 'a n a n d; mod by Radek HULAN';  }
 function getURL() {  return 'http://tamizhan.com/'; }
 function getVersion() { return '0.2'; }
 function getDescription() { return 'Shows new articles since last visit using cookies. You have to enable "Save Last Visit Cookies" in Global Settings for this plugin to work!'; }
 
	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

 function install() {
    $this->createOption('MessagePrefix','What should be the message prefix ?','text','Welcome back');  
    $this->createOption('GuestName','What do we call the guest ?','text','Guest');  
    $this->createOption('MessageSuffix','What should be the message suffix ?','text',', You last visited on');  
    $this->createOption('DateFormat','What should be the date format ?','text','Y-m-d,  H:i:s');  
    $this->createOption('NoPostMessage','What should be the message when there are no new posts ?','text','No new posts since your last visit.');  
    $this->createOption('NewPostMessage','What should be the new post message ?','text',' new posts since your last visit : ');  
    $this->createOption('Untitled','Title for entry which has no title ?','text','Untitled');  
    $this->createOption('NumberOfEntries','Number of entries ?','text','10');  
 }
 
 function doSkinVar($skinType) {
   if ( ! is_null( cookieVar('lastVisit') ) && ! cookieVar('lastVisit') == 0 ) {
    $prefix = $this->getOption('MessagePrefix');
    if ( cookieVar('user') )
      $name = cookieVar('user');
    else if ( cookieVar('comment_user') )
        $name = cookieVar('comment_user');
    else
        $name = $this->getOption('GuestName');
    $suffix = $this->getOption('MessageSuffix');
    echo $prefix.' '.$name.$suffix.' '.date($this->getOption('DateFormat'),cookieVar('lastVisit')).'.';
    echo "<br /><br />";
    $this->displayNewPostLinks(cookieVar('lastVisit'));
   }
 }

  function displayNewPostLinks($timestamp){
    global $manager, $blog, $CONF; 

    if ($blog) $b =& $blog; else $b =& $manager->getBlog($CONF['DefaultBlog']); 
    $dateString = mysqldate($timestamp);
    $query = 'SELECT i.inumber as itemid, i.ititle as title' 
                   . ' FROM nucleus_item as i' 
                   . ' WHERE i.iblog='.$b->blogid 
                   . ' and i.idraft=0' // exclude drafts 
                   . ' and i.itime > ' . $dateString
				   . ' and i.itime < NOW() '
                   . ' ORDER by itime DESC LIMIT' . ' 0,10'; 
    $entries = sql_query($query); 
    $this->count = sql_num_rows($entries);
    if ( !$this->count ) {
      echo $this->getOption('NoPostMessage');
    }
    else {
      echo $this->count.$this->getOption('NewPostMessage')."<ul>";
      while ($row = sql_fetch_array($entries)){ 
       $itemlink = fancyLink($row['itemid']); 
       $itemname = $this->getOption('Untitled');
       $itemlinkprefix = "";
       if ( $row['title'] ) $itemname = $row['title'];
       echo "<li><a href=\"".$itemlink."\">".$itemname."</a></li>"; 
      }
      echo "</ul>"; 
    } 
  } 
  
}
?>