<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_OffsetArticles extends NucleusPlugin {

    function getName() {   return 'OffsetArticles';    }
    function getAuthor()  { return 'Radek HULAN'; }
    function getURL() { return 'http://hulan.cz/blog'; }
    function getVersion() {   return '0.1'; }
    function getDescription() {
      return 'This plugin displays previous X and next X articles, and also date and time of last comment made. Use <%OffsetArticles(5)%> at the end of default skin and <%OffsetArticles%> in default template.';
    }


	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

	function getCurrentCategory(){
		global $catid;
		if ($catid>0) 
			return ' AND icat='.strval($catid).' ';
		else
			return '';
	}
  
	function install() {
		$this->createOption("today", "Text for today:", "text", "<strong>today</strong>");
		$this->createOption("1day", "Text for 1 day before:", "text", "<strong>yesterday</strong>");
		$this->createOption("2day", "Text for 2 days before:", "text", "<strong>2 days ago</strong>");
		$this->createOption("newer", "Text for newer articles:", "text", "<h3>Newer articles:</h3>");
		$this->createOption("older", "Text for older articles:", "text", "<h3>Older articles:</h3>");
		$this->createOption("comments", "Text for comments:", "text", "comments: ");
	}

	function doTemplateVar(&$item) {
		$id=strval(intval($item->itemid));
		$detail = sql_query('SELECT count(cnumber) as total, max(UNIX_TIMESTAMP(ctime)) as xdate FROM '.sql_table('comment').' WHERE citem='.$id);
		if ( $xmsg = sql_fetch_array($detail) ){
			$r='['.date("d.m.y H:i",$xmsg['xdate']).']';
			if (intval($xmsg['total'])==0) 
				$r='';
			$today=date('d.m.y',time());
			$onedaybefore=date('d.m.y',strtotime ("-1 day",time()));
			$twodaysbefore=date('d.m.y',strtotime ("-2 days",time()));
			if (date("d.m.y",$xmsg['xdate'])==$today) 
				$r='['.$this->getOption("today").', '.date("H:i",$xmsg['xdate']).']';
			if (date("d.m.y",$xmsg['xdate'])==$onedaybefore) 
				$r='['.$this->getOption("1day").', '.date("H:i",$xmsg['xdate']).']';
			if (date("d.m.y",$xmsg['xdate'])==$twodaysbefore) 
				$r='['.$this->getOption("2day").', '.date("H:i",$xmsg['xdate']).']';
			echo $r;
		}
	}
   
   function doSkinVar($skinType, $numOfPosts= '5', $postsPerPage= '5') {
	  global $manager, $blog;
	  
	  // get number of articles to show 		
	  /*
	  $plug =& $manager->getPlugin('NP_Design');
	  if ($plug) {
	  	$numOfPosts = intval($plug->getBlogOption($blog->getID(),'articles'));
		$postsPerPage = $numOfPosts; 
	  }
	  */
	  
      $offset=0; 
      if (isset($_GET['offset'])) $offset=intval($_GET['offset']); 
      $data = explode("/",serverVar('REQUEST_URI'));
      for ($i=1;$i<count($data);$i++) if ($data[$i]=='offset') $offset=intval($data[$i+1]);
 
      $today=date('d.m.y',time());
      $onedaybefore=date('d.m.y',strtotime ("-1 day",time()));
      $twodaysbefore=date('d.m.y',strtotime ("-2 days",time()));

	  $blogid = $blog->getID(); 
      
      $from=$offset-intval($numOfPosts);
      $to=$offset-1;
      if ($from<0) $from=0;
      if ($to-$from+1>0){
        $query = sql_query('SELECT inumber, ititle, iurltitle, UNIX_TIMESTAMP(itime) as itime FROM '.sql_table('item').' WHERE iblog='.$blogid.' AND idraft=0 AND itime<=NOW() '.$this->getCurrentCategory().' ORDER by itime DESC LIMIT '.strval($from).','.strval($to-$from+1));
        $first=true;
        $datum='';
        while ($msg = sql_fetch_array($query)) {
          $itemlink = fancyTitle($msg['inumber'],$msg['iurltitle'],$msg['itime']);
          if ($first) {
            echo $this->getOption("newer");
          }
          $detail = sql_query('SELECT count(cnumber) as total, max(UNIX_TIMESTAMP(ctime)) as xdate FROM '.sql_table('comment').' WHERE citem='.strval($msg['inumber']));
          if (! ($xmsg = sql_fetch_array($detail)) ){
            $xmsg['total']=0;
            $xmsg['xdate']='';
          }
          $r=date("d.m.y H:i",$xmsg['xdate']);
          if (intval($xmsg['total'])==0) $r='';
          if ($datum!=date("d.m.Y",$msg['itime'])){
            if (!$first) echo "</ul>\n";
            echo "<p>".date("d.m.Y",$msg['itime'])."</p>\n";
            echo "<ul>\n";
            $first=false;
            $datum=date("d.m.Y",$msg['itime']);
          }
          if (date("d.m.y",$xmsg['xdate'])==$today) $r=$this->getOption("today").', '.date("H:i",$xmsg['xdate']);
          if (date("d.m.y",$xmsg['xdate'])==$onedaybefore) $r=$this->getOption("1day").', '.date("H:i",$xmsg['xdate']);
          if (date("d.m.y",$xmsg['xdate'])==$twodaysbefore) $r=$this->getOption("2day").', '.date("H:i",$xmsg['xdate']);
          if ($xmsg['total']>0)
            echo "<li><a href='".$itemlink."'>".strip_tags($msg['ititle'])."</a>"." [".$this->getOption("comments").strval($xmsg['total'])."] ".$r."</li>\n";
          else
            echo "<li><a href='".$itemlink."'>".strip_tags($msg['ititle'])."</a></li>\n";
        }
        if (!$first) echo "</ul>\n";
      }

      $from=$offset+intval($postsPerPage);
      $to=intval($numOfPosts);
      if ($offset==0) $to*=2;
      $query = sql_query('SELECT inumber, ititle, iurltitle, UNIX_TIMESTAMP(itime) as itime FROM '.sql_table('item').' WHERE iblog='.$blogid.' AND idraft=0 AND itime<=NOW() '.$this->getCurrentCategory().' ORDER by itime DESC LIMIT '.strval($from).','.strval($to));
      $first=true;
      while ($msg = sql_fetch_array($query)) {
        $itemlink = fancyTitle($msg['inumber'],$msg['iurltitle'],$msg['itime']);
        if ($first) {
          echo $this->getOption("older");
        }
          $detail = sql_query('SELECT count(cnumber) as total, max(UNIX_TIMESTAMP(ctime)) as xdate FROM '.sql_table('comment').' WHERE citem='.strval($msg['inumber']));
          if (! ($xmsg = sql_fetch_array($detail)) ){
            $xmsg['total']=0;
            $xmsg['xdate']='';
          }
          $r=date("d.m.y H:i",$xmsg['xdate']);
          if (intval($xmsg['total'])==0) $r='';
          if ($datum!=date("d.m.Y",$msg['itime'])){
            if (!$first) echo "</ul>\n";
            echo "<p>".date("d.m.Y",$msg['itime'])."</p>\n";
            echo "<ul>\n";
            $first=false;
            $datum=date("d.m.Y",$msg['itime']);
          }
          if (date("d.m.y",$xmsg['xdate'])==$today) $r=$this->getOption("today").', '.date("H:i",$xmsg['xdate']);
          if (date("d.m.y",$xmsg['xdate'])==$onedaybefore) $r=$this->getOption("1day").', '.date("H:i",$xmsg['xdate']);
          if (date("d.m.y",$xmsg['xdate'])==$twodaysbefore) $r=$this->getOption("2day").', '.date("H:i",$xmsg['xdate']);
          if ($xmsg['total']>0)
            echo "<li><a href='".$itemlink."'>".strip_tags($msg['ititle'])."</a>"." [".$this->getOption("comments").strval($xmsg['total'])."] ".$r."</li>\n";
          else
            echo "<li><a href='".$itemlink."'>".strip_tags($msg['ititle'])."</a></li>\n";
      }
      if (!$first) echo "</ul>\n";
   }
}
?>
