<?php 

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_OffsetEntriesLink extends NucleusPlugin { 
   function getName() { return 'OffsetEntriesLink'; } 
   function getAuthor() { return 'Nullibicity'; } 
   function getURL() { return 'http://forum.nucleuscms.org/viewtopic.php?t=2798'; } 
   function getVersion() { return '1.1'; } 
   function getDescription() { return 'Makes links for previous and next "x" entries.  Requires NP_BlogWithOffset.';} 
    
  	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

   function doSkinVar($skinType, $amount = 10, $op, $linkstr, $includelimit = 0, $key='', $pre='', $post='') { 
      global $blog, $catid; 

      $blogid = getCurrentBlogId(); 

      $offset=getVar('offset'); 
      $limit=getVar('limit');       
      $data = explode( "/", serverVar( 'REQUEST_URI'));
      for ( $i = 1;$i < count( $data);$i++) if ( $data[$i] == 'offset') $offset = intval( $data[$i + 1]);

      $entries=quickQuery("SELECT count(*) as result FROM ".sql_table('item')." WHERE iblog=".$blogid." AND idraft=0 AND itime<=".mysqldate($blog->getCorrectTime()).(($catid!=0)?" AND icat=$catid":"")); 

      if ($limit=='') list($limit) = sscanf($amount, '%d'); 
      list($temp, $limitpage1, $offsetpage1) = sscanf($amount, '%d(%d(%d))'); 
      $offsetpage1total = $limitpage1 + $offsetpage1; 
      if (($offsetpage1total==0) || //If custom offset was not read, or 
      !(($offset==0) || //if it was, and we're not making a link on the first page 
      (($offset==$offsetpage1total) && //or a second-page 
      ($op=='-')))) //forward-in-time link, 
         $offsetval =& $limit; //then use default limit, 
      else 
         $offsetval =& $offsetpage1total; //else use custom first page limit 
       
      //Calculate offset 
      $oldoffset = $offset; 
      eval ("\$offset $op= \$offsetval;"); 
      if ($offset < 0) //Don't create link; page showing most recent items 
         return; 
      else if ($offset >= $entries) //Don't create link; page showing earliest items 
         return; 

      $searchstr=array('$x', '$total'); 
      if ($op=='-')
         $replacestr[0]=($oldoffset==$offsetpage1total)?$limitpage1:$limit; 
      else 
         $replacestr[0]=(($entries-$offset)<$limit)?($entries-$offset):$limit; 
      $replacestr[1]=$entries-$offsetpage1; 
      $linkstr=str_replace($searchstr, $replacestr, $linkstr); 
      $params=array(); 
      if ($catid != 0) $params['catid'] = $catid; 
      if ($offset != 0) {
         if (($includelimit != 0) && ($limit!=$limitpage1)) $params['limit'] = $limit; 
         $params['offset'] = $offset; 
      } 

      $bloglink = createBlogLink($blog->getURL(), $params); 
      echo "$pre<a accesskey='$key' href=\"".$bloglink."\">".$linkstr."</a>$post"; 

   } // doSkinVar 
} // class 
 
?>