<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_PageLinkList extends NucleusPlugin {
   function getName() { return 'PageLinkList'; }
   function getAuthor() { return 'Nullibicity | admun (Edmond Hui) | Radek HULAN'; }
   function getURL() { return 'http://forum.nucleuscms.org/viewtopic.php?t=2897'; }
   function getVersion() { return '1.4'; }
   function getDescription() { return 'Makes a list of links to blog pages. Requires NP_BlogWithOffset.'; }

   function install( ) {
     $this->createOption( "light", "Enable STANDARD markup (not Moosified):", "yesno", "yes");
   }

 	 function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	 }

   function doSkinVar($skinType,$amount=10,$delim=', ',$userangelimit=1,$maxlinksleft=10,$maxlinksright=9,$includelimit=0) {
      global $blog, $catid;

      $js=($this->getOption("light")!='no');

      if (!$js) echo "<ol>";

      $blogid = getCurrentBlogId();

      $limit=getVar('limit');
      $offset=getVar('offset');

      $data = explode("/",serverVar('REQUEST_URI'));
      for ($i=1;$i<count($data);$i++) if ($data[$i]=='offset') $offset=intval($data[$i+1]);

      $entries=quickQuery("SELECT count(*) as result FROM ".sql_table('item')." WHERE iblog=".$blogid." AND idraft=0 AND itime<=".mysqldate($blog->getCorrectTime()).(($catid!=0)?" AND icat=$catid":""));

      $limit=getVar('limit');
      if ($limit=='') list($limit) = sscanf($amount, '%d');
      list( , $limitpage1, $offsetpage1) = sscanf($amount, '%d(%d(%d))');
      $offsetpage1total = $limitpage1 + $offsetpage1;
      $entries -= $offsetpage1; //don't count "invisible" page 1 offset entries

      //get $pagenumber
      if (($offsetpage1total==0) || ($offset==''))
         $pagenumber = floor($offset/$limit) + 1;
      else
         $pagenumber = floor(($offset-$offsetpage1total)/$limit) + 2;

      //get $totalpagecount
      if ($offsetpage1total==0)
         $totalpagecount = ceil($entries/$limit);
      else
         $totalpagecount = ceil(($entries-$limitpage1)/$limit)+1;

      $params=array();
      if ($catid != 0) $params['catid'] = $catid;

      //page link list range: $start .. $end
      if ($userangelimit != 0) {
         $start=($pagenumber>$maxlinksleft)?($pagenumber-$maxlinksleft):1;
         $end=($pagenumber+$maxlinksright>$totalpagecount)?$totalpagecount:($pagenumber+$maxlinksright);
      }
      else {
         $start=1;
         $end=$totalpagecount;
      }

      //do page 1 link, if needed
      if ($start==1) {
         if ($pagenumber==1)
            { if ($js) echo $pagenumber; else echo "<li>$pagenumber</li>"; }
         else {
            $bloglink = createBlogLink($blog->getURL(), $params);
            if ($js) echo "<strong><a href=\"$bloglink\">1</a></strong>"; else echo "<li><a href=\"$bloglink\">1</a></li>";
         }
         $i=2;
      }
      else {
        $i=$start;
      }

      if ($offsetpage1total!=0) //if custom offset
         $offset = $offsetpage1total+($i-2)*$limit; //include it in first offset,
      else
         $offset = ($i-1)*$limit; //else use default limit only

      for ( ; $i<=$end; ++$i, $offset += $limit) {
         if ($i!=$start) { if ($js) echo $delim; }
         if ($i==$pagenumber)
            { if ($js) echo $pagenumber; else echo "<li>$pagenumber</li>"; }
         else {
            if (($includelimit != 0) &&  //if include limit in query string and
            ($limit!=$limitpage1))   //custom limit only (not needed otherwise)
               $params['limit'] = $limit;
            $params['offset'] = $offset;
			$bloglink = createBlogLink($blog->getURL(),$params);
            if ($js) echo "<strong><a href=\"".$bloglink."\">$i</a></strong>"; else echo "<li><a href=\"".$bloglink."\">$i</a></li>";
         }
      }

      if (!$js) echo "</ol>";

   } // doSkinVar
} // class

?>