<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_Print extends NucleusPlugin {

	function getName() {	return 'Print'; 	}
	function getAuthor()  { return 'Rodrigo Moraes'; 	}
	function getURL() {		return 'http://www.tipos.com.br'; }
	function getVersion() {	return '0.9'; }
	function getDescription() { 
		return 'Template var to add a print friendly version of your site. Use &lt;%Print%&gt inside your item template';
	}
	
	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

	function install() {
		$this->createOption('option1','If no argument given, how does the link look?','text','[print]');
    $this->createOption('option12','Open in a new window?','yesno','yes'); 
		$this->createOption('option2','Text for the print link','text',"Click here to print this article");
		$this->createOption('option3','Text for the no print message','text',"<small>(this box will not be printed)</small>");
		$this->createOption('option4','Which template should be used to display an item?','text',"print");
		$this->createOption('option5','Header file (you can also use the complete path<br>or leave it blank for no use)','text',"./header.inc");
		$this->createOption('option6','Footer file (you can also use the complete path<br>or leave it blank for no use)','text',"./footer.inc");
    $this->createOption('fontSelector1','Font selector: allow people to choose font and font size?','yesno','yes'); 
		$this->createOption('fontSelector2','Font selector: main text','text',"Font-size:");
		$this->createOption('fontSelector3','Font selector: smaller font button','text',"smaller");
		$this->createOption('fontSelector4','Font selector: bigger font button','text',"larger");
	}
	
	function doTemplateVar(&$item, $look) {
		global $manager, $blog, $CONF;
		    $extra12 = $this->getOption('option12');
        if ($blogName) {
			$b =& $manager->getBlog(getBlogIDFromName($params[2]));
		} else if ($blog) {
			$b =& $blog;
		} else {
			$b =& $manager->getBlog($CONF['DefaultBlog']);
		}
        if (! $b) { echo "Wrong"; }
		if ($look == "") {
		    $look = $this->getOption('option1');
		}
		$adminURL = $this->getAdminURL();
		$curItem = $item->itemid;
		
        echo "<a href=\"".$adminURL."print.php?itemid=".$curItem."\"";
			if ($extra12 == 'yes') { echo" onclick=\"window.open(this.href, 'popupwindow', 'width=500,height=400,scrollbars,resizable'); return false; \"";}
			echo ">".$look."</a>";
	}

} 

?>