<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_QueryLog extends NucleusPlugin {

	function getEventList() { return array('PreSkinParse');	}
	
	function event_preSkinParse($data) {
	  global $query;
	  if ($data['type'] == "search" ) {
      $sqlquery = "INSERT INTO ". sql_table('plugin_querylog') ." (querystr) VALUES ('".sql_escape($query) ."')";
	    sql_query($sqlquery);
	  }
	}

  function doSkinVar($skintype, $amount = 10) {
    $query = "SELECT querystr "
           . ", UNIX_TIMESTAMP(querywhen) AS querywhen"
           . " FROM ".sql_table('plugin_querylog')
           . " ORDER BY querywhen DESC"
           .  " LIMIT ".$amount;
    $refs = sql_query($query);
    if ($refs) {
        echo "<ul class='search'>";
        while ($obj = sql_fetch_object($refs)) 
            echo "<li>".
                 strftime("%d.%m.%Y - %H:%M:%S",$obj->querywhen + (0 * 3600)).
                 " : <a href=\"/blog/?blogid=1&amp;amount=0&amp;query=".
                 $obj->querystr."\">". 
                 $obj->querystr.
                 "</a></li>";
        echo "</ul>";
    }
  }
    
  function getName()   { return 'QueryLog'; }
  function getAuthor() { return '-=Xiffy=-'; }
  function getURL()    { return 'http://xiffy.nl/weblog/'; }
  function getVersion(){ return '0.01'; }
  function getDescription() {return 'Keeps track of the queries run on your weblog  <%QueryLog(10)%> to see the top searches'; }

  function getTableList() {
      return array(sql_table('plugin_querylog'));
  }

	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}
}
?>