<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULÁN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_RSSBlog extends NucleusPlugin {
    function getName() {	return 'RSS Blog'; 	}
    function getAuthor()  { return 'Radek HULAN'; 	}
    function getURL() {		return 'http://hulan.cz/blog/'; }
    function getVersion() {	return '0.1'; }
    function getDescription() {
        return 'RSS for latest 20 comments for your blog.';
    }
	
	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

    function doAction($type) {
		global $CONF;
		// start feed
		ob_start();
		// make feed
		$this->putHeader();
		if (isset($_GET['blogid'])) 
			$blogid=strval(intval($_GET['blogid']));
		else
			$blogid=strval(getCurrentBlogId());
		$result = sql_query("SELECT c.citem AS item, c.cbody AS body, c.cuser AS user, c.cmember AS member, c.cnumber AS commentid, cmail AS link, UNIX_TIMESTAMP(ctime) as ct, i.ititle as title ".
							"FROM ".sql_table('comment')." c, ".sql_table('item')." i ".
							"WHERE c.citem=i.inumber ".
							" AND i.iblog=$blogid ".
							"ORDER BY ct DESC ".
							"LIMIT 0,20");
		while ($row = sql_fetch_object($result)) {
		$this->putComment($row);
		}
		$this->putEnd();
	    // get feed into $feed
	    $feed = ob_get_contents();
	    ob_end_clean();
	    // create ETAG (hash of feed)
    	// (HTTP_IF_NONE_MATCH has quotes around it)
    	$eTag = '"'.md5($feed).'"';
    	header('Etag: '.$eTag);
    	// compare Etag to what we got
    	if ($eTag == serverVar('HTTP_IF_NONE_MATCH')) {	
    		header("HTTP/1.0 304 Not Modified");
    		header('Content-Length: 0');
    	} else {
    		// dump feed
			header ("Content-type: application/rss+xml");
			echo $feed;
    	}
    }

    function doSkinVar($type, $what)
    {
      global $manager, $blogid, $CONF;
      $link = $this->getRSSLink($item->itemid);
      echo "<a href='$link'><img src='".$CONF['SkinsURL']."base/rss20comment.png' alt='RSS of latest 20 comments'/></a>";
    }
    
    function doTemplateVar(&$item)
    {
      // no action
    }

    function getRSSLink($itemid)
    {   global $CONF, $blogid;
		$blogid=strval(getCurrentBlogId());
        return $CONF['IndexURL'] . 'action.php?action=plugin&amp;name=RSSBlog&amp;blogid='.$blogid;
    }

    function encode_xml($data){
      return strip_tags(str_replace('</p>',"\n",str_replace('<br />',"\n",entity_to_decimal_value($data))));
    }

    function putHeader()
    {   
        global $manager, $blog, $CONF; 
        if ($blog) $b =& $blog; else $b =& $manager->getBlog($CONF['DefaultBlog']); 
		if (!defined(_CHARSET))
		  header('Content-Type: text/xml; charset=utf-8');
		else
		  header('Content-Type: text/xml; charset=' . _CHARSET);
    	echo '<'.'?xml version="1.0" encoding="'._CHARSET.'"?'.'>'."\n";
    	echo '<'.'?xml-stylesheet type="text/css" href="'.$b->getURL().'skins/base/rss.css" ?'.'>'."\n";
        echo "<rss version=\"2.0\">\n";
        echo "<channel>\n";
        echo "<title>".$b->getName()."</title>\n";
        echo "<link>".$b->getURL()."</link>\n";
        echo "<description>".$b->getName()."</description>\n";
        echo "<language>en</language>\n";
        echo "<image>\n";
        echo "<url>".$CONF['AdminURL']."admin/blogcms.gif</url>\n";
        echo "<title>RSS feed of last 20 comments.</title>\n";
        echo "<link>".$b->getURL()."</link>\n";
        echo "</image>\n";
        echo "<docs>http://backend.userland.com/rss</docs>\n";
    } 

    function putComment($comment) {
        global $CONF;
        if ($comment->member > 0) {
            $result = sql_query("SELECT mname AS nick, murl AS link FROM ".sql_table('member')." WHERE mnumber = ".$comment->member);
            $member = sql_fetch_object($result);
            $authorlink = $member->nick;
            $author = "Comment made by: " .$member->nick;
            $title=$comment->title;
        } else {
            $authorlink = $comment->user;
            if (!empty($comment->link)) $authorlink.=" : ".$comment->link;
            $author = "Comment made by: " .$comment->user;
        }
        echo "<item>\n";
        echo "<title>".$this->encode_xml($comment->title)."</title>\n";
        $link = fancyLink($comment->item);
        echo "<link>".$this->encode_xml($link)."#comment".strval($comment->commentid)."</link>\n";
        $data = "Comment from [".$authorlink."] --- \n".$this->encode_xml($comment->body);
        echo "<description>".$data."</description>\n";
        echo "<pubDate>".strval(date("r",$comment->ct))."</pubDate>\n";
        echo "</item>\n";
    }


    function putEnd() {
        echo "</channel>\n";
        echo "</rss>\n";
    } 

} 

?>