<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULÁN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_RSSItem extends NucleusPlugin {

var $defaultlook,$rssimage;

    function getName() {	return 'RSS Item'; 	}
    function getAuthor()  { return 'Appie Verschoor, Radek HULAN'; 	}
    function getURL() {		return 'http://blogcms.com/'; }
    function getVersion() {	return '1.0'; }
    function getDescription() {
        return 'A Template and Skin plugin to create an RSS Link and export the item with all of it s comments as a RSS File, cooperates with Trackback, might work without but untested';
    }
	
 function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

    function install() {
        $this->createOption('RSSImage', 'Logo?', 'text', '/admin/blogcms.gif');
    }

    function init() {
        $this->rssimage = ($this->getOption(RSSImage));
    }

    function doAction($type) {
        global $manager;

        $itemid		= intRequestVar('itemid');
        $item =& $manager->getItem($itemid,false,true);
        $blog =& $manager->getBlog(getBlogIDFromItemID($itemid));
        
        $ir = sql_query("SELECT UNIX_TIMESTAMP(itime) AS it FROM ".sql_table('item')." WHERE inumber = $itemid ");
        $li = sql_fetch_object($ir);

		// start capture the output
		ob_start();
		// publish headers:
		$this->putHeader($item, $blog);
		//publish the item
		$this->putItem($item, $blog, $li);
		// now the comments ...
		$result = sql_query("SELECT c.citem AS item, c.cbody AS body, c.cuser AS user, c.cmember AS member, c.cnumber AS commentid, cmail AS link, UNIX_TIMESTAMP(ctime) as ct ".
							  " FROM ".sql_table('comment')." c ".
							  " WHERE c.citem = $itemid ".
							  " ORDER BY c.cnumber ASC");
		while ($row = sql_fetch_object($result)) $this->putComment($row);
		// and trackbacks ...
		$result = sql_query("SELECT tb.tb_id as itemid, tb.url as url, tb.title as title, tb.excerpt as body, tb.blog_name as blogname ".
							  " FROM ".sql_table('plugin_tb')." tb ".
							  " WHERE tb.tb_id = $itemid ".
							  " ORDER BY tb.timestamp");
		while ($row = sql_fetch_object($result)) $this->putTrackback($row);
		$this->putEnd();
		// and compare the output to what we have
		$feed = ob_get_contents();
		ob_end_clean();
		$eTag = '"'.md5($feed).'"';
		header('Etag: '.$eTag);
		// compare Etag to what we got
		if ($eTag == serverVar('HTTP_IF_NONE_MATCH')) {	
			header("HTTP/1.0 304 Not Modified");
			header('Content-Length: 0');
		} else
			echo $feed;
    }

    function doSkinVar($type, $what) {
        global $manager, $blogid;
    }
    
    function doTemplateVar(&$item)
    {
        global $manager, $blogid, $CONF;
        $link = $this->getRSSLink($item->itemid);
        
        echo "<a href='$link'><img src='".$CONF['SkinsURL']."base/rss20.png' alt='RSS 2.0 comments feed' /></a>";
    }

    function getRSSLink($itemid)
    {   global $CONF;
        return $CONF['IndexURL'] . 'action.php?action=plugin&amp;name=RSSItem&amp;itemid='.$itemid;
    }

    function encode_xml(&$data){
		echo strip_tags(entity_to_decimal_value($data));
    }

    // "put" functions:
    function putHeader($item, $blog)
    {   global $CONF, $manager;
		if (!defined(_CHARSET))
		  header('Content-Type: text/xml; charset=utf-8');
		else
		  header('Content-Type: text/xml; charset=' . _CHARSET);
    	echo '<' . '?xml version="1.0" encoding="'._CHARSET.'"?' . '>'."\n";
    	echo '<' . '?xml-stylesheet type="text/css" href="'.$CONF['SkinsURL'].'base/rss.css"?' . '>'."\n";
    	?>
<rss version="2.0">
<channel>
    <title><?php echo $this->encode_xml($item[title]); ?></title>
    <link><?php echo fancyLink($item[itemid]); ?></link>
    <description><?php
        $this->encode_xml(shorten(strip_tags($item[body]),200,'..'));
    ?></description>
    <language>cs</language>
    <image>
        <url><?php echo $this->rssimage; ?></url>
        <title><?php echo $item[title];?></title>
        <link><?php echo fancyLink($item[itemid]); ?></link>
    </image>
    <docs>http://backend.userland.com/rss</docs>
	    <?php
    } // putHeader

    // Make an RSS Item for each comment:
	function putComment(&$comment) {
        global $CONF;
        if ($comment->member > 0) {
            $result = sql_query("SELECT mname AS nick, murl AS link FROM ".sql_table('member')." WHERE mnumber = ".$comment->member);
            $member = sql_fetch_object($result);
            $authorlink = "<a href=\"".$member->link."\">".$member->nick."</a>";
            $author = "Comment by: " .$member->nick;
        } else {
            $authorlink = "<a href=\"".$comment->link."\">".$comment->user."</a>";
            $author = "Comment by: " .$comment->user;
        }
        ?>
<item>
<title><?php $this->encode_xml($author);?></title>
<link><?php $link = fancyLink($comment->item)."#comment".$comment->commentid;
         $this->encode_xml($link)?></link>
<description><?php $data = $authorlink."<br />".$comment->body; $this->encode_xml($data); ?></description>
<pubDate><?php echo strval(date("r",$comment->ct)); ?></pubDate>
</item>
        <?php
    }

    // putTrackback:
    function putTrackback($tb) {
        global $CONF;
        ?>
<item>
<title><?php echo "Trackback: "; $this->encode_xml($tb->title);?></title>
<link><?php echo $tb->url;?></link>
<description><?php $this->encode_xml($tb->body); ?></description>
<pubDate><?php echo strval(date("r")); ?></pubDate>
</item>
        <?php
    }

    // putItem: display te item as an rss-item.
    function putItem($item, $blog, $li) {
        global $CONF;
        ?>
<item>
<title><?php echo $blog->getName()." ".$item[title]?></title>
<link><?php echo fancyLink($item[itemid]); ?></link>
<description><?php $text = $item[body].$item[more]; $this->encode_xml($text); ?></description>
<pubDate><?php echo strval(date("r",$li->it)); ?></pubDate>
</item>
        <?php
    }

    // putEnd: end the rss file ...
    function putEnd() {
        ?>
    </channel>
</rss>
        <?php
    }

} 

?>