<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_Random extends NucleusPlugin { 

   function getName() {          return 'Random'; } 
   function getAuthor()  {       return 'Radek HULAN'; } 
   function getURL()  {          return 'http://hulan.cz/blog/'; } 
   function getVersion() {         return '0.0.1'; } 
   function getDescription() { 
      return 'Displays a random line of text from a text file by using &lt;%Random%&gt;.'; 
   } 


	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

	function install() {
		$this->createOption('filename','Filename with quotes','text','./skins/base/quotes.txt');
	}

  function trimString($s){
    $s=str_replace("\r","",str_replace("\n","",$s));
    if ($s=='') return '';
    while (substr($s,strlen($s)-1,1)==' ') $s=substr($s,0,strlen($s)-1);
    return $s;
  }
  
  function doSkinVar($skinType) { 
      // seed the random generator
      srand(microtime()*100000);
      // count lines
      $arr = file($this->getOption('filename')); 
      $count=sizeof($arr)/2;
      // select a random quote
      $line=rand(0,$count-1);
      echo $this->trimString($arr[$line*2]); 
      echo "<em>~".$this->trimString($arr[$line*2+1])."~</em>";
  } 
}
?>