<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/


class NP_SearchHighlight extends NucleusPlugin {

var $aEngines,$currentblog,$enginesearchquery,$enginesearchhost;

    function getName() {	return 'Search Highlight';     }
    function getAuthor()  { return 'Wouter Demuynck, mod by Radek HULAN';     }
    function getURL() {		return 'http://nucleuscms.org/'; }
    function getVersion() {	return '0.4'; }
    function getDescription() { 
        return 'When a visitor arrives at an item-page through a search engine, the terms from the search query are highlighted automatically. Use <%SearchHighlight%> in your default skin.';
    }
    
    function getMinNucleusVersion() { return 200; }
    

    function init() {
    	$this->aEngines = array(
    		'google' 		=> 'q,as_q,as_oq,as_epq',
    		'altavista'		=> 'q',
    		'search.yahoo'	=> 'p',
    		'search.msn'	=> 'q',
    		'lycos'			=> 'query',    		
    		'hotbot'		=> 'query',
    		'ilse' 			=> 'search_for',
    		'vinden'		=> 'query',
    		'zoeken'		=> 'query',
    		'seznam'		=> 'w',
    		'jyxo'		=> 's',
    		'advalvas'		=> 'WORD'
    	);
    	$this->enginesearchquery='';
    	$this->enginesearchhost='';
    }
        
    function supportsFeature($what) {
        switch($what)
        {
            case 'SqlTablePrefix':
                return 1;
            default:
                return 0;
        }
    }
    
    function getEventList() {
        return array('PreSkinParse','PreItem');
    }
    
    
	  function install() {
		  $this->createOption("text01", "Text engine 'you came from':", "text", "<h4>You came from: <strong>");
		  $this->createOption("text02", "Text engine 'looking for':", "text", "</strong>, searching for <strong>words</strong>: ");
		  $this->createOption("text03", "Text engine 'ending tag':", "text", "</h4><br />");
 	  }

    function getCurrentBlog(){
      // current blog id
      global $manager, $blog, $CONF; 
      if ($blog) $b =& $blog; else $b =& $manager->getBlog($CONF['DefaultBlog']); 
      $this->currentblog=strval($b->getID());
      if ($this->currentblog=='') $this->currentblog='1';
    }

    function event_PreSkinParse(&$data) {
        $referer = serverVar('HTTP_REFERER');
        // parse query-string
        $url = parse_url($referer);
        parse_str($url,$res);
            
        global $highlight;
        $this->enginesearchquery='';
        $this->enginesearchhost='';
        if ( isset($url[host]) ) $this->enginesearchhost=$url[host];
        $highlight = $this->engineString($url[host],$url[query]);

        // main page
        if ($data['type']=='index') {
          if ( ($this->enginesearchquery!='') && ($this->enginesearchhost!='') ) {
           $url = "http://".serverVar('HTTP_HOST').serverVar('REQUEST_URI');
           if (strpos($url,'?')===false) $url.='?query='.$this->enginesearchquery; else $url.='&query='.$this->enginesearchquery;
           $this->getCurrentBlog();
           $url=strtr($url," ","+").'&amount=0&blogid='.$this->currentblog;
			     header('Expires: 0');
			     header('Pragma: no-cache');
           header("Location: $url");
           $url = htmlspecialchars($url);
           die("Redirected: <a href=\"$url\">$url</a>");
          }
        }
    }
    
	  function event_PreItem($data) {
	    if ( ($this->enginesearchquery!='') && ($this->enginesearchhost!='') ){
	      if ( isset($_GET['itemid']) || !(strpos(serverVar('REQUEST_URI'),'/item/')===false) ) 
          $data['item']->body=
            $this->getOption("text01").
            $this->enginesearchhost.
            $this->getOption("text02").
            $this->enginesearchquery.
            $this->getOption("text03").
            $data['item']->body;
	      }
	  }

    function engineString($from, $query)
    {
    	$from = strtolower($from);
    	$q = '';
    	
    	foreach ($this->aEngines as $engine => $fieldnames) {
    		if (strstr($from, $engine)) {
	  			parse_str($query,$res);
    			$aFields = explode(',', $fieldnames);
    			foreach ($aFields as $field) {
    				if ($res[$field])
						  $q .= ' ' . $res[$field];
				  }
    			if ($q) {
    			  $q=strtr($q,'"',' ');
    			  $q=strtr($q,'\'',' ');
    			  $q=strtr($q,'\\',' ');
    			  $q=strtr($q,'<',' ');
    			  $q=strtr($q,'>',' ');
    			  $q=strtr($q,'/',' ');
    			  $q=htmlspecialchars($q);
    			  if (strlen($q)>0) if (substr($q,0,1)==" ") $q=substr($q,1);
    			  $this->enginesearchquery=$q;
            break;
            }
     		  }
    	}
      return trim($q);
    }
} 
?>