<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_SubCategories extends NucleusPlugin {

	function supportsFeature($feature) { if ($feature=='SqlTablePrefix') return 1; else return 0;}
	function getName() {return 'SubCategories'; 	}
	function getAuthor()  { return 'Radek HULAN'; }
	function getURL() {return 'http://hulan.cz/blog/'; }
	function getDescription() { return 'SubCategories for BLOG:CMS';	}

	function getTableList() {
		return array(sql_table('subcategory'));
	}

	function install() {
		$this->createOption('tpl_header',"List header",'textarea',"<div id='subcat'>\n<dl>\n<dt>Structure</dt>\n<dd><a <%active%> href='<%blogurl%>' title='Show articles from all categories'>All</a></dd>\n<dd><a href='<%toogle%>' title='Expand/Fold whole category tree'>Toogle Tree</a></dd>\n</dl>\n");
		$this->createOption('tpl_footer',"List footer",'textarea',"</div>\n");
		$this->createOption('tpl_group_header',"Category group header",'textarea',"<dl <%id%>>\n");
		$this->createOption('tpl_group_item',"Category group item",'textarea',"<dt><a href='<%switch%>' title='Expand/Fold this group'><%name%> &raquo;</a></dt>\n");
		$this->createOption('tpl_group_footer',"Category group footer",'textarea',"</dl>\n");
		$this->createOption('tpl_item_header',"Category item header",'textarea',"");
		$this->createOption('tpl_item_item',"Category item item",'textarea',"<dd><a <%active%> href='<%url%>' title='Show articles only from this category'><%name%></a></dd>\n");
		$this->createOption('tpl_item_footer',"Category item footer",'textarea',"");
		// category groups
		global $SQL_TYPE;
		switch ($SQL_TYPE){
		   case 0:
			 sql_query("create table if not exists ".sql_table('subcategory')." (blogid int(11), groupid int(11) auto_increment PRIMARY KEY, name varchar(255), shortname varchar(255), KEY(blogid)) Type=MyISAM COMMENT='Plugin: Subcategories'");
			 sql_query("truncate table ".sql_table('subcategory'));
			 break;
		   case 1:
			 sql_query("create table if not exists ".sql_table('subcategory')." (blogid int(11), groupid int(11) auto_increment PRIMARY KEY, name varchar(255), shortname varchar(255), KEY(blogid)) Type=MyISAM COMMENT='Plugin: Subcategories'");
			 sql_query("truncate table ".sql_table('subcategory'));
			 break;
		   case 2:
			 sql_query("create table ".sql_table('subcategory')." (blogid int(11), groupid INTEGER PRIMARY KEY, name varchar(255), shortname varchar(255))");
			 sql_query("create index idx_subcategory on ".sql_table('subcategory')." (blogid)");
			 break;
		}
		sql_query("insert into ".sql_table('subcategory')." (blogid,name,shortname) select bnumber, 'Default Category', 'default' from ".sql_table('blog')); 
	}
	
	function uninstall() {
		// sql_query("drop table ".sql_table('subcategory'));
	}
	
	function init(){
		$this->_tpl_header=$this->getOption('tpl_header');
		$this->_tpl_footer=$this->getOption('tpl_footer');
		$this->_tpl_group_header=$this->getOption('tpl_group_header');
		$this->_tpl_group_item=$this->getOption('tpl_group_item');
		$this->_tpl_group_footer=$this->getOption('tpl_group_footer');
		$this->_tpl_item_header=$this->getOption('tpl_item_header');
		$this->_tpl_item_item=$this->getOption('tpl_item_item');
		$this->_tpl_item_footer=$this->getOption('tpl_item_footer');
	}

	function doSkinVar($skinType) {
		global $catid, $manager, $blog, $CONF;
		$query=sql_query('select name, groupid from '.sql_table('subcategory').' where blogid='.getCurrentBlogId().' order by name');
   		if ($blog) $b =& $blog; else $b =& $manager->getBlog($CONF['DefaultBlog']);
		$s=str_replace('<%blogurl%>',$b->getURL(),$this->_tpl_header);
		if (!isset($catid) || intval($catid)<1)
			$s=str_replace('<%active%>',"class='active'",$s);
		else
			$s=str_replace('<%active%>','',$s);
		$s=str_replace('<%active%>',"class='active'",$s);
		$s=str_replace('<%expand%>','javascript:categoryexpand();',$s);
		$s=str_replace('<%fold%>','javascript:categoryfold();',$s);
		$s=str_replace('<%toogle%>','javascript:categorytoogle();',$s);
		echo $s;
		$i=1;
		while ($row=sql_fetch_object($query)){
			$catquery=sql_query('select cname, catid from '.sql_table('category').' where cgroup='.$row->groupid.' order by cname');
			if (sql_num_rows($catquery)>0) {
				$s=str_replace('<%id%>',"id='subcat".$i."'",$this->_tpl_group_header);
				echo $s;
				$s=str_replace('<%name%>',$row->name,$this->_tpl_group_item);
				$s=str_replace('<%switch%>','javascript:categoryswitch('.$i.');',$s);
				echo $s;
				while ($category=sql_fetch_object($catquery)){
					echo $this->_tpl_item_header; 
					$s=str_replace('<%name%>',$category->cname,$this->_tpl_item_item);
					$s=str_replace('<%url%>',createCategoryLink($category->catid),$s);
					if ($category->catid==$catid)
						$s=str_replace('<%active%>',"class='active'",$s);
					else
						$s=str_replace('<%active%>','',$s);
					echo $s;
					echo $this->_tpl_item_footer;
				}
				echo $this->_tpl_group_footer;
				$i++;
			}
			sql_free_result($catquery);
		}
		echo $this->_tpl_footer;
	}

}

?>