<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_WIE extends NucleusPlugin { 

    function getName() { return 'WIE plugin'; } 

    function getAuthor()  { return 'Jef Pober'; } 

    function getURL()  { return 'http://fuckhedz.com'; } 

    function getVersion() { return '1.0'; } 

    function getDescription() { return 'Yet another Who Is Online Plugin'; }
    function getEventList() { return array('Logout'); }
    
   
	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

     function install() {
            $this->createOption('timeout','Seconds that should pass before someone is marked as being offline','text','600');
            $this->createOption('fancycolors','Enable fancy colors?','yesno','yes');
            $this->createOption('createlinks','Create links to profiles?','yesno','yes');
            $this->createOption('separator','Character to separate users','text',', ');
            $this->createOption('online','Translation: Online','text','online');
            $this->createOption('offline','Translation: Offline','text','offline');
            $this->createOption('guest','Translation: Guest','text','guest');
            $this->createOption('guests','Translation: Guests (plural)','text','guests');
            $this->createOption('inactive','Translation: Inactive','text','inactive');
            $this->createOption('seconds','Translation: seconds','text','seconds');
    }
    
	function getTableList() {
		return array(sql_table('plug_wie'));
	}

    function doSkinVar($skinType,$arg='') {
        global $member;
        
        switch($arg) {
            case 'list':
                if (!$_SESSION['wiesessvar']) {
                    // User enters site
                    $rand = rand(0,999999999);
                    $_SESSION['wiesessvar'] = $rand;
                }
                
                // Get timestamp and memberid
                $timestamp = time();
                $memberid = $member->getID();
                if (!$memberid) $memberid = 0;
                
                // Check to see if we should insert or update
                $result = sql_query('SELECT * FROM ' . sql_table('plug_wie') . ' WHERE sessid=' . $_SESSION['wiesessvar']);
                if (sql_num_rows($result) == 1) {                        
                    sql_query('UPDATE ' . sql_table(plug_wie) . ' SET timestamp= ' . $timestamp . ', memberid= ' . $memberid . ' WHERE sessid=' . $_SESSION['wiesessvar']);
                } else {
                    // CLEAN
                    sql_query('DELETE FROM ' . sql_table('plug_wie') . ' WHERE memberid= ' . $memberid);
                    // INSERT
                    sql_query('INSERT INTO ' . sql_table(plug_wie) . ' VALUES(' . $_SESSION['wiesessvar'] . ', ' . $timestamp . ', ' . $memberid . ')');
                }
                
                // Drop everything that is older than x seconds
                $timeout = $timestamp - $this->getOption('timeout');
                sql_query('DELETE FROM ' . sql_table(plug_wie) . ' WHERE timestamp < ' . $timeout);
                
                // Presentation
                $result = sql_query('SELECT * FROM ' . sql_table('plug_wie') . ' WHERE memberid > 0 ORDER BY timestamp DESC');
                while ($row = sql_fetch_object($result)) {
                    $nameresult= 'SELECT mname as result FROM ' . sql_table('member') . ' WHERE mnumber =' . $row->memberid;
                    $name = quickQuery($nameresult);
                    if ($this->getOption('createlinks')) {
                        $name = '<a href= "' . createMemberLink($row->memberid) . '" title="' . $this->getOption('inactive') . ': ' . ($timestamp - $row->timestamp) . ' ' . $this->getOption('seconds') . '">' . $name . '</a>';
                    }
                    
                    if ($this->getOption('fancycolors') == 'yes') {
                        echo $this->doColors($name,($timestamp - $row->timestamp));
                    } else {
                        echo $name;
                    }
                    echo $this->getOption('separator');
                }
                
                $guestresult = 'SELECT COUNT(*) as result FROM ' . sql_table('plug_wie') . ' WHERE memberid =0';
                $guests = quickQuery($guestresult);
                
                if ($guests == 1) {
                    echo $guests . ' ' . $this->getOption('guest');
                } else {
                    echo $guests . ' ' . $this->getOption('guests');
                }
                
                break;
            case 'status':
                $memberid = intval($_GET['memberid']);
                $result = sql_query('SELECT * FROM ' . sql_table('plug_wie') . ' WHERE memberid=' . $memberid);
                if ($msg = sql_fetch_array( $result )){
                    echo $this->getOption('online');
                } else {
                    echo $this->getOption('offline');
                }
                break;
        }
    }
    
    function doTemplateCommentsVar(&$item, &$comment,$param1='status') {
        $memberid = $comment['memberid'];
        $result = sql_query('SELECT * FROM ' . sql_table('plug_wie') . ' WHERE memberid=' . $memberid);
        if (sql_num_rows($result) > 0) {
                echo $this->getOption('online');
        } else {
                echo $this->getOption('offline');
        }        
    }
    
    function doTemplateVar(&$item,$param1='status') {
        $memberid = $item->authorid;
        $result = sql_query('SELECT * FROM ' . sql_table('plug_wie') . ' WHERE memberid=' . $memberid);
        if (sql_num_rows($result) > 0) {
                echo $this->getOption('online');
        } else {
                echo $this->getOption('offline');
        }        
    }
        
    function Logout($membername) {
        $mnumber = quickQuery('SELECT mnumber as result FROM ' . sql_table('member') . ' WHERE mname= ' . $membername);
        sql_query('DELETE FROM ' . sql_table('plug_wie') . ' WHERE memberid=' . $mnumber);
    }
    
    function doColors($word,$timeout) {
        $delta = ($timeout / $this->getOption('timeout')) * 240;    
        $col= 0 + $delta;
        $col = dechex($col);
        if (strlen($col) == 1) $col = '0' . $col;
        
        return '<span style="color: #'  . $col . $col . $col . '">' . $word . '</span>';
        
    }
}   

?>