<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_WordCount extends NucleusPlugin{
 	function getName()  { return 'WordCount'; }
    function getAuthor() { return 'Dave St.Germain'; }
    function getURL()     { return 'http://pobblelabs.org/software/nucleusplugins/'; }
    function getVersion() { return '0.1'; }
    function getDescription() {
        return 'returns the wordcount for an entry.';
    }
	function supportsFeature($what) {
		switch($what)
		{
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}
	var $_wordCount;
	function doTemplateVar(&$item, $param ='body') {
		echo $this->_wordCount($item->itemid, $param);
	}
	function _wordCount($id, $param = null) {
		$q = 'SELECT * FROM ' .sql_table('item') . ' WHERE inumber=' . $id;
		$result = sql_query($q);

		while($row = sql_fetch_object($result)) {
   			$bodysize  = str_word_count($row->ibody);
   			$bodysize += str_word_count($row->imore);
   			$titlesize = str_word_count($row->ititle);
		}
		$total = $bodysize + $titlesize;
		switch ($param) {
			case 'body':
				return $bodysize;
				break;
			case 'title':
				return $titlesize;
				break;
			case 'total':
				return $total;
				break;
			default:
				return $total;
				break;
		}
 	}
}
?>