<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_XMLTools extends NucleusPlugin {

	function getName() {	return 'XML Tools'; 	}
	function getAuthor()  { return 'Wouter Demuynck'; 	}
	function getURL() {		return 'http://nucleuscms.org/'; }
	function getVersion() {	return '1.0'; }
	function getDescription() { 
		return 'Some tools for XML-RSS generation. Use &lt;%XMLTools(body)%&gt; instead of &lt;%syndicate_description%&gt; in your template, and your RSS feed will be available in two versions: xml-rss.php (exerpts + wordcount) and xml-rss.php (full items)';
	}
	var $full,$countwords,$words;
	function init() {
		$this->full = (requestVar('full') == 'yes') ? 1 : 0;
		$this->countwords = ($this->getOption('countwords') == 'yes') ? 1 : 0;
		if ($this->countwords)
			$this->words = $this->getOption('words');
	}
	
	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

	function install() {
		$this->createOption('chars','How many chars to show?','text','200');
		$this->createOption('countwords','Add a wordcount?','yesno','yes');
		$this->createOption('words','excerpt... (10 _words_)','text','words');
	}
	
  function cutit($text, $maxlength, $toadd) {
    if ($maxlength==0) $maxlength=200;
    $text=strip_tags($text)." ";
  	if (strlen($text) > $maxlength) {
  	  $pos=strpos(substr($text,$maxlength)," ");
  	  if ($pos===false) $pos=0;
      $text = substr($text,0,$maxlength+$pos).$toadd;
    }
  	return $text;
  }
  
	function doTemplateVar(&$item, $what) {
		global $manager;
		switch ($what) {
			case 'body':
				if ($this->full) {
					$this->encode_xml($item->body);
					echo " ";
					$this->encode_xml($item->more);
				} else {
					$this->encode_xml($this->cutit($item->body,intval($this->getOption('chars')),'..'));
					if ($this->countwords) {
						echo ' (';
						$this->count_words($item->body." ".$item->more);
						echo ' ',$this->words,')';
					}
					
				}
				break;
			case 'atom':
				if ($this->full) {
					$this->encode_atom_xml($item->body);
					echo " ";
					$this->encode_atom_xml($item->more);
				} else {
					$this->encode_atom_xml($item->body);
				}
				break;
		}
	}
	
   function encode_xml(&$data) { 
      echo strip_tags(entity_to_decimal_value($data)); 
   }
	
   function encode_atom_xml(&$data) { 
      echo preg_replace('/<%(.*?)%>/','',entity_to_decimal_value($data)); 
   }

   function count_words($data) {
		echo sizeof(explode(' ',strip_tags($data)));
   }

} 

?>