<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

	$strRel = '../../../'; 
	include($strRel . 'cfg.php');
	global $member, $CONF;
	if (!$member->isLoggedIn() || !$member->isAdmin()) doError('You\'re not logged in.');
	$CONF['ItemURL']=$CONF['IndexURL'];
		
	include($DIR_LIBS . 'PLUGINADMIN.php');

	// create the admin area page
	$oPluginAdmin = new PluginAdmin('CommentControl');
	$oPluginAdmin->start();

	// get list of comments to approve
	$aList = $oPluginAdmin->plugin->_getPendingInfo();
	
	echo '<p><a href="index.php?action=overview">(',_BACKHOME,')</a></p>';
	echo '<h2>Comment Control</h2>';

	if (count($aList) > 0) {
		echo '<p>Below are the comments that are awaiting approval.</p>';

		echo '<table><tr>';
		echo '<th>Item Title &amp; Comment</th>';
		echo '<th>User</th>';
		echo '<th>Actions</th>';
		
		foreach ($aList as $aPendingInfo) {
			$urlallow	= $CONF['ActionURL'] . '?action=plugin&name=CommentControl&type=allow&id=' . $aPendingInfo['id'];
			$urldeny	= $CONF['ActionURL'] . '?action=plugin&name=CommentControl&type=deny&id=' . $aPendingInfo['id'];
		
			echo '</tr><tr>';		
			echo '<td>';
			echo '<a href="',createItemLink($aPendingInfo['itemid']),'"><strong>' , htmlspecialchars(shorten($aPendingInfo['itemtitle'],100,'...')), '</strong></a><br />';
			echo htmlspecialchars($aPendingInfo['comment']);
			echo '</td>';
			echo '<td>';
			echo htmlspecialchars(shorten($aPendingInfo['user'],50,'...'));
			echo '</td>';
			echo '<td>';
			echo '<a href="'.htmlspecialchars($urlallow).'">allow</a>';
			echo '<br />';
			echo '<a href="'.htmlspecialchars($urldeny).'">deny</a>';
			echo '</td>';
		}
		
		echo '</tr></table>';
		
	} else {
		echo '<p>There are currently no comments awaiting approval.</p>';
	}
	$oPluginAdmin->end();
	
?>