<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/
     
  function printTable(){
    global $pluginsextraskin;
    $query=sql_query('select tableid, title, description, url from '.sql_table('plug_extra_skin').' order by title asc');
    if (sql_num_rows($query)==0) {
      echo "<p>No extra skins defined yet</p>";
    } else {
      echo "<table><thead><tr>";
      echo "<th>Skin</th><th>Description</th><th colspan='2'>Structure</th><th>URL</th></tr></thead><tbody>";
      while ($row=sql_fetch_object($query)){
        echo "<tr onmouseover='focusRow(this);' onmouseout='blurRow(this);'>";
        $tableid=strval($row->tableid);
        echo "<td>".sql_unescape($row->title)." <a href='$pluginsextraskin/?action=edittemplate&amp;field=title&amp;id=$tableid&amp;text=0'>edit</a></td>";
        echo "<td>".sql_unescape($row->description)." <a href='$pluginsextraskin/?action=edittemplate&amp;field=description&amp;id=$tableid&amp;text=0'>edit</a></td>";
        echo "<td><a href='$pluginsextraskin/?action=edittemplate&amp;field=skin&amp;id=$tableid'>edit Skin</a></td>";
        echo "<td><a href='$pluginsextraskin/?action=deletetable&amp;id=$tableid'>delete skin</a></td>";
        echo "<td>".sql_unescape($row->url)." <a href='$pluginsextraskin/?action=edittemplate&amp;field=url&amp;id=$tableid&amp;text=0'>edit</a></td>";
        echo "</tr>";
      }
      echo "</tbody></table>";
    }
  }
  
  function printNew(){
    global $pluginsextraskin;
    echo "<form method='post' action='$pluginsextraskin/'><div>";
    echo "<table>";
    echo "<tr><td>Short skin name (only a-z,0-9,A-Z)</td><td><input name='plugintabletitle' type='text' value='' size='20' /></td></tr>";
    echo "<tr><td>Skin description</td><td><input type='text' name='plugintabledescription' value='' size='60' /></td></tr>";
    echo "<tr><td>Skin FancyURL (if defined)</td><td><input type='text' name='plugintableurl' value='' size='60' /></td></tr>";
    echo "</table>";
    echo "<input type='submit' name='plugintablesubmit1' value='Create new skin!' />";
    echo "</div></form>";
  }

  function _back(){
    echo "<p><a href='javascript:history.go(-1);' title='Previous page'>&raquo; Go Back</a></p>";
  }

  function _doError($s){
    echo "<h2>Error!</h2><p>$s</p>";
    _back();
    global $oPluginAdmin;
    $oPluginAdmin->end();
    die;
  }
    
  function createNewTable(){
    // check submitted data
    if (empty($_POST['plugintabletitle'])) _doError('No skin name specified');
    if (!ereg('^[0-9a-zA-Z]+$',$_POST['plugintabletitle'])) _doError('Bad skin name specified.');
    $query=sql_query("select count(*) as total from ".sql_table('plug_extra_skin')." where title='".$_POST['plugintabletitle']."'");
    $row=sql_fetch_object($query);
    if ($row->total>0) _doError('Skin name already exists!');
    // data seems to be ok
    $title=sql_escape(undoMagic($_POST['plugintabletitle']));
    $description=sql_escape(undoMagic($_POST['plugintabledescription']));
    $url=sql_escape(undoMagic($_POST['plugintableurl']));
    sql_query("insert into ".sql_table('plug_extra_skin')." (title,description,url) values ('$title','$description','$url')");
  }
  
  function deleteTable($tableid,$confirm=true){
    global $pluginsextraskin;
    $query=sql_query("select title, description from ".sql_table('plug_extra_skin')." where tableid=$tableid");
    if (!$row=sql_fetch_object($query)) return;
    if ($confirm){
      echo "<h2>Skin delete confirm</h2>";
      echo "<p><b>Skin name</b>: ".sql_unescape(strtoupper($row->title))."</p>";
      echo "<p><b>Description</b>: ".sql_unescape($row->description)."</p>";
      echo "<form method='post' action='$pluginsextraskin/'><div>";
      echo "<input type='submit' name='pluginsubmitfinaldelete' value='Delete this skin!' />";
      echo "<input type='hidden' name='plugintableid' value='$tableid' />";
      echo "</div></form>";
    } else {
      sql_query("delete from ".sql_table('plug_extra_skin')." where tableid=$tableid");
      echo "<h2>Skin deleted!</h2>";
    }
  }
  
  function editTemplate($tableid,$field){
    global $pluginsextraskin;
    $query=sql_query("select $field, title from ".sql_table('plug_extra_skin')." where tableid=$tableid");
    if (!$msg=sql_fetch_array($query)) return;
    echo "<h2>Edit skin part: ".$msg['title']." / $field</h2>";
    echo "<form method='post' action='$pluginsextraskin/'><div>";
    if ($_GET['text']=='0')
      echo "<div><input name='plugintabletemplate' size='60' value='".sql_unescape($msg[$field])."' /></div>";
    else
      echo "<textarea name='plugintabletemplate' rows='20' cols='70' >".htmlspecialchars(sql_unescape($msg[$field]))."</textarea><br />";
    echo "<input type='hidden' name='plugintableid' value='$tableid' />";
    echo "<input type='hidden' name='plugintablefield' value='$field' />";
    echo "<input type='submit' name='pluginsubmittemplate' value='Commit this change!' />";
    echo "</div></form>";
  }

  function saveTemplate($tableid,$field){
    echo "<h2>Saving skin template: $field</h2>";
    sql_query("update ".sql_table('plug_extra_skin')." set $field='".sql_escape(undoMagic($_POST['plugintabletemplate']))."' where tableid=$tableid");
    echo "<p>Template was saved...</p>";
  }

  
	$strRel = '../../../'; 
	include($strRel . 'cfg.php');
	global $member;
	if (!$member->isLoggedIn() || !$member->isAdmin()) doError('You\'re not logged in.');
	include($DIR_LIBS . 'PLUGINADMIN.php');

	global $pluginsextraskin, $CONF;
	$pluginsextraskin=$CONF['PluginURL']."extraskin";

	// create the admin area page
	$oPluginAdmin = new PluginAdmin('ExtraSkin');
	$oPluginAdmin->start();
	
	echo '<p><a href="index.php?action=overview">(',_BACKHOME,')</a></p>';
	
	// new table
	if (isset($_POST['plugintablesubmit1'])) createNewTable();

	// delete table
	if (isset($_POST['pluginsubmitfinaldelete'])) {
      deleteTable($_POST['plugintableid'],false);
      $oPluginAdmin->end();
      return;	
    }
	
	// edit template POST
	if (isset($_POST['pluginsubmittemplate'])) {
	  saveTemplate($_POST['plugintableid'],$_POST['plugintablefield']);
	  editTemplate($_POST['plugintableid'],$_POST['plugintablefield']);
      $oPluginAdmin->end();
      return;	
    }

	// actions GET
	if (isset($_GET['action'])){
		switch ($_GET['action']) {
			case 'deletetable': 
			deleteTable($_GET['id'],true);
			$oPluginAdmin->end();
			return;
			break;
			case 'edittemplate': 
			editTemplate($_GET['id'],$_GET['field']);
			_back();
			$oPluginAdmin->end();
			return;
			break;
		}
	}

	// plugin headline
	echo "<h2>Extra-Skins Creation</h2>";

	// print table
	echo "<h3>Existing Extra-Skins</h3>";
	printTable();
  
	// new table
	echo "<h3>Create New Extra-Skin</h3>";
	printNew();

	$oPluginAdmin->end();
?>