<?php
/*
 * FastSHL                              | Universal Syntax HighLighter |
 * ---------------------------------------------------------------------

   Copyright (C) 2002-2003  Juraj 'hvge' Durech

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
   
 * ---------------------------------------------------------------------
 * HTML_output.php		STANDARD HTML output module
 */

class HTML2_output
{
	var $last_class;
	
	function HTML2_output() 
	{
		$this->last_class = null;
                        /* P H P */
                $this->style['php-keyword1'] = 'color:#d24; font-weight:bold;';
                $this->style['php-keyword2'] = 'color:#d24; ';
                $this->style['php-var'] = 'color:#fa0; font-weight:bold;';
                $this->style['php-num'] = 'color:red;';
                $this->style['php-quote'] = 'color:#843; font-weight:bold;';
                $this->style['php-vquote'] = 'color:#fa0;';
                $this->style['php-comment'] = 'color:#999; background-color:#ffe;';

                        /* H T M L */
                $this->style['html-tag'] = 'color:#598527; font-weight:bold;';
                $this->style['html-tagin'] = 'color:#89A315';
                $this->style['html-quote'] = 'color:#598527; font-weight:bold;';
                $this->style['html-comment'] = 'color:#999; background-color:#F1FAE4;';
                $this->style['html-entity'] = 'color:#89A315';

                        /* C S S */
                $this->style['css-class'] = 'color:#004A80; ';
                $this->style['css-id'] = 'color:#7DA7D9; font-weight:bold; ';
                $this->style['css-def'] = 'color:#5674B9;';
                $this->style['css-property'] = 'color:#003663; font-weight:bold; ';
                $this->style['css-value'] = 'color:#448CCB;';
                $this->style['css-color'] = 'color:#0076A3;';
                $this->style['css-comment'] = ' background-color:#E5F8FF; color:#999; ';
                        
                        /* C P P */
                $this->style['cpp-keywords1'] = 'color:blue; font-weight:bold;';
                $this->style['cpp-num'] = 'color:red;';
                $this->style['cpp-quote'] = 'color:brown; font-weight:bold;';
                $this->style['cpp-comment'] = 'color:green;';
                $this->style['cpp-preproc'] = 'color:grey;';

                        /* J A V A */
                $this->style['java-keywords1'] = 'color:blue; font-weight:bold;';
                $this->style['java-num'] = 'color:red;';
                $this->style['java-quote'] = 'color:brown; font-weight:bold;';
                $this->style['java-comment'] = 'color:green;';
                $this->style['java-preproc'] = 'color:grey;';

                        /* J a v a S c r i p t */
                $this->style['js-out'] = 'color:#898993;';
                $this->style['js-keywords1'] = 'color:#575757; font-weight:bold;';
                $this->style['js-num'] = 'color:#575757;';
                $this->style['js-quote'] = 'color:#575757; font-weight:bold;';
                $this->style['js-comment'] = 'color:#898993; background-color:#F4F4F4;';

                        /* S Q L */
                $this->style['sql-keyword1'] = 'color: #DD0000; font-weight: bold;';
                $this->style['sql-keyword2'] = 'color: #DD2222;';
                $this->style['sql-keyword3'] = 'color: #0000FF; font-weight: bold;';
                $this->style['sql-value'] = 'color: #5674B9;';
                $this->style['sql-comment'] = 'color: #FFAA00;';
                $this->style['sql-num'] = 'color:red;';
                $this->style['sql-option'] = 'color: #004A80; font-weight: bold;';

                        /* C O M M O N */
                $this->style['normal'] = 'color:black;';
                $this->style['xlang'] = 'color:red; font-weight:bold;';
                $this->style['count'] = 'color:black; background-color:#FFF;';
	}
		
	function & template ($word, $class)
	{
		$word = htmlentities($word);

		if ($this->last_class == $class)
		{
			return $word;			
		}
		else
		{
			if($this->last_class == null)
			{
				$this->last_class = $class;
				return '<span style="'.$this->style[$class].'">'.$word;
			}
			$this->last_class = $class;
			if($class == null) return '</span>'.$word;
			return '</span><span style="'.$this->style[$class].'">'.$word;
		}	
	}

	function & template_end()
	{
		if($this->last_class != null) {
			$this->last_class = null;
			return '</span>';
		} else {
			return null;
		}
	}

	// default keyword is the same as template(), but you can add your own
	// postprocess. 
	function & keyword ($word, $class)
	{
		$word = htmlentities($word);

		if ($this->last_class == $class)
		{
			return $word;			
		}
		else
		{
			if($this->last_class == null)
			{
				$this->last_class = $class;
				return '<span style="'.$this->style[$class].'">'.$word;
			}
			$this->last_class = $class;
			if($class == null) return '</span>'.$word;
			return '</span><span style="'.$this->style[$class].'">'.$word;
		}		
	}


} //END class HTML_output

?>