<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

	include('../../../cfg.php');
	global $manager, $blog, $CONF, $DIR_PLUGINS;
	if (!is_dir($DIR_PLUGINS)) die;
	$CONF['ItemURL']=$CONF['IndexURL'];

	$itemid = intval(getVar('itemid'));
	$res = sql_query('SELECT iblog FROM '.sql_table('item').' WHERE inumber='.intval($itemid));
	$obj = sql_fetch_object($res);
	$blogid = $obj->iblog;
	$b =& $manager->getBlog($blogid);

	global $Blogname;  
    $Blogname = $b->getName();

    // Get the original plugin again ...
    $plugin =& $manager->getPlugin('NP_MailToAFriend');
    if ($plugin) {
        $extra = $plugin->getOption('defaultMessage');
        $template = $plugin->getOption('template');
    }
    
    dohtmlHead();

	$ok=false;
    if (isset($_POST['confirm'])) {
		$inHTML=postVar('inHTML');
		$toEmail = postVar('toEmail');
		$fromEmail = postVar('fromEmail');
		$toName = postVar('toName');
		$fromName = postVar('fromName');
		$extra = postVar('extra');
        $ok = ( isValidMailAddress($toEmail) == 1 );
		if (!$ok) showError("Please enter a valid TO email address!",$toEmail);
        if ($ok) {
			$ok = ( isValidMailAddress($fromEmail) == 1 );
			if (!$ok) showError("Please enter a valid FROM email address!",$fromEmail);
		}
    }

    if (!$ok) {
        showForm();
        $extraQuery = ' and inumber=' . intval($itemid);
        if ($template == "") $template  = "default";
        echo "<div>";
        $b->readLogAmount($template, 1, $extraQuery, 0, 1, 0);
        echo "</div>";
    } else { 
    	$query =  'SELECT i.inumber as itemid, i.ititle as title, i.ibody as body, m.mname as author, m.mrealname as authorname, UNIX_TIMESTAMP(i.itime) as timestamp, i.imore as more, m.mnumber as authorid, m.memail as authormail, m.murl as authorurl, c.cname as category, i.icat as catid, i.iclosed as closed'
	            . ' FROM '.sql_table('item').' as i, '.sql_table('member').' as m, '.sql_table('category').' as c'
	            . ' WHERE inumber=' . intval($itemid);
        $items = sql_query($query);
    	$item = sql_fetch_object($items);
        $message = makeMessage($item,$inHTML);
        $to = $toEmail;
        if (!$toName == "") 
			$to = "\"".$toName."\"<".$toEmail.">";
        $from = "From: ".$fromEmail;
        if ($inHTML == "on")
            $from .= " \nContent-Type: text/html; charset="._CHARSET;
        else
            $from .= " \nContent-Type: text/plain; charset="._CHARSET;
        @mail($to,
              str_replace(":","\:",$Blogname)." --- ".$item->title,
	          $message,
    	      $from 
            );
        echo "<h3>Thank you. Your message was sent to: ".$to."</h3>\n";
		echo "<p><a href=\"javascript:window.close();\">close window</a></p>\n";
    }
    dohtmlEnd();
    
function showError($message, $what) {
    echo "Error: <span style='color:red'>\n".$what.$message."</span><br />\n";
}

function dohtmlHead() {
    global $Blogname, $CONF;
    echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\"> \n <html> \n<head>";
    echo "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset="._CHARSET."\">";
    echo "<title>Email this article :: ".$Blogname. "::</title> \n";
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"".$CONF['AdminURL']."plugins/mailtoafriend/mailfriend.css\">";
    echo "<base href=\"".$CONF['IndexURL']."\">";
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"".$CONF['AdminURL']."plugins/mailtoafriend/mailfriend.css\"> \n";
    echo "</head> \n";
    echo "<body> \n";
}

function dohtmlEnd() {
    echo '</body></html>';
}

function showForm () {
    global $toEmail, $fromEmail, $toName, $fromName, $extra, $itemid, $inHTML, $CONF;
    echo "<form method=\"post\" action=\"".$CONF['AdminURL']."plugins/mailtoafriend/mailfriend.php?itemid=".$itemid."\"> \n";
    echo "<table class=\"formfriendtable\">\n";
    echo "<tr class=\"formfriendrow\"><td class=\"formfriendcell\">\n";
    echo "To [email]:</td><td class=\"formfriendcell\">\n";
    echo "<input type=\"text\" name=\"toEmail\" value=\"".$toEmail. "\"/>\n";
    echo "</td><td rowspan=\"4\">Message: <br />"
         . "<textarea name=\"extra\" rows=\"5\" cols=\"30\" id=\"extra\">".$extra."</textarea>"
         ."</td>\n";
    echo "</tr><tr class=\"formfriendrow\"><td class=\"formfriendcell\">From [email]:\n";
    echo "</td><td class=\"formfriendcell\">\n";
    echo "<input type=\"text\" name=\"fromEmail\" value=\"".$fromEmail."\" />\n";
    echo "</td></tr><tr class=\"formfriendrow\"><td class=\"formfriendcell\">To [name]:\n";
    echo "</td><td class=\"formfriendcell\"><input type=\"text\" name=\"toName\" value=\"".$toName."\" />\n";
    echo "</td></tr><tr class=\"formfriendrow\"><td class=\"formfriendcell\">From [name]:\n";
    echo "</td><td class=\"formfriendcell\"><input type=\"text\" name=\"fromName\" value=\"".$fromName."\" />\n";
    echo "</td></tr><tr class=\"formfriendrow\"><td class=\"formfriendcell\" >&nbsp;</td><td class=\"formfriendcell\">\n";
    echo "<input type=\"checkbox\" name=\"inHTML\" checked=\"checked\"> HTML email</input></td><td class=\"formfriendcell\">\n";
    echo "<input type=\"submit\" value=\"Send email!\" name=\"confirm\" /></td></tr></table></form>\n";
}

function _toAscii(&$data) { 
  return str_replace("\n","",strip_tags(entity_to_decimal_value($data))); 
}

function makeMessage(&$item,$htmlMail) {
    global $itemid, $CONF;
    if ($htmlMail == "on") {
        $body = "<html><head>"
		       ."<meta http-equiv=\"Content-Type\" content=\"text/html; charset="._CHARSET."\">"
               ."<link rel='stylesheet' type='text/css' href='".$CONF['AdminURL']."plugins/mailtoafriend/mailfriend.css'>"
               ."<base href=\"".$CONF['IndexURL']."\">"
               ."</head><body>";
        $body .= "<div class='item'>"
              . $extra ."<br />"
              . "<h4><a href=\"".fancyLink($itemid)."\">".$item->title."</a></h4>"
              . "<div class='body'>".$item->body.$item->more."</div>"
			  . "</div></body></html>";
    } else {
		// create text version of html post
		$body = $extra ."\n\n";
		$body .= fancyLink($itemid) ."\n\n";
		$body .= $item->title ."\n\n";
		$body .= _toAscii($item->body);	
		$body .= "\n\n" . _toAscii($item->more);
    }
    return $body;
}

?>