<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN, Rodrigo Moraes
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

function printTable($limit=20) {
	global $poll, $member, $_GET;

	if ($_GET['action'] != 'allpolls') $where = " WHERE pauthor=" . $member->getID();

	echo "<form method='post' action='$poll/index.php?action=newpoll'><p>";
	echo "<input type='hidden' name='pnumber' value='0' />";
	echo "<input type='submit' name='editpoll' value='"._NEW_POLL."' />";
	echo "</p></form>";
	
	if ($_GET['action'] == 'allpolls') {
		$allpolls = "<a href='$poll/index.php'>"._MY_POLLS."</a>";
	}
	else {
		$allpolls = "<a href='$poll/index.php?action=allpolls'>"._ALL_POLLS."</a>";
	}

  if (isset($_POST['offset'])) 
    $offset=intval($_POST['offset'])-1; 
  else
    if (isset($_GET['offset'])) 
      $offset=intval($_GET['offset']); 
    else 
      $offset='0';
	$query = sql_query("SELECT * FROM ". sql_table('plug_polladmin') . $where . " ORDER by pnumber DESC LIMIT $offset,$limit");
	if (sql_num_rows($query)==0) {
		echo "<p>"._NO_POLLS_YET."</p>";	
		echo $allpolls;
	}
	else {
    
    global $poll;
    if ($_GET['action']=='allpolls') $add="&amp;action=allpolls"; else $add="";
    echo "<table style='width:100%'><tr>";
    $v=intval($offset)-$limit;
    if ($v<0) $v=0;
    echo "<td><form method='post' action='$poll/?offset=$v$add'><div><input type='submit' value='&laquo; "._PREVIOUS."' /></div></form></td>";
    $v=intval($offset)+$limit;
    echo "<td>"._RANGE.strval(intval($offset)+1)." - ".strval(intval($offset)+$limit)."</td>";
    $howmuch = sql_query("SELECT * FROM ". sql_table('plug_polladmin').$where );
    $howmuchrows=sql_num_rows($howmuch);
    echo "<td><form method='post' action='$poll/?$add'><div><input type='text' value='".strval(intval($offset)+1)."' size='5' name='offset' /></div></form></td>";
    if ($v>$howmuchrows) $v=$howmuchrows-$limit+1;
    echo "<td style='text-align:right;'><form method='post' action='$poll/?offset=$v$add'><div style='text-align:right;'><input type='submit' value='"._NEXT." &raquo;' /></div></form></td>";
    echo "</tr></table>";

		echo $allpolls;
		echo "<table><thead><tr>";
		echo "<th style='width:90px;'>"._POLL_CODE."</th>";
		echo "<th>"._POLLS."</th><th style='width:120px;'>"._POLL_AUTHOR."</th><th style='width:120px;'>". _POLL_ADM ."</th></tr></thead><tbody>";
		
		while ($row=sql_fetch_object($query)) {
			$pnumber = $row->pnumber;
			$pauthor = $row->pauthor;
			$pitem = $row->pitem;
			$pquestion = sql_unescape($row->pquestion);
			$poptions = $row->poptions;
			$pvalues = $row->pvalues;
			$pstart = $row->pstart;
			$pend = $row->pend;
			$pclosed = $row->pclosed;
	
			echo "<tr onmouseover='focusRow(this);' onmouseout='blurRow(this);'>";
			echo "<td><form><p style='margin:0;'><input type='text' name='poll" . $pnumber . "' size='10' value='!++" . $pnumber . "++!' style='font-family:verdana,sans-serif; size:small;' readonly='readonly' onFocus='javascript:this.form.poll" . $pnumber . ".select();'/></p></form></td>";
			echo "<td>" . $pquestion . "</td>";

			$mem = new MEMBER;
			$mem->readFromID(intval($pauthor));
			$authorname = $mem->getDisplayName(); 

			echo "<td>" . $authorname . "</td>";
			echo "<td>";
			echo "<a href='$poll/index.php?action=viewpoll&amp;id=$pnumber'>"._VIEW."</a>";

			if ($pauthor == $member->getID()) {
				echo " | <a href='$poll/index.php?action=editpoll&amp;id=$pnumber'>"._CHANGE."</a>";
			}
			echo "</td>";
			echo "</tr>";
		}
		echo "</tbody></table>";
		echo "<p>"._POLL_INSTRUCTIONS."</p>";
	}
}

function editPoll($pnumber) {
	global $member, $poll;

	if ($pnumber == 0) {
		$pnumber = "0";
		$header = _NEW_POLL;
	}
	else {
		$header = _CHANGE_POLL; 

		$query = sql_query("SELECT * FROM ". sql_table('plug_polladmin') ." WHERE pnumber=". $pnumber);
		while ($row=sql_fetch_object($query)) {
			$pauthor = $row->pauthor;
			if ($pauthor != $member->getID()) {
				_doError(_IS_NOT_AUTHOR);
			}

			$pquestion = sql_unescape($row->pquestion);
			$poptions = $row->poptions;
			$pclosed = $row->pclosed;
		}
	}

	echo "<form method='post' action='$poll/index.php'><p>";
	echo "<table>";
	echo "<thead><tr><th colspan='2'>";
	echo $header;
	echo "</th></tr></thead><tbody>";
	
	echo "<tr><td colspan='2'>"._POLL_QUESTION."<br />";
	echo "<textarea name='pquestion' rows='2' cols='50' style='font-family:verdana,sans-serif;font-size:small;'>". $pquestion ."</textarea>";
	echo "</td></tr>";
	echo "<tr><td colspan='2'>"._POLL_ANSWERS."<br />";
	echo "<textarea name='poptions' rows='7' cols='50' style='font-family:verdana,sans-serif;font-size:small;'>"; 
	if ($pnumber != 0) {	
		$aOptions = unserialize(base64_decode($poptions));
		foreach($aOptions as $newoption => $value) {
			if (trim($newoption)) {
				echo $newoption."\n";
			}
		}
	}		
	echo "</textarea>";
	if ($pnumber != 0) {	
	echo "<br />"._ANSWERS_MESSAGE;
	}
	echo "</td></tr>";
	echo "<tr><td colspan='2'>";
	echo "<input type='radio' name='pclosed' value='0'";
	if ($pclosed == 0) echo " checked='checked'";
	echo "/>"._ACTIVE_POLL;
	echo "<input type='radio' name='pclosed' value='1'";
	if ($pclosed == 1) echo " checked";
	echo "/>"._INACTIVE_POLL;
	echo "</td></tr></tbody></table>";
	echo "<input type='hidden' name='pnumber' value='" . $pnumber . "'/>";
	echo "<input type='hidden' name='pauthor' value='" . $member->getID() . "'/>";
	echo "<input type='submit' name='savepoll' value='"._SAVE."'/>";
	echo "</p></form>";

}

function savePoll($pnumber) {
	global $_POST;

	if ($pnumber == 0) {

		$poptions = explode('<br />',nl2br(trim($_POST['poptions'])));
		
		foreach ($poptions as $poption) {
			$poption = trim($poption);
			$aOptions[$poption] = '0';
		}
		$options  = base64_encode(serialize($aOptions));

		sql_query("insert into ". sql_table('plug_polladmin') ." (pauthor, pquestion, poptions, pclosed) VALUES (". $_POST['pauthor'] .", '". sql_escape(trim($_POST['pquestion'])) ."', '". $options ."', ". $_POST['pclosed'] .")");
		echo "<div class='note'>"._POLL_CREATED."</div><br />";
	}

	else {
		$poptions = explode('<br />',nl2br(trim($_POST['poptions'])));
		foreach ($poptions as $poption) {
			$poption = trim($poption);
			if ($poption) {
			$aOptions[$poption] = '0';
			}
		}
		
		$query=sql_query("SELECT poptions FROM ". sql_table('plug_polladmin') ." WHERE pnumber=".$pnumber);
		if ($msg=sql_fetch_array($query)) {
			$oldoptions = unserialize(base64_decode($msg['poptions']));
		}

		foreach ($oldoptions as $oldoption => $value) {
			if ($aOptions[$oldoption] == '0') {
				$aOptions[$oldoption] = $value;
			}
		}
		
		$options  = base64_encode(serialize($aOptions));

		sql_query("UPDATE ". sql_table('plug_polladmin') ." SET pquestion='". sql_escape(trim($_POST['pquestion'])) ."', poptions='". $options ."', pclosed=". $_POST['pclosed'] ." WHERE pnumber=". $pnumber);
		echo "<div class='note'>"._POLL_CHANGED."</div><br />";
	}
}

function viewPoll($id) {
	global $member, $poll;

	$query=sql_query("SELECT * FROM ". sql_table('plug_polladmin') ." WHERE pnumber=".$id);
	while($row = sql_fetch_object($query)) {
		$pauthor  = $row->pauthor;
		$pnumber  = $row->pnumber;
		$pquestion = sql_unescape($row->pquestion);
		$aOptions = unserialize(base64_decode($row->poptions));
		$pclosed = $row->pclosed;
		$pitem = $row->pitem;
	}

	$mem = new MEMBER;
	$mem->readFromID(intval($pauthor));
	$authorname = $mem->getDisplayName(); 

	echo "<h3>". _POLL_BY . $authorname ."</h3>";
	echo "<form>";
	echo "<p><strong>$pquestion</strong></p>";
	$total = 0;
	foreach ($aOptions as $poption => $value) {
	  $poption=trim($poption);
		if ( !empty($poption) ) {
			echo "<input type='radio' />";
			echo $poption."<br />";
			$total=$total+intval($value);
		}
	}
	if ($pauthor == $member->getID()) 
		echo "<br /><a href='$poll/index.php?action=editpoll&amp;id=$pnumber'>"._CHANGE_POLL."</a>";
	echo "<h3>". _POLL_INFO ."</h3>";
	echo _POLL_STATUS;
	if ($pclosed == 0) echo _ACTIVE_POLL;	else echo _INACTIVE_POLL;
	echo "<br />"._POLL_VOTES.$total; 
	if ($pitem>0){
	  global $CONF;
	  echo "<br />"._POLL_ITEMNUMBER."<a href='".$CONF['IndexURL'].fancyLink($pitem)."'>".$pitem."</a>"; 
	}
	echo "<br />"._THIS_CODE;
	echo "<input type='text' name='poll" . $pnumber . "' size='20' value='!++" . $pnumber . "++!' style='font-family:verdana,sans-serif; size:small;' readonly='readonly' onFocus='javascript:this.form.poll" . $pnumber . ".select();'/>";
	echo "</form>";
	echo _POLL_VIEW_TIP;

}

$strRel = '../../../'; 
include($strRel . 'cfg.php'); 

global $DIR_PLUGINS;
if (!is_dir($DIR_PLUGINS)) die("Configuration error: ".$DIR_PLUGINS);
if (!is_dir($DIR_LIBS)) die("Configuration error: ".$DIR_LIBS);

global $member;
if (!$member->isLoggedIn()) doError(_IS_NOT_LOGGED_IN);
include($DIR_LIBS . 'PLUGINADMIN.php');

include($DIR_PLUGINS.'poll/lang/index.php');

global $poll, $CONF;
$poll=$CONF['PluginURL']."poll";

// create the admin area page 
$oPluginAdmin = new PluginAdmin('Poll'); 
$oPluginAdmin->start(); 

echo '<p><a href="index.php?action=overview">(',_BACKHOME,')</a></p>';
echo "<h2>"._POLL_ADMIN."</h2>";

// new poll
if (isset($_POST['newpoll'])) {
	editPoll($_POST['pnumber']);
	_back();
	$oPluginAdmin->end();
	return;
}

// edit poll
if (isset($_POST['editpoll'])) {
	editPoll($_POST['pnumber']);
	_back();
	$oPluginAdmin->end();
	return;
}

// save poll
if (isset($_POST['savepoll'])) {
	savePoll($_POST['pnumber']);
	printTable(10);
	$oPluginAdmin->end();
	return;
}

// actions GET
if (isset($_GET['action'])) {
	switch ($_GET['action']) {
		case 'editpoll':
			editPoll(intval($_GET['id']));
			_back();
			$oPluginAdmin->end();
			return;
			break;

			case 'viewpoll':
			viewPoll(intval($_GET['id']));
			_back();
			$oPluginAdmin->end();
			return;
			break;

	}
}

// error handling
function _back() {
	echo "<p><a href='javascript:history.go(-1);' title='"._BACK."'>&laquo; "._BACK."</a></p>";
}

function _doError($s) {
	echo "<h3>"._ERROR."</h3><p>$s</p>";
	_back();
	global $oPluginAdmin;
	$oPluginAdmin->end();
	die;
} 

printTable(10);
$oPluginAdmin->end(); 

?>