/*
	Easydynfont 
	Version 1.0
	written by Chris Heilmann
	please refer to the homepage at http://www.onlinetools.org/tools/easydynfont.php 
*/

// Standard setting, separate fonts with "," and make sure to set standardfont
// and size to avoid errors
var fonts="Arial,Courier,Georgia,Lucida,Tahoma,Times New Roman,Verdana,lucida,Lucida Grande CE,sans-serif,serif".split(",");
var standardfont="Arial"   
var standardsize="90%"
var nosave=false; 

/* 
	function drawform()
	adds the standard form to the document.
*/
function drawform(){
    if (!document.layers){
	document.write("<form action=\"/\" name=\"dynform\">");
	document.write("<select name=\"typeface\" onchange=\"setFont(this.options[this.selectedIndex].value)\">");
	for (i=0;i<fonts.length;i++){
		document.write("	<option value=\""+fonts[i]+"\">"+fonts[i]+"</option>");
	}
	document.write("</select><br>");
//	document.write("<input type=\"button\" class=\"dynbutton\" onclick=\"addSize(-10)\" value=\"smaller\" />");
//	document.write("<input type=\"button\" class=\"dynbutton\" onclick=\"addSize(10)\" value=\"larger\" />");
//	document.write("<input type=\"checkbox\" name=\"nosave\" /><span>Don't store as default.</span>");
//	document.write("</form>");
	}
}

/* 
	function init()
	loads the cookiedata and changes the document accordingly, if there is no 
	cookie, sets the standard settings and stores it 
*/
function init(){
    if (!document.layers){
	size=getCookie("dynfontsize");
	if (size!=null){
		c=size.split(":");
		document.getElementsByTagName("body").item(0).style.fontSize=c[0];
		document.getElementsByTagName("body").item(0).style.fontFamily=c[1];
	}
	if (size==null || c[0]=="" || c[1]==""){
		document.getElementsByTagName("body").item(0).style.fontSize=standardsize;
		document.getElementsByTagName("body").item(0).style.fontFamily=standardfont;
		storeSize()
		}
	}
	// Special setting, if you want to use the "don't save" chekbox
	nosave=document.dynform.nosave.checked
}		
/* 
	function addSize(add)
	increases the size of the document font by "add", negative values make the 
	font smaller.
*/
function addSize(add){
    if (!document.layers){
	doc = document.getElementsByTagName("body").item(0)
	size=parseInt(doc.style.fontSize)+add;
	doc.style.fontSize=size+"%";
	if (nosave==false) storeSize()
	}
}
/* 
	function SetSize(add)
	sets the font size of the document.
*/
function setSize(add){
    if (!document.layers){
	document.getElementsByTagName("body").item(0).style.fontSize=add+"%";
	if (nosave==false) storeSize() 
	}
}

/* 
	function SetFont(add)
	sets the font face of the document.
*/
function setFont(add){
    if (!document.layers){
	doc = document.getElementsByTagName("body").item(0)
	doc.style.fontFamily=add;
	if (nosave==false) storeSize()
	}
}

/* 
	function storeSize()
	saves the current settings of the document in a cookie
*/
function storeSize(){
	var exp = new Date();
	exp.setTime(exp.getTime() + 24*60*60*90*1000);
	size=document.getElementsByTagName("body").item(0).style.fontSize;
	font=document.getElementsByTagName("body").item(0).style.fontFamily;
	setCookie("dynfontsize",size+":"+font,exp);
}
/* 
	function setCookie()
	sets the cookie
*/
function setCookie(name, value, expires, path, domain, secure) { 
	var curCookie = name + "=" + escape(value) + 
	((expires) ? "; expires=" + expires.toGMTString() : "") + 
	((path) ? "; path=" + path : "") + 
	((domain) ? "; domain=" + domain : "") + 
	((secure) ? "; secure" : "") 
	document.cookie = curCookie 
} 
/* 
	function getCookie()
	reads the cookie
*/
function getCookie(name) { 
	var prefix = name + "=" 
	var cookieStartIndex = document.cookie.indexOf(prefix) 
	if (cookieStartIndex == -1) 
	return null 
	var cookieEndIndex = document.cookie.indexOf(";", cookieStartIndex + 
	prefix.length) 
	if (cookieEndIndex == -1) 
	cookieEndIndex = document.cookie.length 
	return unescape(document.cookie.substring(cookieStartIndex + 
	prefix.length, 
	cookieEndIndex)) 
}
