<?php


require_once dirname(__FILE__).'/texy-compact.php'; // texy
include_once dirname(__FILE__).'/../fshl/fshl.php'; // highlighter FSHL




class MyTexy extends Texy {
  var $utf = true;  // enable UTF-8



  function MyTexy()
  {
    parent::Texy();
    global $CONF;
      
      // classes  
    $this->imageModule->leftClass      = 'left'; 
    $this->imageModule->rightClass     = 'right';
    $this->imageDescModule->leftClass  = 'left'; 
    $this->imageDescModule->rightClass = 'right';

      // directories & others
    $this->imageModule->root = $this->imageModule->linkedRoot = $CONF['MediaURL'];
    $this->headingModule->top = 2;
    $this->smiliesModule->root    = $CONF['PluginURL'] . 'texy/smilies/'; 
    $this->smiliesModule->class   = 'smiley';     
  }
  
  

  function useHighlighter() {
    if (class_exists('fshlParser')) 
      $this->blockModule->codeHandler = array(&$this, 'callbackSyntaxHighlight'); 
  }





  // this is user callback function for processing inlin `code` or block @code 
  function callbackSyntaxHighlight(&$element)
  {
    $lang = strtoupper($element->lang);
    if ($lang == 'JAVASCRIPT') $lang = 'JS';

    if (in_array($lang, array('CPP', 'CSS', 'HTML', 'JAVA', 'PHP', 'JS', 'SQL'))) {        
      $parser = new fshlParser($element->texy->utf ? 'HTML2_UTF8' : 'HTML2', P_TAB_INDENT);
      $element->setContent($parser->highlightString($lang, $element->content), true);
    }
  }


  
  function protectNucleusTags() {
    $this->phraseModule->registerLinePattern('processProtect', '#(<%.*%>)#U', true);
  }


}


?>