<?php
/*************************************************************************************
** - Copyright (c) 2006 Belus Technology Inc.
** - 
** - By using the software and documentation, the user expressly agrees that
** - the use of the software documentation is at its sole risk. The software
** - and documentation is made available on an "as is" basis. Copyright owner
** - does not warrant that the software and documentation will meet the user's
** - requirements, or that the operation of the software will be uninterrupted
** - or error-free and does not make any warranty whatsoever regarding the
** - software and documentation, any information, services or products provided
** - through or in connection with the software and documentation, or any
** - results to be obtained through the use thereof, and hereby expressly
** - disclaims on behalf of itself and all suppliers any and all warranties,
** - including without limitation: any express or implied warranties of:
** - 1) merchantability; 2) fitness for a particular purpose; 3) effort to
** - achieve purpose; 4) quality; 5) accuracy; 6) non-infringement. Copyright
** - owner shall not be liable to the user, or to any third party, for any loss
** - of data, profits, loss of use, interruption of business, error, omission,
** - deletion, defect, delay in operation or transmission, computer virus,
** - communications line failure, theft or destruction or unauthorized access to,
** - alteration of, or use of records, whether for breach of contract, tortious
** - behavior, negligence, or under any other cause of action. 
** - 
** - All right, title and interest including, but not limited to, copyright and
** - other intellectual property rights in and to the software and documentation
** - are owned by Copyright owner and the use of or modification to the software
** - and documentation does not pass to the user any title to or any proprietary
** - rights in the software and documentation.
** - 
** - Permission is granted to copy, modify and distribute the software and
** - documentation for any purpose and royalty-free, subject to the following:
** - copyright and other intellectual property rights in and to the software and
** - documentation must not be misrepresented and this notice may not be removed
** - from any source distribution of the software or documentation.
*************************************************************************************/

/****************************************************************************************
** - Purpose: Directory
** - Version: 1.10
** - Date: 2006-04-10
** - Documentation: http://xstandard.com/xstandard-lite-for-partner-cms/
** -
** - This script is designed to work with ISO-8859-1 character set. You may need to modify
** - this script to work with other character sets.
****************************************************************************************/

if (get_magic_quotes_runtime() != 0) {
	set_magic_quotes_runtime(0);
}

function xs_xhtml_escape($text) {
	return str_replace(array("&", "<", ">", "\""), array("&amp;", "&lt;", "&gt;", "&quot;"), $text);
}

function read_from_file($path) {
	return @file_get_contents($path);
}



//Process request
$id = "";
$metadata = "";

//Get ID.
if (isset($_GET['x-cms-directory-id'])) {
	$id = stripslashes($_GET['x-cms-directory-id']);
}

//Get metadata.
if (isset($_GET['x-cms-directory-metadata'])) {
	$metadata = stripslashes($_GET['x-cms-directory-metadata']);
}




// Respond
header("Content-Type: text/xml");
echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
echo "<library>";
	echo "<containers>";
		// Process folders
		if ($id == "") {
			echo ("<container>");
				echo ("<label>Latin 1 characters</label>");
				echo ("<id>c</id>");
				echo ("<metadata></metadata>");
				echo ("<location>cms-directory-xhtml-latin1.xml</location>");
				echo ("<icon></icon>");
			echo ("</container>");
			echo ("<container>");
				echo ("<label>Special symbols</label>");
				echo ("<id>c</id>");
				echo ("<metadata></metadata>");
				echo ("<location>cms-directory-xhtml-symbol.xml</location>");
				echo ("<icon></icon>");
			echo ("</container>");
			echo ("<container>");
				echo ("<label>Special signs</label>");
				echo ("<id>c</id>");
				echo ("<metadata></metadata>");
				echo ("<location>cms-directory-xhtml-special.xml</location>");
				echo ("<icon></icon>");
			echo ("</container>");
		}
	echo "</containers>";
echo "</library>";
?>