DROP TABLE IF EXISTS `nucleus_actionlog`;
CREATE TABLE IF NOT EXISTS `nucleus_actionlog` (
  `timestamp` datetime NOT NULL default '0000-00-00 00:00:00',
  `message` varchar(255) NOT NULL default ''
) TYPE=MyISAM COMMENT='Action log';

DROP TABLE IF EXISTS `nucleus_ban`;
CREATE TABLE IF NOT EXISTS `nucleus_ban` (
  `iprange` varchar(15) NOT NULL default '',
  `reason` varchar(255) NOT NULL default '',
  `blogid` int(11) NOT NULL default '0'
) TYPE=MyISAM COMMENT='Banned users from comments';

DROP TABLE IF EXISTS `nucleus_blog`;
CREATE TABLE IF NOT EXISTS `nucleus_blog` (
  `bnumber` int(11) NOT NULL auto_increment,
  `bname` varchar(60) NOT NULL default '',
  `bshortname` varchar(15) NOT NULL default '',
  `bdesc` varchar(200) default NULL,
  `bcomments` tinyint(2) NOT NULL default '1',
  `bmaxcomments` int(11) NOT NULL default '0',
  `btimeoffset` decimal(3,1) NOT NULL default '0.0',
  `bnotify` varchar(60) default NULL,
  `burl` varchar(100) default NULL,
  `bupdate` varchar(60) default NULL,
  `bdefskin` int(11) NOT NULL default '1',
  `bpublic` tinyint(2) NOT NULL default '1',
  `bsendping` tinyint(2) NOT NULL default '0',
  `bconvertbreaks` tinyint(2) NOT NULL default '1',
  `bdefcat` int(11) default NULL,
  `bnotifytype` int(11) NOT NULL default '15',
  `ballowpast` tinyint(2) NOT NULL default '0',
  `bincludesearch` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`bnumber`),
  UNIQUE KEY `bshortname` (`bshortname`),
  UNIQUE KEY `bnumber` (`bnumber`)
) TYPE=MyISAM COMMENT='Blogs';

DROP TABLE IF EXISTS `nucleus_category`;
CREATE TABLE IF NOT EXISTS `nucleus_category` (
  `catid` int(11) NOT NULL auto_increment,
  `cblog` int(11) NOT NULL default '0',
  `cname` varchar(40) default NULL,
  `iurltitle` varchar(40) default NULL,
  `cdesc` varchar(200) default NULL,
  `cgroup` int(11) default 1,
  PRIMARY KEY  (`catid`),
  KEY `iurltitle` (`iurltitle`)
) TYPE=MyISAM COMMENT='Categories';

DROP TABLE IF EXISTS `nucleus_comment`;
CREATE TABLE IF NOT EXISTS `nucleus_comment` (
  `cnumber` int(11) NOT NULL auto_increment,
  `cbody` text NOT NULL,
  `cuser` varchar(40) default NULL,
  `cmail` varchar(100) default NULL,
  `cmember` int(11) default NULL,
  `citem` int(11) NOT NULL default '0',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `chost` varchar(60) default NULL,
  `cip` varchar(15) NOT NULL default '',
  `cblog` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cnumber`),
  UNIQUE KEY `cnumber` (`cnumber`),
  KEY `citem` (`citem`),
  FULLTEXT KEY `cbody` (`cbody`)
) TYPE=MyISAM COMMENT='Comments';

DROP TABLE IF EXISTS `nucleus_config`;
CREATE TABLE IF NOT EXISTS `nucleus_config` (
  `name` varchar(20) NOT NULL default '',
  `value` varchar(128) default NULL,
  PRIMARY KEY  (`name`)
) TYPE=MyISAM COMMENT='Configuration';

DROP TABLE IF EXISTS `nucleus_httplog`;
CREATE TABLE IF NOT EXISTS `nucleus_httplog` (
  `UID` int(11) NOT NULL auto_increment,
  `XDATE` varchar(6) default '',
  `XTIME` varchar(8) default '',
  `XADDR` varchar(20) default '',
  `XAGENT` varchar(20) default '',
  `XPATH` varchar(60) default '',
  `XREFERER` varchar(160) default '',
  `XDNS` varchar(60) default '',
  PRIMARY KEY  (`UID`)
) TYPE=MyISAM COMMENT='Plugin: Log';

DROP TABLE IF EXISTS `nucleus_item`;
CREATE TABLE IF NOT EXISTS `nucleus_item` (
  `inumber` int(11) NOT NULL auto_increment,
  `ititle` varchar(160) default NULL,
  `iurltitle` varchar(160) default NULL,
  `ibody` text NOT NULL,
  `imore` text,
  `iblog` int(11) NOT NULL default '0',
  `iauthor` int(11) NOT NULL default '0',
  `itime` datetime NOT NULL default '0000-00-00 00:00:00',
  `iclosed` tinyint(2) NOT NULL default '0',
  `idraft` tinyint(2) NOT NULL default '0',
  `ikarmapos` int(11) NOT NULL default '0',
  `icat` int(11) default NULL,
  `ikarmaneg` int(11) NOT NULL default '0',
  `editor` int(2) default '0',
  `texybody` TEXT,
  `texymore` TEXT,
  PRIMARY KEY  (`inumber`),
  UNIQUE KEY `inumber` (`inumber`),
  KEY `itime` (`itime`),
  KEY `iurltitle` (`iurltitle`),
  FULLTEXT KEY `ibody` (`ibody`,`ititle`,`imore`)
) TYPE=MyISAM COMMENT='Items';

DROP TABLE IF EXISTS `nucleus_karma`;
CREATE TABLE IF NOT EXISTS `nucleus_karma` (
  `itemid` int(11) NOT NULL default '0',
  `ip` char(15) NOT NULL default ''
) TYPE=MyISAM COMMENT='Karma votes';

DROP TABLE IF EXISTS `nucleus_member`;
CREATE TABLE IF NOT EXISTS `nucleus_member` (
  `mnumber` int(11) NOT NULL auto_increment,
  `mname` varchar(16) NOT NULL default '',
  `mrealname` varchar(60) default NULL,
  `mpassword` varchar(40) NOT NULL default '',
  `memail` varchar(60) default NULL,
  `murl` varchar(100) default NULL,
  `mnotes` varchar(100) default NULL,
  `madmin` tinyint(2) NOT NULL default '0',
  `mcanlogin` tinyint(2) NOT NULL default '1',
  `mcookiekey` varchar(40) default NULL,
  `deflang` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`mnumber`),
  UNIQUE KEY `mnumber` (`mnumber`),
  UNIQUE KEY `mname` (`mname`)
) TYPE=MyISAM COMMENT='Members';

DROP TABLE IF EXISTS `nucleus_minichat`;
CREATE TABLE IF NOT EXISTS `nucleus_minichat` (
  `UID` int(11) NOT NULL auto_increment,
  `CHATID` int(11) default '0',
  `NAME` varchar(20) default '',
  `MESSAGE` varchar(255) default '',
  `EMAIL` varchar(60) default '',
  PRIMARY KEY  (`UID`)
) TYPE=MyISAM COMMENT='Plugin: Chat';

DROP TABLE IF EXISTS `nucleus_plug_cc_pending`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_cc_pending` (
  `id` int(11) NOT NULL auto_increment,
  `cbody` text NOT NULL,
  `cuser` varchar(40) default NULL,
  `cmail` varchar(100) default NULL,
  `cmember` int(11) default NULL,
  `citem` int(11) NOT NULL default '0',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `chost` varchar(60) default NULL,
  `cip` varchar(15) NOT NULL default '',
  `cblog` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='Plugin: Comments pending';

DROP TABLE IF EXISTS `nucleus_plug_extra_skin`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_extra_skin` (
  `tableid` int(11) NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `description` varchar(255) default NULL,
  `skin` text,
  `url` varchar(255) default NULL,
  PRIMARY KEY  (`tableid`),
  UNIQUE KEY `titleindx` (`title`),
  KEY `urlindx` (`url`)
) TYPE=MyISAM COMMENT='Plugin: Extra Skins';

DROP TABLE IF EXISTS `nucleus_plug_polladmin`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_polladmin` (
  `pnumber` int(11) NOT NULL auto_increment,
  `pauthor` int(11) default NULL,
  `pitem` int(11) NOT NULL default '0',
  `pquestion` text NOT NULL,
  `poptions` text NOT NULL,
  `pstart` datetime NOT NULL default '0000-00-00 00:00:00',
  `pend` datetime NOT NULL default '0000-00-00 00:00:00',
  `pclosed` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`pnumber`)
) TYPE=MyISAM COMMENT='Plugin: Polls';

DROP TABLE IF EXISTS `nucleus_plug_referrer`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_referrer` (
  `ref_to` varchar(60) NOT NULL default '',
  `ref_when` timestamp NOT NULL,
  `ref_from` varchar(160) NOT NULL default '',
  `ref_engine` tinyint(1) default '0',
  `ref_extra` varchar(80) default NULL,
  KEY `kfrom` (`ref_from`),
  KEY `kwhen` (`ref_when`),
  KEY `kto` (`ref_to`)
) TYPE=MyISAM COMMENT='Plugin: Referrers';

DROP TABLE IF EXISTS `nucleus_plug_related`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_related` (
  `itemid` int(9) NOT NULL default '0',
  `localkey` varchar(60) NOT NULL default '',
  `googlekey` varchar(60) NOT NULL default '',
  PRIMARY KEY  (`itemid`)
) TYPE=MyISAM COMMENT='Plugin: Related keywords';

DROP TABLE IF EXISTS `nucleus_plug_related_cache`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_related_cache` (
  `id` int(9) NOT NULL auto_increment,
  `type` varchar(20) NOT NULL default '',
  `keyword` varchar(60) NOT NULL default '',
  `rank` int(9) NOT NULL default '0',
  `url` varchar(255) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `stamp` varchar(14) NOT NULL default '',
  `snippet` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='Plugin: Related google cache';

DROP TABLE IF EXISTS `nucleus_plug_seo`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_seo` (
  `id` varchar(255) NOT NULL default '',
  `url` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='Plugin: URL redirects';

DROP TABLE IF EXISTS `nucleus_plug_table_head`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_table_head` (
  `tableid` int(11) NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `description` varchar(255) default NULL,
  `theader` text,
  `titem1` text,
  `titem2` text,
  `tfooter` text,
  PRIMARY KEY  (`tableid`)
) TYPE=MyISAM COMMENT='Plugin: Table header';

DROP TABLE IF EXISTS `nucleus_plug_table_item`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_table_item` (
  `itemid` int(11) NOT NULL auto_increment,
  `tableid` int(11) NOT NULL default '0',
  `rowid` int(11) NOT NULL default '0',
  `itemtext` text,
  `itemint` int(11) default NULL,
  `tableitem` int(11) default NULL,
  PRIMARY KEY  (`itemid`),
  KEY `tableref` (`itemid`,`rowid`),
  FULLTEXT KEY `itemskey` (`itemtext`)
) TYPE=MyISAM COMMENT='Plugin: Table structure';

DROP TABLE IF EXISTS `nucleus_plug_table_row`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_table_row` (
  `tableid` int(11) NOT NULL default '0',
  `rowid` int(11) NOT NULL default '0',
  `rowtitle` varchar(255) default NULL,
  `rowdescription` varchar(255) default NULL,
  `rowtype` int(1) default NULL,
  PRIMARY KEY  (`tableid`,`rowid`)
) TYPE=MyISAM COMMENT='Plugin: Table rows';

DROP TABLE IF EXISTS `nucleus_plug_wie`;
CREATE TABLE IF NOT EXISTS `nucleus_plug_wie` (
  `sessid` int(9) NOT NULL default '0',
  `timestamp` int(15) NOT NULL default '0',
  `memberid` int(9) NOT NULL default '0',
  PRIMARY KEY  (`sessid`)
) TYPE=MyISAM COMMENT='Plugin: Who is online';

DROP TABLE IF EXISTS `nucleus_plugin`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin` (
  `pid` int(11) NOT NULL auto_increment,
  `pfile` varchar(40) NOT NULL default '',
  `porder` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pid`),
  KEY `pid` (`pid`),
  KEY `porder` (`porder`)
) TYPE=MyISAM COMMENT='Plugins';

DROP TABLE IF EXISTS `nucleus_plugin_cpreview`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_cpreview` (
  `cnumber` int(11) NOT NULL auto_increment,
  `cbody` text,
  `coriginal` text,
  `cuser` varchar(40) default NULL,
  `cmail` varchar(100) default NULL,
  `cmember` int(11) NOT NULL default '0',
  `citem` int(11) NOT NULL default '0',
  `cip` varchar(15) NOT NULL default '',
  `cblog` int(11) NOT NULL default '0',
  `ctime` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cnumber`)
) TYPE=MyISAM COMMENT='Plugin: Comment preview';

DROP TABLE IF EXISTS `nucleus_plugin_event`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_event` (
  `pid` int(11) NOT NULL default '0',
  `event` varchar(40) default NULL,
  KEY `pid` (`pid`)
) TYPE=MyISAM COMMENT='Plugins events';

DROP TABLE IF EXISTS `nucleus_plugin_fancierurl`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_fancierurl` (
  `inumber` int(11) default NULL,
  `iurltitle` varchar(255) default NULL,
  KEY `inumber` (`inumber`,`iurltitle`)
) TYPE=MyISAM COMMENT='Plugin: Fancier (SEO) URLs';

DROP TABLE IF EXISTS `nucleus_plugin_option`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_option` (
  `ovalue` text NOT NULL,
  `oid` int(11) NOT NULL,
  `ocontextid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`oid`,`ocontextid`)
) TYPE=MyISAM COMMENT='Plugins options';

DROP TABLE IF EXISTS `nucleus_plugin_option_desc`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_option_desc` (
  `oid` int(11) NOT NULL auto_increment,
  `opid` int(11) NOT NULL default '0',
  `oname` varchar(20) NOT NULL default '',
  `ocontext` varchar(20) NOT NULL default '',
  `odesc` varchar(255) default NULL,
  `otype` varchar(20) default NULL,
  `odef` text,
  `oextra` text,
  PRIMARY KEY  (`opid`,`oname`,`ocontext`),
  UNIQUE KEY `oid` (`oid`)
) TYPE=MyISAM COMMENT='Plugins options descriptions';

DROP TABLE IF EXISTS `nucleus_plugin_querylog`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_querylog` (
  `querystr` varchar(120),
  `querywhen` timestamp,
  `logid` int(11) NOT NULL auto_increment,
  KEY `qeurystr` (`querystr`),
  KEY `id` (`logid`)
) TYPE=MyISAM COMMENT='Plugin: Search Log';

DROP TABLE IF EXISTS `nucleus_plugin_rssitem`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_rssitem` (
  `itemid` int(11) default NULL,
  `client` varchar(60) NOT NULL default '',
  `lastchecked` timestamp,
  `lastupdate` timestamp,
  KEY `item` (`itemid`),
  KEY `client` (`client`)
) TYPE=MyISAM COMMENT='Plugin: RSS for items';

DROP TABLE IF EXISTS `nucleus_plugin_tb`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_tb` (
  `tb_id` int(11) NOT NULL default '0',
  `url` varchar(100) NOT NULL default '',
  `title` tinytext,
  `excerpt` tinytext,
  `blog_name` tinytext,
  `timestamp` datetime default NULL,
  PRIMARY KEY  (`tb_id`,`url`)
) TYPE=MyISAM COMMENT='Plugin: TrackBack';

DROP TABLE IF EXISTS `nucleus_plugin_views`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_views` (
  `id` int(11) NOT NULL default '0',
  `views` int(15) NOT NULL default '0'
) TYPE=MyISAM COMMENT='Plugin: Views plugin';

DROP TABLE IF EXISTS `nucleus_plugin_weather`;
CREATE TABLE IF NOT EXISTS `nucleus_plugin_weather` (
  `uid` int(10) NOT NULL default '0',
  `value` varchar(50) default '',
  PRIMARY KEY  (`uid`)
) TYPE=MyISAM COMMENT='Plugin: Weather plugin';

DROP TABLE IF EXISTS `nucleus_skin`;
CREATE TABLE IF NOT EXISTS `nucleus_skin` (
  `sdesc` int(11) NOT NULL default '0',
  `stype` varchar(20) NOT NULL default '',
  `scontent` text NOT NULL,
  PRIMARY KEY  (`sdesc`,`stype`)
) TYPE=MyISAM COMMENT='Skins';

DROP TABLE IF EXISTS `nucleus_skin_desc`;
CREATE TABLE IF NOT EXISTS `nucleus_skin_desc` (
  `sdnumber` int(11) NOT NULL auto_increment,
  `sdname` varchar(20) NOT NULL default '',
  `sddesc` varchar(200) default NULL,
  `sdtype` varchar(40) NOT NULL default 'text/html',
  `sdincmode` varchar(10) NOT NULL default 'normal',
  `sdincpref` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`sdnumber`),
  UNIQUE KEY `sdnumber` (`sdnumber`),
  UNIQUE KEY `sdname` (`sdname`)
) TYPE=MyISAM COMMENT='Skins description';

DROP TABLE IF EXISTS `nucleus_team`;
CREATE TABLE IF NOT EXISTS `nucleus_team` (
  `tmember` int(11) NOT NULL default '0',
  `tblog` int(11) NOT NULL default '0',
  `tadmin` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`tmember`,`tblog`)
) TYPE=MyISAM COMMENT='Teams';

DROP TABLE IF EXISTS `nucleus_template`;
CREATE TABLE IF NOT EXISTS `nucleus_template` (
  `tdesc` int(11) NOT NULL default '0',
  `tpartname` varchar(20) NOT NULL default '',
  `tcontent` text NOT NULL,
  PRIMARY KEY  (`tdesc`,`tpartname`)
) TYPE=MyISAM COMMENT='Templates';

DROP TABLE IF EXISTS `nucleus_template_desc`;
CREATE TABLE IF NOT EXISTS `nucleus_template_desc` (
  `tdnumber` int(11) NOT NULL auto_increment,
  `tdname` varchar(20) NOT NULL default '',
  `tddesc` varchar(200) default NULL,
  PRIMARY KEY  (`tdnumber`),
  UNIQUE KEY `tdname` (`tdname`),
  UNIQUE KEY `tdnumber` (`tdnumber`)
) TYPE=MyISAM COMMENT='Templates description';

INSERT INTO `nucleus_blog` VALUES (1, 'BLOG:CMS Weblog', 'myweblog', NULL, 1, 0, 0, NULL, 'http://localhost/blogcms/CVS/moose/', NULL, 1, 1, 0, 0, 1, 1, 1, 1);

INSERT INTO `nucleus_category` VALUES (1, 1, 'BLOG:CMS', 'blog-cms', 'BLOG:CMS category', 1);

INSERT INTO `nucleus_comment` VALUES (10, '<p>This is a &quot;parent&quot; comment. Two comments were inspired by it (comment 2 and comment 3). You can see this relationship in &quot;parent&quot; comment footer.</p>
<p>Also, try clicking any item to highlight its parents (yellow background) and its children (blue background). Current item has white background color.</p>', NULL, NULL, 1, 1, '2004-03-23 20:49:07', 'localhost', '127.0.0.1', 1);
INSERT INTO `nucleus_comment` VALUES (11, '<p>[1] I agree with the comment above.</p>', NULL, NULL, 1, 1, '2004-03-23 20:49:19', 'localhost', '127.0.0.1', 1);
INSERT INTO `nucleus_comment` VALUES (12, '<p>[1] I <em>disagree</em> with the comment above.</p>', NULL, NULL, 1, 1, '2004-03-29 21:17:42', 'localhost', '127.0.0.1', 1);
INSERT INTO `nucleus_comment` VALUES (13, '<p>you are both  [2]  and  [3] way off-topic, here is nothing to agree or disagree about!!</p>
<p>PS: try clicking on "show in context" link, and on comment body, to see what happens! :-)</p>', NULL, NULL, 1, 1, '2004-03-29 21:18:19', 'localhost', '127.0.0.1', 1);

INSERT INTO `nucleus_config` VALUES ('DefaultBlog', '1');
INSERT INTO `nucleus_config` VALUES ('AdminEmail', 'admin@admin.com');
INSERT INTO `nucleus_config` VALUES ('IndexURL', 'http://localhost/');
INSERT INTO `nucleus_config` VALUES ('Language', 'english');
INSERT INTO `nucleus_config` VALUES ('SessionCookie', '0');
INSERT INTO `nucleus_config` VALUES ('AllowMemberCreate', '0');
INSERT INTO `nucleus_config` VALUES ('AllowMemberMail', '1');
INSERT INTO `nucleus_config` VALUES ('SiteName', 'BLOG:CMS Weblog');
INSERT INTO `nucleus_config` VALUES ('AdminURL', 'http://localhost/admin/');
INSERT INTO `nucleus_config` VALUES ('NewMemberCanLogon', '1');
INSERT INTO `nucleus_config` VALUES ('DisableSite', '0');
INSERT INTO `nucleus_config` VALUES ('DisableSiteURL', 'http://www.this-page-intentionally-left-blank.org/');
INSERT INTO `nucleus_config` VALUES ('LastVisit', '0');
INSERT INTO `nucleus_config` VALUES ('MediaURL', 'http://localhost/blogcms/CVS/moose/media/');
INSERT INTO `nucleus_config` VALUES ('AllowedTypes', 'jpg,jpeg,gif,mpg,mpeg,avi,mov,mp3,swf,png');
INSERT INTO `nucleus_config` VALUES ('AllowLoginEdit', '0');
INSERT INTO `nucleus_config` VALUES ('AllowUpload', '1');
INSERT INTO `nucleus_config` VALUES ('DisableJsTools', '2');
INSERT INTO `nucleus_config` VALUES ('CookiePath', '/');
INSERT INTO `nucleus_config` VALUES ('CookieDomain', NULL);
INSERT INTO `nucleus_config` VALUES ('CookieSecure', '0');
INSERT INTO `nucleus_config` VALUES ('MediaPrefix', '1');
INSERT INTO `nucleus_config` VALUES ('MaxUploadSize', '1048576');
INSERT INTO `nucleus_config` VALUES ('NonmemberMail', '0');
INSERT INTO `nucleus_config` VALUES ('PluginURL', 'http://localhost/admin/plugins/');
INSERT INTO `nucleus_config` VALUES ('ProtectMemNames', '1');
INSERT INTO `nucleus_config` VALUES ('BaseSkin', '1');
INSERT INTO `nucleus_config` VALUES ('SkinsURL', 'http://localhost/blogcms/CVS/moose/skins/');
INSERT INTO `nucleus_config` VALUES ('ActionURL', 'http://localhost/blogcms/CVS/moose/action.php');
INSERT INTO `nucleus_config` VALUES ('URLMode', 'normal');
INSERT INTO `nucleus_config` VALUES ('DatabaseVersion', 'v4.1');

INSERT INTO `nucleus_item` VALUES (1, 'BLOG:CMS 4.2.1', 'blog-cms-v4-2-1', '<p>BLOG:CMS v4.2 is one of the most complete, feature-packed, personal publishing systems on the market, developed by <a href="http://hulan.cz/">Radek Hul&aacute;n</a>.</p>
<h4>If you enjoy this system, please do consider donation:</h4>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post"><div>
<input type="hidden" name="cmd" value="_s-xclick" />
<input type="image" src="https://www.paypal.com/en_US/i/btn/x-click-but21.gif" name="submit" alt="PayPal.com" />
<img alt="" src="https://www.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1" />
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----
" />
</div></form>
<p>Donators that make an offer of minimum &euro;150,00 will automatically receive <strong>1 year of premium e-mail support</strong>.</p>
<hr />
<p>If you have any questions or suggestions regarding <a href="http://blogcms.com">BLOG:CMS</a>, please use forum at <a href="http://forum.blogcms.com">forum.blogcms.com</a>.</p>', '', 1, 1, '2004-10-21 13:02:59', 0, 0, 1, 1, 0, 0, '', '');

INSERT INTO `nucleus_plug_extra_skin` VALUES (1, 'articles', 'articles and comments statistics', "<h2 id='articlestats1h2'>Hot topics</h2><%LatestDisc(5)%>
<h2 id='articlestats2h2'>Latest comments</h2><%LatestComments(5)%>
<h2 id='articlestats3h2'>Latest articles</h2><%LatestItems(5)%>
<h2 id='articlestats4h2'>Most karma</h2><%MostKarma(5)%>
<h2 id='articlestats5h2'>Most viewed</h2><%MostViewed(5)%>
<script type='text/javascript'> initStatMenu(); </script>", '');
INSERT INTO `nucleus_plug_extra_skin` VALUES (4, 'footer', 'footer for every page', "<div id='footer'>
  <!-- Please retain this (c) notice -->
  Powered by <a href='http://blogcms.com/'><img style='margin-top:5px' src='./skins/base/logo.png' alt='blogcms.com' /></a>
  Personal Content Management System &copy; 2003-2005 <a href='http://hulan.cz/contact/' title='Herr LogMeister'>Radek Hul&aacute;n</a>
</div></div>
</body></html>", '');
INSERT INTO `nucleus_plug_extra_skin` VALUES (7, 'rss', 'rss feeds of your site', "<h2>RSS and Atom feeds</h2>
<div id='rss'>
<a href='<%blogsetting(url)%>xml-rss1.php?full=yes' title='RSS 1.0'><img src='<%skinfile(rss10.png)%>' alt='RSS 1.0' /></a>
<a href='<%blogsetting(url)%>xml-rss2.php?full=yes' title='RSS 2.0'><img src='<%skinfile(rss20.png)%>' alt='RSS 2.0' /></a>
<%RSSBlog%>
<%CommentControl(url)%>
<a href='<%blogsetting(url)%>atom.php' title='Atom 0.3'><img src='<%skinfile(atom.png)%>' alt='Atom 0.3' /></a>
<a href='<%blogsetting(url)%>wap.php' title='WAP version of this weblog'><img src='<%skinfile(wap.png)%>' alt='WAP!' /></a>
</div>", '');
INSERT INTO `nucleus_plug_extra_skin` VALUES (9, 'header', 'header of all your pages', "<%if(xml)%><?xml version='1.0' encoding='<%blogsetting(charset)%>'?><%endif%>
<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en' <%Signature%>>
<head>

<!-- accesibility links -->
<%HeaderNavigation(5)%>
<link rel='bookmark' title='<%blogsetting(name)%>' href='<%blogsetting(url)%>' />
<link rel='shortcut icon' href='/favicon.ico' />
<link rel='alternate' type='application/rss+xml' title='RSS 1.0' href='<%blogsetting(url)%>xml-rss1.php' />
<link rel='alternate' type='application/rss+xml' title='RSS 2.0' href='<%blogsetting(url)%>xml-rss2.php' />
<link rel='alternate' type='application/atom+xml' title='Atom' href='<%blogsetting(url)%>atom.php' />
<link rel='EditURI' type='application/rsd+xml' title='RSD' href='<%blogsetting(url)%>rsd.php' />

<!-- page title -->
<%if(skintype,item)%><title><%itemtitle%> - <%blogsetting(name)%></title><%else%><%if(skintype,error)%><title>Error!</title><%else%><title><%blogsetting(name)%></title><%endif%><%endif%>

<!-- meta info -->
<%CSS(META)%>
<meta http-equiv='Pragma' content='no-cache' />
<meta http-equiv='Cache-Control' content='no-cache' />
<meta http-equiv='Expires' content='-1' />
<meta name='generator' content='<%version%>' />
<meta name='robots' content='all,follow' />

<!-- javascript -->
<script type='text/javascript' src='<%skinfile(script.js)%>'></script>
</head><body>

<!-- center it on the page -->
<div id='content'>

<!-- blog name -->
<%if(skintype,error)%><h1>Error</h1><%else%><h1><%blogsetting(name)%></h1><%endif%>

<!-- main menu -->
<div id='topwrapper'><div id='top'>
<ul>
<li><a href='<%blogsetting(url)%>' <%if(skinname,default)%>id='topcurrent'<%endif%> accesskey='a' style='border-left:0 none' title='Homepage'><span class='u'>a</span>rticles</a></li>
<li><a href='<%blogsetting(url)%>forum/' accesskey='f' title='Forum'><span class='u'>f</span>orum</a></li>
<li><a href='<%blogsetting(url)%>photo/' accesskey='g' title='Photo gallery'><span class='u'>g</span>allery</a></li>
<li><a href='<%blogsetting(url)%>wiki/' accesskey='k' title='Wiki'>wi<span class='u'>k</span>i</a></li>
<li><a href='<%blogsetting(url)%>news.php' <%if(skinname,news)%>id='topcurrent'<%endif%> accesskey='w' title='latest news'>ne<span class='u'>w</span>s</a></li>
<li><a href='<%blogsetting(url)%>contact.php' <%if(skinname,contact)%>id='topcurrent'<%endif%> accesskey='c' title='contact form'><span class='u'>c</span>ontact</a></li>
</ul>
</div></div>", '');
INSERT INTO `nucleus_plug_extra_skin` VALUES (10, 'commentinfo', 'commentinfo', "<h4>Comment Info:</h4>
<p>If you like, you may use the following semi-tags in your comments:</p>
<ul>
<li><samp>[a href=http://url.com]link title[/a]</samp> will be converted into a link.</li>
<li><samp>[abbr title=text]abbr[/abbr]</samp> will be converted to &#60;abbr&#62;.</li>
<li><samp>[cite]</samp>, <samp>[code]</samp>, <samp>[em]</samp>, <samp>[strong]</samp>, <samp>[q]</samp>, <samp>[li]</samp> &#8212; likewise.</li>
</ul>", '');
INSERT INTO `nucleus_plug_extra_skin` VALUES (11, 'headerwap', 'header for WAP version', "<?xml version='1.0' encoding='<%blogsetting(charset)%>'?>
<!DOCTYPE html PUBLIC '-//WAPFORUM//DTD XHTML Mobile 1.0//EN' 'http://www.wapforum.org/DTD/xhtml-mobile10.dtd' >
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
<%if(skintype,item)%><meta http-equiv='Cache-Control' content='max-age=0'/><%endif%>
<%if(skintype,item)%><title><%itemtitle%> - <%blogsetting(name)%></title><%else%><title><%blogsetting(name)%></title><%endif%>
<link rel='stylesheet' type='text/css' href='<%skinfile(wap.css)%>' />
</head>
<body>
<div id='content'>
<h1><%blogsetting(name)%></h1>", '');
INSERT INTO `nucleus_plug_extra_skin` VALUES (12, 'footerwap', 'footer for WAP version', "<hr />
</div>
</body>
</html>", '');

INSERT INTO `nucleus_member` VALUES (1, 'God', 'God', '', 'admin@admin.com', 'http://localhost/', '', 1, 1, '', 'english');

INSERT INTO `nucleus_plug_table_head` VALUES (2, "mylinks", "My Favourite Links", "<ul>", "<li><a href='<%url%>' title='<%title%>'><%text%></a></li>", "<li><a href='<%url%>' title='<%title%>'><%text%></a></li>", "</ul>");

INSERT INTO `nucleus_plug_table_item` VALUES (9, 2, 1, 'http://blogcms.com/', 0, 1);
INSERT INTO `nucleus_plug_table_item` VALUES (10, 2, 2, 'The Very Best Content Management System', 0, 1);
INSERT INTO `nucleus_plug_table_item` VALUES (11, 2, 3, 'BLOG:CMS', 0, 1);
INSERT INTO `nucleus_plug_table_item` VALUES (12, 2, 1, 'http://www.opera.com/', 0, 2);
INSERT INTO `nucleus_plug_table_item` VALUES (13, 2, 2, 'Opera - The Best Internet Experience', 0, 2);
INSERT INTO `nucleus_plug_table_item` VALUES (14, 2, 3, 'Opera Browser', 0, 2);
INSERT INTO `nucleus_plug_table_item` VALUES (15, 2, 1, 'http://www.mozilla.org', 0, 3);
INSERT INTO `nucleus_plug_table_item` VALUES (16, 2, 2, 'The Best Open Source Browser', 0, 3);
INSERT INTO `nucleus_plug_table_item` VALUES (17, 2, 3, 'Firefox Browser', 0, 3);
INSERT INTO `nucleus_plug_table_item` VALUES (18, 2, 1, 'http://forum.blogcms.com/', 0, 4);
INSERT INTO `nucleus_plug_table_item` VALUES (19, 2, 2, 'Have a problem? Come to our forum!', 0, 4);
INSERT INTO `nucleus_plug_table_item` VALUES (20, 2, 3, 'Support Forum', 0, 4);
INSERT INTO `nucleus_plug_table_item` VALUES (21, 2, 1, 'http://www.stopie.com/stopie/reasons', 0, 5);
INSERT INTO `nucleus_plug_table_item` VALUES (22, 2, 2, 'Do not use obsolete Microsoft Internet Explorer!', 0, 5);
INSERT INTO `nucleus_plug_table_item` VALUES (23, 2, 3, 'No Internet Explorer', 0, 5);
INSERT INTO `nucleus_plug_table_item` VALUES (24, 2, 1, 'http://hulan.cz/blog/', 0, 6);
INSERT INTO `nucleus_plug_table_item` VALUES (25, 2, 2, 'Weblog of BLOG:CMS Author, Radek Hul&aacute;n', 0, 6);
INSERT INTO `nucleus_plug_table_item` VALUES (26, 2, 3, 'Herr LogMeister', 0, 6);
INSERT INTO `nucleus_plug_table_item` VALUES (27, 2, 1, './admin/', 0, 7);
INSERT INTO `nucleus_plug_table_item` VALUES (28, 2, 2, 'BLOG:CMS Admin Area', 0, 7);
INSERT INTO `nucleus_plug_table_item` VALUES (29, 2, 3, 'Admin Area', 0, 7);
INSERT INTO `nucleus_plug_table_item` VALUES (30, 2, 1, './list.php', 0, 8);
INSERT INTO `nucleus_plug_table_item` VALUES (31, 2, 2, 'BLOG:CMS Access Log', 0, 8);
INSERT INTO `nucleus_plug_table_item` VALUES (32, 2, 3, 'Access Log', 0, 8);

INSERT INTO `nucleus_plug_table_row` VALUES (2, 2, 'title', 'link title', 1);
INSERT INTO `nucleus_plug_table_row` VALUES (2, 1, 'url', 'url', 1);
INSERT INTO `nucleus_plug_table_row` VALUES (2, 3, 'text', 'link text', 1);

INSERT INTO `nucleus_plug_polladmin` VALUES (1, 1, 0, 'How do you like BLOG:CMS?', 'YTo0OntzOjEwOiJFeGNlbGxlbnQhIjtzOjE6IjAiO3M6NjoiR3JlYXQhIjtzOjE6IjAiO3M6MTI6IkV2ZW4gYmV0dGVyISI7czoxOiIwIjtzOjE4OiJJIGhhdmUgbm8gd29yZHMgOikiO3M6MToiMCI7fQ==', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0);

INSERT INTO `nucleus_plug_related` VALUES (1, 'BLOG:CMS', 'BLOG:CMS');

INSERT INTO `nucleus_plugin_views` VALUES (1, 1);

INSERT INTO `nucleus_skin` VALUES (3, 'index', "<?xml version='1.0' encoding='<%blogsetting(charset)%>'?>
<?xml-stylesheet type='text/css' href='<%skinfile(base/rss.css)%>'?>
<rss version='2.0'>
<channel>
<title><%blogsetting(name)%></title>
<link><%blogsetting(url)%></link>
<description><%blogsetting(desc)%></description>
<language>en</language>
<generator><%version%></generator>
<copyright><%sitevar(admin)%></copyright>
<category>blog</category>
<docs>http://backend.userland.com/rss</docs>
<image>
<url><%blogsetting(url)%>admin/blogcms.gif</url>
<title><%blogsetting(name)%></title>
<link><%blogsetting(url)%></link>
</image>
<%blog(xmlrss2,10)%>
</channel>
</rss>");
INSERT INTO `nucleus_skin` VALUES (1, 'search', "<%ExtraSkin(header)%>
<div id='items'>
<h2>Search</h2>
<%searchform%>
<h2>Search results</h2>
<%searchresults(default)%>
</div>
<div id='menu'>
<!-- main menu navigation -->
<h2>Navigation</h2>
<div class='nav'>
<div><a href='<%todaylink%>'>Homepage</a></div>
<div><a href='<%archivelink%>'>Archives</a></div>
</div>
<h2>Categories</h2>
<%SubCategories%>
<%ExtraSkin(articles)%>
</div>
<%ExtraSkin(footer)%>");
INSERT INTO `nucleus_skin` VALUES (1, 'imagepopup', "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en' <%Signature%>>
<head>
<title><%imagetext%></title>
<style type='text/css'>
img { border: none;position:relative;overflow: auto;}
body { margin: 0px; }
</style>
</head>
<body onblur='window.close()'>
<a href='javascript:window.close();'><%image%></a>
</body></html>");
INSERT INTO `nucleus_skin` VALUES (2, 'index', "<?xml version='1.0' encoding='<%blogsetting(charset)%>'?>
<?xml-stylesheet type='text/css' href='<%skinfile(base/rss.css)%>'?>
<!DOCTYPE rss PUBLIC '-//Netscape Communications//DTD RSS 0.91//EN' 'http://my.netscape.com/publish/formats/rss-0.91.dtd'>
<rss version='0.91'>
<channel>
<title><%blogsetting(name)%></title>
<link><%blogsetting(url)%></link>
<description><%blogsetting(desc)%></description>
<docs>http://backend.userland.com/rss091</docs>
<language>en</language>
<image>
<url><%blogsetting(url)%>admin/blogcms.gif</url>
<title><%blogsetting(name)%></title>
<link><%blogsetting(url)%></link>
</image>
<%blog(xmlrss,10)%>
</channel>
</rss>");
INSERT INTO `nucleus_skin` VALUES (6, 'index', "<?xml version='1.0' encoding='<%blogsetting(charset)%>'?>
<feed xmlns='http://www.w3.org/2005/Atom'>
    <title><%blogsetting(name)%></title>
    <link rel='alternate' type='text/html' href='<%blogsetting(url)%>' />
    <link rel='self' type='application/atom+xml' href='<%blogsetting(url)%><%self%>' />
    <updated><%blog(atomodified,1)%></updated>
    <id><%blogsetting(url)%>:<%blogsetting(id)%></id>
    <generator uri='http://blogcms.com/'>
      <%version%>
    </generator>
    <%blog(atomentries,10)%>
</feed>");
INSERT INTO `nucleus_skin` VALUES (1, 'member', "<%ExtraSkin(header)%>

<div id='items'>
<h3>Member :: <%member(name)%></h3>
<p>Real name: <%member(realname)%></p>
<p>Website: <a href='<%member(url)%>'><%member(url)%></a></p>
<%membermailform%>
</div>

<div id='menu'>
<h2>Navigation</h2>
<div class='nav'>
<div><a href='<%todaylink%>'>Homepage</a></div>
<div><a href='<%archivelink%>'>Archives</a></div>
</div>
<h2>Search</h2>
<%searchform%>
</div>

<%ExtraSkin(footer)%>");
INSERT INTO `nucleus_skin` VALUES (5, 'index', "<?xml version='1.0' encoding='<%blogsetting(charset)%>'?>
<?xml-stylesheet type='text/css' href='<%skinfile(base/rss.css)%>'?>
<rdf:RDF
xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
xmlns='http://purl.org/rss/1.0/'
xmlns:dc='http://purl.org/dc/elements/1.1/'
xmlns:sy='http://purl.org/rss/1.0/modules/syndication/'
xmlns:admin='http://webns.net/mvcb/'
xmlns:cc='http://web.resource.org/cc/'
>
<channel rdf:about='<%blogsetting(url)%>xmlrss1.php'>
<title><%blogsetting(name)%></title>
<link><%blogsetting(url)%></link>
<description><%blogsetting(desc)%></description>
<language>en</language>
<image rdf:resource='<%blogsetting(url)%>admin/blogcms.gif' />
<items>
<rdf:Seq>
<%blog(xmlrss1items,10)%>
</rdf:Seq>
</items>
<%blog(xmlrss1,10)%>
</channel>
</rdf:RDF>");
INSERT INTO `nucleus_skin` VALUES (1, 'index', "<%ExtraSkin(header)%>

<div id='items'>
<!-- shows last 5 articles -->
<%Plugin(BlogWithOffset,default,5)%>
<!-- shows links to previous / next 5 articles -->
<%OffsetArticles(5,5)%>
<!-- go to a page navigation -->
<div id='navigation'><%Plugin(PageLinkList,5,.)%></div>
</div>

<div id='menu'>
<!-- main menu navigation -->
<h2>Navigation</h2>
<div class='nav'>
<div><a href='<%todaylink%>'>Homepage</a></div>
<div><a href='<%archivelink%>'>Archives</a></div>
<div><%Plugin(OffsetEntriesLink,5,-,Previous 5 items,0,p)%></div>
<div><%Plugin(OffsetEntriesLink,5,+,Next 5 items,0,n)%></div>
</div>
<div class='nav'>
<div><a href='<%adminurl%>'>Admin Area</a></div>
</div>
<h2>Search</h2>
<%searchform%>
<h2>Categories</h2>
<%SubCategories%>
<!-- article statistics -->
<%ExtraSkin(articles)%>
<!-- skins switcher -->
<h2>Style It!</h2>
<%CSS(SELECT)%>
<!-- my favourite links -->
<h2>My Links</h2>
<%Table(mylinks,title,none)%>
<!-- RSS and Atom feeds -->
<%ExtraSkin(rss)%>
<!-- login form -->
<h2>Login</h2>
<!-- DYNAMIC_CONTENT_START -->
<%loginform%>
<!-- domain and page referrers -->
<%Referrer(top,5,2,1)%>
<%Referrer(last,5,2,2)%>
<!-- DYNAMIC_CONTENT_STOP -->
</div>

<%ExtraSkin(footer)%>");
INSERT INTO `nucleus_skin` VALUES (4, 'index', "<?xml version='1.0'?>
<rsd version='1.0'>
<service>
<engineName><%version%></engineName>
<engineLink>http://blogcms.com/</engineLink>
<homepageLink><%sitevar(url)%></homepageLink>
<apis>
<api name='MetaWeblog' preferred='true' apiLink='<%adminurl%>xmlrpc/server.php' blogID='<%blogsetting(id)%>'>
<docs>http://blogcms.com/extra/support</docs>
</api>
<api name='Blogger' preferred='false' apiLink='<%adminurl%>xmlrpc/server.php' blogID='<%blogsetting(id)%>'>
<docs>http://blogcms.com/extra/support</docs>
</api>
</apis>
</service>
</rsd>");
INSERT INTO `nucleus_skin` VALUES (1, 'archive', "<%ExtraSkin(header)%>

<div id='items'>
<h3 class='item'>Calendar</h3>
<%Calendar%>
<%archive(default)%>
</div>

<div id='menu'>
<h2>Navigation</h2>
<div class='nav'>
<div><a href='<%todaylink%>'>Homepage</a></div>
<div><a class='active' href='<%archivelink%>'>Archives</a></div>
<div><a href='<%prevlink%>'>Previous <%archivetype%></a></div>
<div><a href='<%nextlink%>'>Next <%archivetype%></a></div>
</div>
<h2>Search</h2>
<%searchform%>
<h2>Categories</h2>
<%SubCategories%>
<%ExtraSkin(articles)%>
</div>

<%ExtraSkin(footer)%>");
INSERT INTO `nucleus_skin` VALUES (1, 'archivelist', "<%ExtraSkin(header)%>

<div id='items'>
<h3 class='item'>Calendar</h3>
<%Calendar%>
<h3 class='item'>Archives</h3>
<%archivelist(default)%>
</div>

<div id='menu'>
<h2>Navigation</h2>
<div class='nav'>
<div><a href='<%todaylink%>'>Homepage</a></div>
<div><a class='active' href='<%archivelink%>'>Archives</a></div>
</div>
<h2>Search</h2>
<%searchform%>
<h2>Categories</h2>
<%SubCategories%>
</div>

<%ExtraSkin(footer)%>");
INSERT INTO `nucleus_skin` VALUES (1, 'error', "<%ExtraSkin(header)%>

<div id='items'>
<h3><%errormessage%></h3>
</div>

<div id='menu'>
<h2 class='prvni'>Navigation</h2>
<div class='nav'>
<div><a href='javascript:history.go(-1);' title='Previous page'>Back</a></div>
</div>
</div>

<%ExtraSkin(footer)%>");
INSERT INTO `nucleus_skin` VALUES (1, 'item', "<%ExtraSkin(header)%>

<div id='items'>
<!-- article detail -->
<!-- DYNAMIC_CONTENT_START -->
<%item(detailed)%>
<!-- DYNAMIC_CONTENT_STOP -->
<!-- current comments -->
<%comments(detailed)%>
<!-- comment form -->
<h4>Add new comment:</h4>
<!-- DYNAMIC_CONTENT_START -->
<%CommentControl(warning)%>
<%commentform%>
<!-- DYNAMIC_CONTENT_STOP -->
<script type='text/javascript'> commentFormExtras(); </script>
</div>

<div id='menu'>
<h2>Navigation</h2>
<div class='nav'>
<div><a href='<%todaylink%>'>Homepage</a></div>
<div><a href='<%archivelink%>'>Archives</a></div>
<div><a href='<%FancierURL(nextlink)%>'>Next article</a></div>
<div><a href='<%FancierURL(prevlink)%>'>Previous article</a></div>
</div>
<hr /><%Random%><hr />
<h2>Categories</h2>
<%SubCategories%>
<h2>Search</h2>
<%searchform%>
<!-- article statistics -->
<%ExtraSkin(articles)%>
<!-- skin switcher -->
<h2>Style It!</h2>
<%CSS(SELECT)%>
<!-- page referrers -->
<!-- DYNAMIC_CONTENT_START -->
<%Referrer(last,5,2,2)%>
<!-- DYNAMIC_CONTENT_STOP -->
</div>

<%ExtraSkin(footer)%>");
INSERT INTO `nucleus_skin` VALUES (7, 'index', "<%ExtraSkin(headerwap)%>
<%Plugin(BlogWithOffset,wap,10)%>
<%ExtraSkin(footerwap)%>");
INSERT INTO `nucleus_skin` VALUES (7, 'item', "<%ExtraSkin(headerwap)%>
<p><a href='<%blogsetting(url)%>?skinid=7'>&raquo; back</a></p>
<%item(wapdetailed)%>
<%ExtraSkin(footerwap)%>");
INSERT INTO `nucleus_skin` VALUES (8, 'item', "<%ExtraSkin(headerwap)%>
<p><a href='<%blogsetting(url)%>?skinid=7'>&raquo; back</a></p>
<h2><%itemtitle%></h2>
<%comments(wapdetailed)%>
<p><a href='<%blogsetting(url)%>?skinid=7'>&raquo; back</a></p>
<%ExtraSkin(footerwap)%>");
INSERT INTO `nucleus_skin` VALUES (9, 'index', "<%ExtraSkin(header)%>

<div id='items'>
<h3>Latest news:</h3>
<%RSSAtom(http://sports.espn.go.com/espn/rss/nfl/news)%>
</div>

<div id='menu'>
<h2>Navigation</h2>
<div class='nav'>
<div><a href='javascript:history.go(-1);' title='Previous page'>Back</a></div>
</div>
</div>

<%ExtraSkin(footer)%>");
INSERT INTO `nucleus_skin` VALUES (10, 'index', "<%ExtraSkin(header)%>

<div id='items'>
<h3>Send me an email message</h3>
<!-- this plugin email the message -->
<form method='post' action='<%blogsetting(url)contact.php%>' id='contactform'>
<!-- DYNAMIC_CONTENT_START --><%Contact%><!-- DYNAMIC_CONTENT_STOP -->
<fieldset>
<legend>Message:&nbsp;</legend>
<label>Your name: <input class='formfield' type='text' name='name' tabindex='1' /></label><br />
<label>E-mail: <input class='formfield' type='text' name='email' tabindex='2' /></label><br />
<label>Telephone: <input class='formfield' type='text' name='telephone' tabindex='3' /></label><br />
<textarea class='formfield' name='message' cols='40' rows='8' tabindex='4'></textarea><br />
<input class='formbutton' type='submit' value='Send email!' tabindex='5' />
</fieldset>
</form>
</div>

<div id='menu'>
<h2>Navigation</h2>
<div class='nav'>
<div><a href='javascript:history.go(-1);' title='Previous page'>Back</a></div>
</div>
</div>

<%ExtraSkin(footer)%>");

INSERT INTO `nucleus_skin_desc` VALUES (1, 'default', 'default skin for your blog', 'text/html', 'skindir', 'base/');
INSERT INTO `nucleus_skin_desc` VALUES (2, 'xmlrss', 'RSS syndication of weblogs', 'application/rss+xml', 'normal', '');
INSERT INTO `nucleus_skin_desc` VALUES (3, 'xmlrss2', 'RSS 2.0 syndication of weblogs', 'application/rss+xml', 'normal', '');
INSERT INTO `nucleus_skin_desc` VALUES (4, 'rsd', 'RSD (Really Simple Discovery) information', 'text/xml', 'normal', '');
INSERT INTO `nucleus_skin_desc` VALUES (5, 'xmlrss1', 'RSS 1.0 syndication of weblogs', 'application/rss+xml', 'normal', '');
INSERT INTO `nucleus_skin_desc` VALUES (6, 'atom', 'Atom 1.0 weblog syndication', 'application/atom+xml', 'normal', '');
INSERT INTO `nucleus_skin_desc` VALUES (7, 'wap', 'WAP version', 'application/xhtml+xml', 'normal', 'base/');
INSERT INTO `nucleus_skin_desc` VALUES (8, 'wapcomments', 'WAP comments', 'application/xhtml+xml', 'normal', 'base/');
INSERT INTO `nucleus_skin_desc` VALUES (9, 'news', 'news feeds', 'text/html', 'normal', 'base/');
INSERT INTO `nucleus_skin_desc` VALUES (10, 'contact', 'Contact form', 'text/html', 'normal', 'base/');

INSERT INTO `nucleus_team` VALUES (1, 1, 1);

INSERT INTO `nucleus_template` VALUES (7, 'ITEM', '<%date(utc)%>');
INSERT INTO `nucleus_template` VALUES (1, 'FORMAT_DATE', '%d.%m.%y');
INSERT INTO `nucleus_template` VALUES (1, 'FORMAT_TIME', '%H:%M:%S');
INSERT INTO `nucleus_template` VALUES (1, 'ITEM', '<item>
<title><%syndicate_title%></title>
<link><%FancierURL%></link>
<description><%XMLTools(body)%></description>
</item>');
INSERT INTO `nucleus_template` VALUES (4, 'EDITLINK', '<a href="<%editlink%>" onclick="<%editpopupcode%>">edit</a>');
INSERT INTO `nucleus_template` VALUES (4, 'FORMAT_DATE', '%d.%m.%y');
INSERT INTO `nucleus_template` VALUES (4, 'FORMAT_TIME', '%H:%M:%S');
INSERT INTO `nucleus_template` VALUES (4, 'ITEM', '<item>
<title><%syndicate_title%></title>
<link><%FancierURL%></link>
<description><%XMLTools(body)%></description>
<category><%category%></category>
<comments><%FancierURL%>#trackback</comments>
<pubDate><%date(rfc822)%></pubDate>
</item>');
INSERT INTO `nucleus_template` VALUES (5, 'IMAGE_CODE', '<%image%>');
INSERT INTO `nucleus_template` VALUES (5, 'ITEM', "<h2><%title%></h2>
<div class='itembody'>
<%body%>
<%more%>
</div>
<br />
<div class='iteminfo'>
<%time%> - <%date%> -
<%author%> -
<%category%> -
<%Viewed%>
</div>");
INSERT INTO `nucleus_template` VALUES (5, 'FORMAT_DATE', '%d.%m.%y');
INSERT INTO `nucleus_template` VALUES (5, 'FORMAT_TIME', '%H:%M:%S');
INSERT INTO `nucleus_template` VALUES (6, 'FORMAT_DATE', '%x');
INSERT INTO `nucleus_template` VALUES (6, 'FORMAT_TIME', '%X');
INSERT INTO `nucleus_template` VALUES (6, 'ITEM', '<item rdf:about="<%FancierURL%>">
<title><%syndicate_title%></title>
<link><%FancierURL%></link>
<description><%XMLTools(body)%></description>
<dc:date><%date(iso8601)%></dc:date>
</item>');
INSERT INTO `nucleus_template` VALUES (10, 'ITEM', '<rdf:li resource="<%FancierURL%>" />
');
INSERT INTO `nucleus_template` VALUES (3, 'CATLIST_LISTITEM', "<div><a <%active%> href='<%catlink%>'><%catname%></a></div>");
INSERT INTO `nucleus_template` VALUES (3, 'CATLIST_HEADER', "<div class='nav'><div><a <%active%> href='<%blogurl%>'>All</a></div>");
INSERT INTO `nucleus_template` VALUES (2, 'CATLIST_FOOTER', '</div>');
INSERT INTO `nucleus_template` VALUES (2, 'CATLIST_LISTITEM', "<div><a <%active%> href='<%catlink%>' title='<%catdesc%>'><%catname%></a></div>");
INSERT INTO `nucleus_template` VALUES (2, 'CATLIST_HEADER', "<div class='nav'><div><a <%active%> href='<%blogurl%>'>All</a></div>");
INSERT INTO `nucleus_template` VALUES (2, 'ARCHIVELIST_LISTITEM', "<a href='<%archivelink%>' title='Archives'>%B, %Y</a><br />");
INSERT INTO `nucleus_template` VALUES (3, 'ARCHIVELIST_HEADER', 'Archive list:');
INSERT INTO `nucleus_template` VALUES (3, 'COMMENTS_FOOTER', '</ol>');
INSERT INTO `nucleus_template` VALUES (3, 'COMMENTS_ONE', 'Comment: ');
INSERT INTO `nucleus_template` VALUES (3, 'COMMENTS_MANY', 'Comments: ');
INSERT INTO `nucleus_template` VALUES (2, 'COMMENTS_NONE', "<a href='<%FancierURL%>#commentform' rel='bookmark'>Add comment!</a>");
INSERT INTO `nucleus_template` VALUES (2, 'COMMENTS_ONE', 'Comment: ');
INSERT INTO `nucleus_template` VALUES (2, 'COMMENTS_MANY', 'Comments: ');
INSERT INTO `nucleus_template` VALUES (2, 'COMMENTS_TOOMUCH', "<a href='<%FancierURL%>#commentform' rel='bookmark'><%commentword%><%commentcount%></a>");
INSERT INTO `nucleus_template` VALUES (9, 'ITEM', '<entry>
 <title type="html"><%title%></title>
 <link rel="alternate" type="text/html" href="<%FancierURL%>" />
 <author>
  <name><%author%></name>
 </author>
 <updated><%date(utc)%></updated>
 <published><%date(iso8601)%></published>
 <content type="xhtml">
   <div xmlns="http://www.w3.org/1999/xhtml">
   <%XMLTools(atom)%>
   </div>
 </content>
 <id><%blogurl%>:<%blogid%>:<%itemid%></id>
</entry>');
INSERT INTO `nucleus_template` VALUES (3, 'EDITLINK', '- <a href="<%editlink%>" onclick="<%editpopupcode%>">edit</a>');
INSERT INTO `nucleus_template` VALUES (3, 'COMMENTS_HEADER', "<h4>Comments:</h4> <ol id='comments'>");
INSERT INTO `nucleus_template` VALUES (3, 'COMMENTS_BODY', '<%FancyText(true)%> from: <%userlink%></address>
<%body%>
<ins><%date%>, <%time%> <%CommentControl(edit)%></ins></li>');
INSERT INTO `nucleus_template` VALUES (2, 'MORELINK', "<p class='readmore'><a href='<%FancierURL%>'>[read more]</a></p>");
INSERT INTO `nucleus_template` VALUES (2, 'EDITLINK', ' - <a href="<%editlink%>" onclick="<%editpopupcode%>">edit</a>');
INSERT INTO `nucleus_template` VALUES (2, 'ITEM_FOOTER', "<div class='iteminfo'>
<a href='<%authorlink%>'><%author%></a> - <img alt='pencil' src='<%skinfile(clock.gif)%>' /> <%time%> - <a href='<%categorylink%>'><%category%></a> - <img alt='pencil' src='<%skinfile(edit.gif)%>' /> <a href='<%FancierURL%>'>permalink</a> -
<%comments%> <%OffsetArticles%> <%edit%>
</div>");
INSERT INTO `nucleus_template` VALUES (2, 'ITEM', "<div class='itembody'>
<%body%><%morelink%>
</div>");
INSERT INTO `nucleus_template` VALUES (2, 'ITEM_HEADER', "<h3 class='item'><a href='<%FancierURL%>'><%title%></a></h3>");
INSERT INTO `nucleus_template` VALUES (3, 'ITEM_FOOTER', "<div id='searchstats1'>
<h4>RSS 2.0 feed, Trackback, print preview, email this article</h4>
<ul>
<li>RSS 2.0 feed of this article, including comments:  <%RSSItem%></li>
<%TrackBack(list)%>
<li>You can <%Print%> this article, <%MailToAFriend%> it, or export a <%PDF%>.</li>
</ul>
</div>

<div id='searchstats2'>
<%Related(local,10)%>
</div>
<div id='searchstats3'>
<%Related(google,10)%>
</div>

<script type='text/javascript'> initSearchMenu(); </script>
<div style='clear:both'></div>");
INSERT INTO `nucleus_template` VALUES (3, 'ITEM', "<div class='iteminfo'>
<a href='<%authorlink%>'><%author%></a> - <img alt='clock' src='<%skinfile(clock.gif)%>' />  <%time%> - <%date%> - <a href='<%categorylink%>'><%category%></a> - <%Viewed%> -  <img alt='pencil' src='<%skinfile(edit.gif)%>' />  <a href='<%FancierURL%>'>permalink</a>  <%edit%>
<br />
Karma points: <strong><%karma%></strong>. Do you like this article? [<a href='<%karmaposlink%>'>yes</a>/<a href='<%karmaneglink%>'>no</a>]
</div>");
INSERT INTO `nucleus_template` VALUES (3, 'ITEM_HEADER', "<h3 class='item'><%title%></h3>
<div class='itembody'>
<%body%>
<%more%>
</div>");
INSERT INTO `nucleus_template` VALUES (3, 'MEDIA_CODE', '<%media%>');
INSERT INTO `nucleus_template` VALUES (3, 'IMAGE_CODE', '<%image%>');
INSERT INTO `nucleus_template` VALUES (12, 'IMAGE_CODE', '<%image%>');
INSERT INTO `nucleus_template` VALUES (3, 'SEARCH_HIGHLIGHT', '<span class="highlight">\\0</span>');
INSERT INTO `nucleus_template` VALUES (3, 'POPUP_CODE', '<%popuplink%>');
INSERT INTO `nucleus_template` VALUES (3, 'FORMAT_TIME', '%H:%M:%S');
INSERT INTO `nucleus_template` VALUES (3, 'LOCALE', 'english');
INSERT INTO `nucleus_template` VALUES (3, 'FORMAT_DATE', '%A, %d.%m.%y');
INSERT INTO `nucleus_template` VALUES (3, 'CATLIST_FOOTER', '</div>');
INSERT INTO `nucleus_template` VALUES (11, 'COMMENTS_MANY', 'See comments!');
INSERT INTO `nucleus_template` VALUES (11, 'COMMENTS_NONE', 'No comments yet.');
INSERT INTO `nucleus_template` VALUES (11, 'DATE_HEADER', '<p><strong>%A, %d.%m.%y</strong></p>');
INSERT INTO `nucleus_template` VALUES (11, 'FORMAT_DATE', '%d.%m.%y');
INSERT INTO `nucleus_template` VALUES (11, 'FORMAT_TIME', '%H:%M:%S');
INSERT INTO `nucleus_template` VALUES (11, 'LOCALE', 'english');
INSERT INTO `nucleus_template` VALUES (11, 'SEARCH_HIGHLIGHT', '<span class="highlight">\\0</span>');
INSERT INTO `nucleus_template` VALUES (11, 'SEARCH_NOTHINGFOUND', 'No results found for query <b><%query%></b>');
INSERT INTO `nucleus_template` VALUES (11, 'POPUP_CODE', '<%popuplink%>');
INSERT INTO `nucleus_template` VALUES (11, 'MEDIA_CODE', '<%media%>');
INSERT INTO `nucleus_template` VALUES (11, 'COMMENTS_ONE', 'See comments!');
INSERT INTO `nucleus_template` VALUES (11, 'ITEM_HEADER', "<p><a href='<%FancierURL%>&amp;skinid=7'><%title%></a></p>");
INSERT INTO `nucleus_template` VALUES (11, 'ITEM', '<p><%comments%> <%OffsetArticles%></p>');
INSERT INTO `nucleus_template` VALUES (11, 'COMMENTS_TOOMUCH', "<a href='<%FancierURL%>&amp;skinid=8'><%commentword%></a>");
INSERT INTO `nucleus_template` VALUES (12, 'ITEM', "<h2><%title%></h2>
<%body%>
<%more%>
<hr />
<p>Published at <%time%>, <%date%></p>
<p><a href='<%FancierURL%>&amp;skinid=8'>Comments</a>?</p>");
INSERT INTO `nucleus_template` VALUES (12, 'COMMENTS_HEADER', '<ol>');
INSERT INTO `nucleus_template` VALUES (12, 'COMMENTS_BODY', '<li><address>From: <%user%> <%ip%></address><%body%><ins><%date%>, <%time%></ins></li>');
INSERT INTO `nucleus_template` VALUES (12, 'COMMENTS_FOOTER', '</ol>');
INSERT INTO `nucleus_template` VALUES (12, 'FORMAT_DATE', '%A, %d.%m.%y');
INSERT INTO `nucleus_template` VALUES (12, 'FORMAT_TIME', '%H:%M:%S');
INSERT INTO `nucleus_template` VALUES (12, 'LOCALE', 'english');
INSERT INTO `nucleus_template` VALUES (12, 'SEARCH_HIGHLIGHT', '<span class="highlight">\\0</span>');
INSERT INTO `nucleus_template` VALUES (12, 'POPUP_CODE', '<%popuplink%>');
INSERT INTO `nucleus_template` VALUES (12, 'MEDIA_CODE', '<%media%>');
INSERT INTO `nucleus_template` VALUES (2, 'DATE_HEADER', '<h2>%A, %d.%m.%y</h2>');
INSERT INTO `nucleus_template` VALUES (2, 'FORMAT_DATE', '%d.%m.%y');
INSERT INTO `nucleus_template` VALUES (2, 'FORMAT_TIME', '%H:%M:%S');
INSERT INTO `nucleus_template` VALUES (2, 'LOCALE', 'english');
INSERT INTO `nucleus_template` VALUES (2, 'SEARCH_HIGHLIGHT', '<span class="highlight">\\0</span>');
INSERT INTO `nucleus_template` VALUES (2, 'SEARCH_NOTHINGFOUND', 'No results found for query <b><%query%></b>');
INSERT INTO `nucleus_template` VALUES (2, 'POPUP_CODE', '<%popuplink%>');
INSERT INTO `nucleus_template` VALUES (2, 'MEDIA_CODE', '<%media%>');
INSERT INTO `nucleus_template` VALUES (2, 'IMAGE_CODE', '<%image%>');

INSERT INTO `nucleus_template_desc` VALUES (1, 'xmlrss', 'RSS 0.9 template');
INSERT INTO `nucleus_template_desc` VALUES (2, 'default', 'template to display HOMEPAGE');
INSERT INTO `nucleus_template_desc` VALUES (3, 'detailed', 'template to display ITEM pages');
INSERT INTO `nucleus_template_desc` VALUES (4, 'xmlrss2', 'RSS 2.0 template');
INSERT INTO `nucleus_template_desc` VALUES (5, 'print', 'template to PRINT articles');
INSERT INTO `nucleus_template_desc` VALUES (6, 'xmlrss1', 'RSS 1.0 template');
INSERT INTO `nucleus_template_desc` VALUES (7, 'atomodified', 'Atom 0.3 helper template');
INSERT INTO `nucleus_template_desc` VALUES (9, 'atomentries', 'Atom 0.3 template');
INSERT INTO `nucleus_template_desc` VALUES (10, 'xmlrss1items', 'RSS 1.0 helper template');
INSERT INTO `nucleus_template_desc` VALUES (11, 'wap', 'template to display WAP');
INSERT INTO `nucleus_template_desc` VALUES (12, 'wapdetailed', 'template to display WAP ITEM pages');

