// ***********************************************************************************
// Copyright (C) Radek HULAN and Aleto
// http://hulan.cz/ and http://aleto.ch/
// ***********************************************************************************

// This work is licensed under the Creative Commons Attribution License. To  view a
// copy of this license, visit http://creativecommons.org/licenses/by/1.0/  or send
// a letter to Creative Commons, 559 Nathan Abbott Way, Stanford,  California 94305,
// USA.

// use like onclick="return openwin(this.href)"
function openwin(url) {
  if( window.open(url,'','width=800,height=600,left=0,top=0,scrollbars=yes,location=yes,resizable=yes') ) return false; else return true;
}
 
// hideH2
function hideH2(itemtext,totalitems){
  var ele;
  for (var i = 1; i<=Number(totalitems); i++) 
	  if (ele=document.getElementById(itemtext+i+String("h2"))) ele.style.display="none";
}

// switchCells
function switchCells(currentitem,itemtext,totalitems){
  var ele;
  for (var i = 1; i<=Number(totalitems); i++)
    if ( i != Number(currentitem) ){
      if (ele=document.getElementById(itemtext+i)) ele.style.display='none';
      if (ele=document.getElementById(itemtext+i+'a')) ele.className='';
    } else {
      if (ele=document.getElementById(itemtext+i)) ele.style.display='block';
      if (ele=document.getElementById(itemtext+i+'a')) ele.className='active';
    }
}

// helper functions
var isXHTML;
function createNewEle(ele){
	if(isXHTML) 
		{ return document.createElementNS('http://www.w3.org/1999/xhtml', ele); }
	else 
		{ return document.createElement(ele); };
};	

function statMenu(menuStats,itemtext,desc,tid) {
	isXHTML=/html\:/.test(document.getElementsByTagName('body')[0].nodeName);
	var ele=document.getElementById(itemtext+'1');
	if (!ele) return;
	if (desc) ele.parentNode.insertBefore(createNewEle('h2'),ele).appendChild(document.createTextNode(desc));
	ele.previousSibling.style.display="block";
	var base=ele.parentNode.insertBefore(createNewEle('div'),ele);
	base.className='nav';
	if (tid) base.id=tid;
	for(var i=0; i<menuStats.length; i++) {
		var aEle;
		(aEle=base.appendChild(createNewEle('div')).appendChild(createNewEle('a'))).appendChild(document.createTextNode(menuStats[i]));
		aEle.id=itemtext+(i+1)+'a';
		aEle.href='javascript:switchCells('+(i+1)+',\''+itemtext+'\','+menuStats.length+')';
		aEle.title='Show '+menuStats[i]+' - without page reload';
	};
	hideH2(itemtext,menuStats.length);
	switchCells(1,itemtext,menuStats.length);
}


// article statistics
function initStatMenu() {
  var menuStatsItems=['Hot topics','Latest comments','Latest articles','Most karma','Most viewed'];
  statMenu(menuStatsItems,'articlestats','Statistics',false);
}

// search menu
function initSearchMenu() {
  var menuSearchItems=['Exports','Local search','Google search'];
  statMenu(menuSearchItems,'searchstats',false,'search');
}

// ***********************************************************************************
// Copyright (C) Radek HULAN
// http://hulan.cz/
// ***********************************************************************************

// category tree is initially not hidden
var categoryhidden = false;
// category groups fold
function categoryfold(){
	categoryhidden = true;
	var i=1;
	var ele;
	while (ele=document.getElementById('subcat'+i++)) ele.style.display='none';
}
// category groups fold
function categoryexpand(){
	categoryhidden=false;
	var i=1;
	var ele;
	while (ele=document.getElementById('subcat'+i++)) ele.style.display='block';
}
// category groups toogle
function categorytoogle(){
	if (categoryhidden)
		categoryexpand();
	else
		categoryfold();
}
function categoryswitch(j){
	if (categoryhidden) {
		categoryexpand();
		return;
	}
	var i=1;
	var ele;
	while (ele=document.getElementById('subcat'+i))
		if (i++==j) ele.style.display='block'; else ele.style.display='none';
	categoryhidden=true;
}

// ***********************************************************************************
// XHConn - Simple XMLHTTP Interface - bfults@gmail.com - 2005-04-08        
// Code licensed under Creative Commons Attribution-ShareAlike License     
// http://creativecommons.org/licenses/by-sa/2.0/                           
// ***********************************************************************************
function XHConn()
{
  var xmlhttp, bComplete = false;
  try { xmlhttp = new XMLHttpRequest();  }
  catch (e) { try { xmlhttp = new ActiveXObject("Msxml2.XMLHTTP"); }
  catch (e) { try { xmlhttp = new ActiveXObject("Microsoft.XMLHTTP"); }
  catch (e) { xmlhttp = false; }}}
  if (!xmlhttp) return null;
  this.connect = function(sURL, sMethod, sVars, fnDone)
  {
    if (!xmlhttp) return false;
    bComplete = false;
    sMethod = sMethod.toUpperCase();

    try {
      if (sMethod == "GET")
      {
        xmlhttp.open(sMethod, sURL+"?"+sVars, true);
        sVars = "";
      }
      else
      {
        xmlhttp.open(sMethod, sURL, true);
        xmlhttp.setRequestHeader("Method", "POST "+sURL+" HTTP/1.1");
        xmlhttp.setRequestHeader("Content-Type",
          "application/x-www-form-urlencoded");
      }
      xmlhttp.onreadystatechange = function(){
        if (xmlhttp.readyState == 4 && !bComplete)
        {
          bComplete = true;
          fnDone(xmlhttp);
        }};
      xmlhttp.send(sVars);
    }
    catch(z) { return false; }
    return true;
  };
  return this;
}

// ***********************************************************************************
// BLOG:CMS comments - (c) Radek Hulan, http://hulan.cz                    
// Code licensed under Creative Commons Attribution-ShareAlike License      
// http://creativecommons.org/licenses/by-sa/2.0/                           
// ***********************************************************************************

function waitIconRemove(commentid) {
	var comment = document.getElementById('comment' + commentid);
	if (comment) {
		var img = comment.getElementsByTagName("img");
		for (var i = 0; i < img.length; i++)
			if (img[i].className == 'commentwait')
				img[i].parentNode.removeChild(img[i]);
	}
}

function removeImages(commentid) {
	var ele = document.getElementById('comment'+commentid);
	if (ele) {
		var img = ele.getElementsByTagName('img');
		for (var i = 0; i < img.length; i++)
			img[i].style.display = 'none';
	}
}
function voteDone(XML) {
	if (window.ActiveXObject) {
		var doc=new ActiveXObject("Microsoft.XMLDOM");
		doc.async="false";
		doc.loadXML(XML.responseText);
	} else {
		var parser=new DOMParser();
		var doc=parser.parseFromString(XML.responseText,"text/xml");
	}
	var response = doc.getElementsByTagName('response');
	var ok = response[0].getElementsByTagName("result")[0].firstChild.nodeValue;
	if (ok == 1) {
		// response was ok
		var commentid = response[2].getElementsByTagName("result")[0].firstChild.nodeValue;
		var votes = response[3].getElementsByTagName("result")[0].firstChild.nodeValue;
		var ele = document.getElementById('votes'+commentid);
		// change # of votes
		if (ele)
			ele.firstChild.nodeValue = votes;
		// hide vote buttons
		ele = document.getElementById('comment'+commentid);
		if (ele) {
			if (votes >= 10)
				ele.className = 'comment-top';
			else if (votes >= 0)
				ele.className = 'comment-ok';
			else if (votes >= -10)
				ele.className = 'comment-bad';
			else 
				ele.className = 'comment-ban';
		}
		waitIconRemove(commentid);
		removeImages(commentid);
	} else {
		alert(response[1].getElementsByTagName("result")[0].firstChild.nodeValue);
		// hide vote buttons
		var commentid = response[2].getElementsByTagName("result")[0].firstChild.nodeValue;
		waitIconRemove(commentid);
		removeImages(commentid);
	}
}


function waitIcon(commentid) {
	var comment = document.getElementById('comment' + commentid);
	var ele = comment.getElementsByTagName('ins');
	var workEle;
	workEle=ele[0].insertBefore(createNewEle('img'),ele[0].firstChild);
	workEle.src = "skins/vote/wait.gif";
	workEle.className='commentwait';
	workEle.alt = 'wait';
}

function voteUp(commentid){
	if (commentid > 0 ) {
		waitIcon(commentid);
		var c = new XHConn();
		c.connect("/action.php?action=plugin&name=FancyText&todo=vote", "POST", "cid=" + commentid + "&votetype=up", voteDone);
	}
}

function voteDown(commentid){
	if (commentid > 0 ) {
		waitIcon(commentid);
		var c = new XHConn();
		c.connect("/action.php?action=plugin&name=FancyText&todo=vote", "POST", "cid=" + commentid + "&votetype=down", voteDone);
	}
}

function voteNeutral(commentid){
	if (commentid > 0 ) {
		waitIcon(commentid);
		var c = new XHConn();
		c.connect("/action.php?action=plugin&name=FancyText&todo=vote", "POST", "cid=" + commentid + "&votetype=neutral", voteDone);
	}
}

// ***********************************************************************************
// script (c) and written by aleto and Radek Huln
// http://aleto.ch/ | http://hulan.cz/
// ***********************************************************************************

// This work is licensed under the Creative Commons Attribution License. To  view a
// copy of this license, visit http://creativecommons.org/licenses/by/1.0/  or send
// a letter to Creative Commons, 559 Nathan Abbott Way, Stanford,  California 94305,
// USA.

// rev 13/09/2004 | rev 20/01/2007

function setTarget(e){
   if(e) return e.target;
   if(event) return event.srcElement;
}
var ns='http://www.w3.org/1999/xhtml';
var parentEle='';
window.onload=function (e) {
if( document.getElementById && document.getElementsByTagName &&
   ((e && e.target) || (event && typeof event.srcElement=='object')) ){
      var comments;
      if( comments=document.getElementById('comments') ) {

         isXHTML=/html\:/.test(document.getElementsByTagName('body')[0].nodeName);
         function createNewEle(ele){
            if(isXHTML) { return document.createElementNS('http://www.w3.org/1999/xhtml', ele); }
            else { return document.createElement(ele); };
         };			 

         // comments reset/show
         var liArr=comments.getElementsByTagName('address'), liEle, i=0, workEle;
         for(i=0; liEle=liArr[i]; i++ ) {
         	(workEle=liEle.insertBefore(createNewEle('dfn'),liEle.firstChild)).appendChild(document.createTextNode('show comment in context'));
         	workEle.className='show';
         	(workEle=liEle.insertBefore(createNewEle('dfn'),liEle.firstChild)).appendChild(document.createTextNode('reset'));
         	workEle.className='reset';
         };         
         
         // get parent
         liArr=comments.getElementsByTagName('li');
         parentEle=comments.parentNode.nodeName;
         
         // comments votes
         var c = new XHConn(); 
         if (c) { // test for XMLHttpRequest support
         	var liCmt=comments.getElementsByTagName('ins'), workParent;
         	for(i=0; liEle=liCmt[i]; i++ ) {
         		workEle = document.getElementById('votes' + (liEle.parentNode.id).substr(7));
         		if (workEle) {
         			if (workEle.firstChild.nodeValue > -10) { // do not show banned comments voting buttons
         				workEle=liEle.insertBefore(createNewEle('img'),liEle.firstChild);
         				workEle.src = "skins/vote/votedown.png";
         				workEle.className='votedown';
         				workEle.alt = 'wastebin';
         				workEle.title = '-1';

         				workEle=liEle.insertBefore(createNewEle('img'),liEle.firstChild);
         				workEle.src = "skins/vote/voteneutral.png";
         				workEle.className='voteneutral';
         				workEle.alt = 'neutral';
         				workEle.title = '0';

         				workEle=liEle.insertBefore(createNewEle('img'),liEle.firstChild);
         				workEle.src = "skins/vote/voteup.png";
         				workEle.className='voteup';
         				workEle.alt = 'super';
         				workEle.title = '+1';
         			}
         		}
         	};         
         }
         
         comments.onclick=function (e) {
            function markComments (fromEle, childType, withName, withGoTo) { 
               var childArr, k=0, childEle;
               if( childArr=fromEle.getElementsByTagName(childType) ) {
                  for(k=0; childEle=childArr[k]; k++) {
                     if(childEle.getElementsByTagName('a')[0] && /cmmnt/.test(childEle.getElementsByTagName('a')[0].href) ) {
                        var listArrNo=childEle.getElementsByTagName('a')[0].href.replace(/^.*cmmnt(.*)$/,'$1');
                        if (withName)
                        	listArr[listArrNo-1].className=withName;
                        else
                        	listArr[listArrNo-1].className=listArr[listArrNo-1].getAttribute("rel");
                        if(withGoTo) goTo='#cmmnt'+listArrNo;
                     }
                  }
               }
            };
            var ele=setTarget(e), i=0, za=1;			

			// voting
         	if(/img/i.test(ele.nodeName)){
         		if (ele.className == 'voteup') {
         			voteUp((ele.parentNode.parentNode.id).substr(7));
         			return;
         		}
         		if (ele.className == 'votedown') {
	         		voteDown((ele.parentNode.parentNode.id).substr(7));
    	     		return;
        	 	}
         		if (ele.className == 'voteneutral') {
	         		voteNeutral((ele.parentNode.parentNode.id).substr(7));
    	     		return;
        	 	}
        	}

            var liArr=this.getElementsByTagName('li'), listArr=[], liEle, i=0, num, childArr, childLi, classN=false, goTo=false, indent=false;
            for(i=0; liEle=liArr[i]; i++ ) 
            	if( liEle.parentNode==this ) 
            		listArr.push(liEle);
            		
            if(/a/i.test(ele.nodeName) && /commentform/.test(ele.href) ) {
               ele=ele.parentNode;
               i=0;
               while(listArr[i]!=ele) i++;            
               document.getElementById('nucleus_cf_body').focus();
               document.getElementById('nucleus_cf_body').value+='['+(i+1)+'] ';             
            } else {
				if(!/a/i.test(ele.nodeName)){
				   if(/dfn/i.test(ele.nodeName)) { 
					  indent=true;
					  classN=ele.className;
				   }
				   while( ele.parentNode.parentNode && ele.parentNode.parentNode.nodeName !=parentEle ) ele=ele.parentNode; // here is the adaption
				   if(!indent) 
				   	 classN = ''; // classN=ele.className;
				   if(/li/i.test(ele.nodeName) ) {
					  for(i=0; liEle=listArr[i]; i++) {
					  	// if(indent) 
					  	liEle.className=liEle.getAttribute("rel");
					  }
					  if(indent) {
						 if(classN=='show') 
						 	ele.parentNode.className='indent';
						 else 
						 	ele.parentNode.className=ele.parentNode.getAttribute("rel");
					  };
					  if(classN=='show' || !classN ) {                        
						 markComments(ele, 'span', 'parent',true);
						 ele.className = 'current';
						 if(!goTo) {
							i=0;
							while(listArr[i]!=ele) i++;
							goTo='#cmmnt'+(i+1);
						 };
						 if(ele.getElementsByTagName('ol')[0]) markComments(ele.getElementsByTagName('ol')[0], 'li', 'child');
						 for(i=0; liEle=listArr[i]; i++) if(!/current|parent|child/.test(liEle.className)) liEle.className='notPart';
						 if(goTo && indent ) location.href+=goTo;
					  };
					  if(classN=='hide') {
						 i=0;
						 while(listArr[i]!=ele) i++;
						 goTo='#cmmnt'+(i+1);
						 location.href+=goTo;
					  }
				   }
				}
			}
            return true;
         }
      }
   }
}

// ***********************************************************************************
// Copyright (C) Radek HULAN
// http://hulan.cz/contact/
// ***********************************************************************************

// This work is licensed under the Creative Commons Attribution License. To  view a
// copy of this license, visit http://creativecommons.org/licenses/by/1.0/  or send
// a letter to Creative Commons, 559 Nathan Abbott Way, Stanford,  California 94305,
// USA.

function setSelectionRange(input, selectionStart, selectionEnd) {
  if (input.setSelectionRange) {
    input.focus();
    input.setSelectionRange(selectionStart, selectionEnd);
  }
  else if (input.createTextRange) {
    var range = input.createTextRange();
    range.collapse(true);
    range.moveEnd('character', selectionEnd);
    range.moveStart('character', selectionStart);
    range.select();
  }
}

function ct(textpre,textpost){ 
 var ele;
 if (ele=document.getElementById('nucleus_cf_body')) {
 	if (ele.setSelectionRange) {
 		var start = ele.selectionStart;
 		var end = ele.selectionEnd; 
 		ele.value = ele.value.substring(0, start) + textpre + ele.value.substring(start, end) + textpost + ele.value.substring(end);
 		var pos = start + textpre.length + textpost.length + (end-start)+1;
 		setSelectionRange(ele, pos, pos);
 	} else if (document.selection) {
 		ele.focus();
 		document.selection.createRange().text = textpre + document.selection.createRange().text + textpost;
	}
 }
}

function commentFormExtras(){
	isXHTML=/html\:/.test(document.getElementsByTagName('body')[0].nodeName);
	var ele=document.getElementById('nucleus_cf_body');
	if (!ele) return;
	var base=ele.parentNode.insertBefore(createNewEle('div'),ele);
	base.id='toolbar';
	var toolbar=['strong','cite','em','q','abbr','code','list','link'];
	var href1=['[strong]','[cite]','[em]','[q]','[abbr title=YOURTEXT]','[code]','[li]','[a href=LINKURL]'];
	var href2=['[/strong]','[/cite]','[/em]','[/q]','[/abbr]','[/code]','[/li]','[/a]'];
	var title=['bold text','citation','emphasized text','short quotation','abbreviation','source code','unordered list','link/anchor'];
	for(var i=0; i<toolbar.length; i++) {
		var aEle;
		(aEle=base.appendChild(createNewEle('a'))).appendChild(document.createTextNode(toolbar[i]));
		aEle.href='javascript:ct(\''+href1[i]+'\',\''+href2[i]+'\')';
		aEle.title=title[i];
	};
}

function isValidComment(f) {
	if (f.body.value == "") {
		alert('Please enter your comment!');
		return false;
	}
	if (f.user.value == "") {
		alert('Please enter your name and/or nickname!');
		return false;
	}
	return true;
}
