<?php
/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULÁN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

header("Pragma: no-cache");
include('cfg.php');
if (!$CONF['DisableSite']) {
	// get feed into $feed
	ob_start();
	selectSkin('xmlrss1');
	selector();
	$feed = ob_get_contents();
	ob_end_clean();
	
	// create ETAG (hash of feed)
	// (HTTP_IF_NONE_MATCH has quotes around it)
	$eTag = '"'.md5($feed).'"';
	header('Etag: '.$eTag);
	
	// compare Etag to what we got
	if ($eTag == serverVar('HTTP_IF_NONE_MATCH')) {	
		header("HTTP/1.0 304 Not Modified");
		header('Content-Length: 0');
	} else {
		// dump feed
		echo $feed;
	}
		
} else {
	echo '<' . '?xml version="1.0" encoding="utf-8"?' . '>';
?>
<!DOCTYPE rdf:RDF [
<!ENTITY % HTMLlat1 PUBLIC
 "-//W3C//ENTITIES Latin 1 for XHTML//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent">
%HTMLlat1;
]>

<rdf:RDF
 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
 xmlns="http://purl.org/rss/1.0/"
>
<channel rdf:about="htmlspecialchars($CONF['IndexURL'])">
  <title><?=htmlspecialchars($CONF['SiteName'])?></title>
  <description></description>
</channel>
</rdf>
<?php 
 }
?>