<?php
/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULÁN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

header("Pragma: no-cache");
$CONF = array();
include('cfg.php');
if (!$CONF['DisableSite']) {
	// get feed into $feed
	ob_start();
	selectSkin('xmlrss2');
	selector();
	$feed = ob_get_contents();
	ob_end_clean();
	
	// create ETAG (hash of feed)
	// (HTTP_IF_NONE_MATCH has quotes around it)
	$eTag = '"'.md5($feed).'"';
	header('Etag: '.$eTag);
	
	// compare Etag to what we got
	if ($eTag == serverVar('HTTP_IF_NONE_MATCH')) {	
		header("HTTP/1.0 304 Not Modified");
		header('Content-Length: 0');
	} else {
		// dump feed
		echo $feed;
	}
		
} else {
	echo '<' . '?xml version="1.0" encoding="utf-8"?' . '>';
?>
	<rss version="2.0">
	  <channel>
	    <title><?php echo htmlspecialchars($CONF['SiteName'])?></title>
	    <link><?php echo htmlspecialchars($CONF['IndexURL'])?></link>
	    <description></description>
	    <docs>http://backend.userland.com/rss</docs>
 	  </channel>
	</rss>	
<?php 
 }
?>