<?php

defined('WikyBlog') or die("Not an entry point...");

class ADMIN{
	var $owner;
	var $title;
	var $links = array();
	var $pathArray;
	var $downloadBackup = true;
	var $deleteBackup = true;
	var $pluginTitle;
	
	function getOwner(&$pathArray){
		return $pathArray['owner'];
	}
	
	function getStep1(&$pathArray){
		$this->pathArray = $pathArray;
	}
	
	function getStep2(){
		global $page,$pageOwner,$langA, $wbAdminUser;
		
		wbLang::getFile('ADMIN');
		$cleared = false;
		
		$this->title = implode('/',$this->pathArray['path']);
		 
		$this->title = wbStrtolower($this->title);
		$this->pluginTitle = toStorage($this->title); //used by control panel
		$this->uniqLink = '/Admin/'.$pageOwner['username'].'/'.$this->pluginTitle;
		
		$this->title = str_replace('_','',$this->title);
		$this->title = str_replace(' ','',$this->title);
		
		
		////////////////////////////////////////////////
		//
		//		ADMIN check
		//
		
		$isAdmin = isAdmin();

		//show the admin login
		if( !$isAdmin){
			wbLang::getFile('SPEC');
			$_GET['a'] = true;
			includeFile('special/ControlPanel.php');
			message('ADMIN_ONLY');
			return;
		}
		
		$this->getAdminFile();
		
		$page->regLink($langA['control_panel'],'/Special/'.$pageOwner['username'].'/ControlPanel');
		$page->regLink($langA['administration'],'/Special/'.$wbAdminUser.'/ControlPanel?a');
		//$page->regLink($langA['administration'],'/Admin/'.$wbAdminUser.'/ControlPanel');
	}
	
	function getControlPanel(){
		wbLang::getFile('SPEC');
		$_GET['a'] = true;
		includeFile('special/ControlPanel.php');
	}
	
	
	function getAdminFile(){
		global $page,$langA,$rootDir,$wbUniq, $wbTables, $wbPluginDir, $wbPluginSpace,$pageOwner;
		
		
		switch($this->title){
			
			case '';
			case 'controlpanel':
				$this->getControlPanel();
			return;
			
			////////////////////////////////////////////////
			//
			//	under development
			//
			case 'logfile':
				includeFile('admin/LogFile.php');
			return;
			
			//keep this one just in case
			case 'configlinks':
				includeFile('admin/ConfigLinks.php');
			return;
			
			case 'errorlog':
				includeFile('admin/Errors.php'); //for debugging remote sites, it's helpful for others to able to access the error log
			return;
		}		
		
		//new
		$query = 'SELECT `plugin_space`, `plugin_dir`, `script` FROM '.$wbTables['config_links'];
		$query .= ' WHERE `link` = "'.$this->title.'" ';
		$query .= ' AND `userlevel` = 5 ';
		$query .= ' AND `enabled` > 0 ';
		$query .= ' LIMIT 1 OFFSET 0';
		
		$result = wbDB::runQuery($query);
		$num = mysql_num_rows($result);	
		if( $num === 1 ){
			$row = mysql_fetch_assoc($result);
			if( !empty($row['plugin_space']) ){
				$wbPluginDir = $row['plugin_dir'];
				$wbPluginSpace = $row['plugin_space'];
			}
			rootInclude($row['script']);
			return;

		}		

		message('UNDEFINED_ADMIN_PAGE',$this->title);
		
		$this->getControlPanel();
		//cPanel::findSimilar($this->title);
	}
	
	function checkBackup(){
		global $rootDir,$wbUniq;
		
		$backupFile = $rootDir.'/userfiles/backup.'.$wbUniq.'.tmp';
		if( !is_file($backupFile) || (filesize($backupFile) < 10) ){
			return;
		}
		
		if( !$this->downloadBackup ){
			return;
		}
		
		message('<strong>Warning:</strong> There\'s a backup file on your server that should be <a href="'.wbLinks::getUrl('Backup?cmd=download').'">downloaded and erased</a> as soon as possible.');
		
		if( !$this->deleteBackup ){
			return;
		}
		
		$temp = sprintf("%u", filemtime($backupFile));
		$diff = (int)(mktime()-$temp);
		if( $diff < 100 ){
			return;
		}
		$fp = fopen($backupFile,'wb');
		fclose($fp);
		unlink($backupFile);
	}
	
	//
	//
	//
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// 	Functions used by Admin Scripts
	//
		
	//////////////////////////////////////////////////////////////////////////
	//
	//	Configuration
	//
	function getConfiguration(){
		global $wbTables;
		$query = 'SELECT `data`,`revision` FROM '.$wbTables['config'].' ORDER BY revision DESC LIMIT 1';
		$result = wbDB::runQuery($query);
		$row = mysql_fetch_assoc($result);
		$this->configRevision = $row['revision'];
		return unserialize($row['data']);
	}
	function updateConfig(&$data){
		global $wbTables,$dbInfo,$page;
		
		$serialized = serialize($data);
		$query = 'UPDATE '.$wbTables['config'].' SET `modified`=`modified`, ';
		$query .= ' `data` = "'.wbDB::escape($serialized).'" ';
		$query .= ' WHERE `revision` = "'.$this->configRevision.'" ';
		if( !wbDB::runQuery($query) ){
			message('<b>Warning:</b> The Configuration was not updated');
			return false;
		}else{
			$dbInfo = $data['dbInfo'];
			return true;
		}
	}
	
}


