<?php
defined('WikyBlog') or die('Not an entry point...');
wbLang::getFile('SPEC');

class CLASSattachment extends dbPage{
	var $width,$height = false;
	var $userfile = false;

	var $dbValues = array('owner'=>1,'title'=>1,'height'=>1,'width'=>1,'is_image'=>1,'filesize'=>1);
	var $userValues = array('keywords'=>1,'height'=>1,'width'=>1);
	
	var $imgs;
	var $files = array('userfile'=>1,'thumbnail'=>1,'gzipped'=>1);
	var $is_image = 0;
	var $filesize = 0;

	var $uploadLink;
	
	function CLASSattachment($type){
		$this->objectType = $type;
		$this->setDbInfo();
		
		//image extensions
		$this->imgs['bmp'] = 1;
		$this->imgs['gif'] = 1;
		$this->imgs['jpe'] = 1;
		$this->imgs['jpeg'] = 1;
		$this->imgs['jfif'] = 1;
		$this->imgs['jpg'] = 1;
		$this->imgs['pic'] = 1;
		$this->imgs['png'] = 1;
		$this->imgs['tga'] = 1;
		$this->imgs['tif'] = 1;
		$this->imgs['tiff'] = 1;
		
	}

	function setLinks(){
		global $page,$pageOwner,$langA;
		
		if( empty($this->title) ){
			return;
		}
		
		parent::setLinks();
		$page->regLink($langA['file_upload'],'/Attach/'.$this->owner.'?cmd=uploadform');
		
		//$page->displayTitle = $langA[$this->objectType] .' > '.toDisplay($this->title);
		$page->regLink('?','Image?en=Image');
	}
	
	
	function setKeys(&$pathArray){
		if( empty($pathArray['owner']) ){
			$this->owner = $GLOBALS['wbConfig']['pUser'];
		}else{
			$this->owner = $pathArray['owner'];
		}
		
		if( isset($pathArray['path'][0]) && is_numeric($pathArray['path'][0]) ){
			$this->file_id = $pathArray['path'][0];
		}
		
		$this->title = toStorage( implode('/',$pathArray['path']) );
		
		// this would be the same as parent::setKeys() if we used the following bit of code
		// if( empty($this->title) ){
		// 	$this->title = $GLOBALS['wbDefaultTitle']; //must keep to some extent
		// }		
		
		
		$this->setFileLocations();
	}
	
	function checkKeys(){
		if( empty($this->title) ){
			return;
		}
	}

	
	function setFileLocations(){
		global $rootDir;
		
		if( $this->isImage($this->title) ){ //do for file upload
			$this->is_image = 1;
			$title = $this->title;
		}else{
			$this->is_image = 0;
			$title = str_replace('.','.wb~',$this->title);
		}
		$this->userfile = $rootDir.'/userfiles/'.toStorage($this->owner,true).'/uploaded/'.$title;
		$this->thumbnail = $rootDir.'/userfiles/'.toStorage($this->owner,true).'/thumbnails/'.$title.'.jpg';
		$this->gzipped = $this->userfile.'.gz';
	}
	
	function doActions(){
		global $page,$langA;
		
		if( empty($this->title) ){
			switch( $page->userCmd ){
				case 'upgrade':
					$this->upgrade();
				return;
				
				case 'upload':
				case wbStrtolower($langA['upload']):
					$this->upload();
					$this->uploadForm();
				return;
				
				default:
				//case 'uploadform':
					if( !$this->editable ){
						message('DEFAULT_CONTENT_PROTECTED');
					}			
					$this->uploadForm();
				return;
			}
		}
		
		parent::doActions();
	}
	
	function uploadForm(){
		includeFile('tool/EditPage.php');
		IncludeFile('tool/UploadForm.php');
		
		fileEdit::checkOwner('/Attach/'.$this->owner.'?cmd=uploadform');
		new uploadForm();
	}
	
	function upload(){
		if( !$this->editable ){
			message('PROTECTED_FILE');
			return false;
		}
		
		includeFile('tool/UploadFiles.php');
		new uploadFiles();
	}
	
	function upgrade(){
		if( !isOwner(false,true,false) ){
			return false;
		}
		includeFile('maintenance/UpgradeAttachments.php');
		new upgradeFiles();
		die();
	}
		

	function outputObj($field=true){
		global $page, $rootDir, $langA;
		includeFile('tool/pluginDisplay.php');
		if( $field === true ){
			$field = $this->uniqLink;
		}

		ob_start();
		
		$this->localDir = $rootDir.'/userfiles/'.toStorage($this->owner,true).'/uploaded';
		
		$list = array();
		if( $this->is_image == 1 ){
			/// $data
				$fPath = $this->localDir.'/'.$this->title;
				$size = '';
				if( $this->height && $this->width ){
					$list[$langA['height']] = $this->height.'px';
					$list[$langA['width']] = $this->width.'px';
					$size = ' height="'.$this->height.'" width="'.$this->width.'" ';
				}
				
			//file info
				$fileLocation = '/userfiles/'.toStorage($this->owner,true).'/uploaded/'.$this->title;
				$htmlSyntax = '<img src="'.wbLinks::getDir($fileLocation).'" '.$size.' alt="'.$this->title.'" />';
				$wikiSyntax = '[[Image:'.$this->title.']]';
				
			//show img
				echo '<table style="margin:1em auto 1em auto;padding:.5em;">';
				echo '<tr><td>';
				echo $htmlSyntax;
				echo '</td></tr>';
				echo '</table>';		
				
		}else{
			
			//file info
				$fileLocation = '/include/tool/Files.php?o='.toStorage($this->owner,true).'&f='.$this->title;
				$htmlSyntax = '<a href="'.wbLinks::getDir($fileLocation).'" />'.$this->title.'</a>';
				$wikiSyntax = '[[Attach:'.$this->title.']]';
				
			//show download
				echo '<table style="margin:1em auto 1em auto;padding:.5em;">';
				echo '<tr><td>';
				echo '<a href="'.wbLinks::getDir($fileLocation).'" />'.$langA['download'].'</a>';
				echo '</td></tr>';
				echo '</table>';		
		}
		
		$list[$langA['size']] = $this->convert($this->filesize);
		$list[$langA['file_location']] = $fileLocation;
		$list[$langA['wiki_syntax']] = $wikiSyntax;
		$list[$langA['html_syntax']] = wbHtmlspecialchars($htmlSyntax);			

				
		
		echo '<table class="tableRows" style="width:100%">';
		echo '<tr>';
		echo '<th colspan="2">';
		echo $langA['file_info'];
		echo '</th>';
		echo '</tr>';
		$i = 0;
		foreach($list as $label => $value){
			if($i%2 == 1){
				echo '<tr class="tableRowEven">';
			}else{
				echo '<tr class="tableRowOdd">';
			}
			
			echo '<td style="white-space:nowrap;text-align:right">';
			echo $label.': &nbsp; ';
			echo '</td>';
			echo '<td style="white-space:nowrap">';
			echo $value;
			echo '</td>';
			echo '</tr>';
			$i++;
		}
		echo '</table>';


		$page->contentB[$field] = wb::get_clean();
		return $field;
	}
	
	function convert( $bytes ){
		global $langA;
		$bytes = floatval($bytes);
		$types = array();
		
		$types[0] = $langA['bytes'];
		$types[1] = $langA['kb'];
		$types[2] = $langA['mb'];
		$types[3] = $langA['gb'];
		
		
		$i = 0;
		while( ($bytes > 1500) && ($i < 3) ){
			$bytes /= 1024;
			$i++;
		}
		if( $i == 0 ){
			return $bytes.' '.$langA['bytes'];
		}
		
		return number_format($bytes,2).' '.$types[$i];
	}
	
	function isImage($name){
		
		$nameParts = explode('.',$name); 
		$file_type = array_pop($nameParts);
		$file_type = strtolower($file_type);
		if( isset($this->imgs[$file_type]) ){
			return true;
		}
		return false;
	}



	function setFromPost(){
		includeFile('tool/pluginEdit.php');
		parent::setFromPost();
	}


	function checkData($warn=true){
		// if(!$warn){ return;}
		// global $wbParser,$langA;
		// includeFile('tool/pluginCheck.php');
	}


	function editValues(){
		global $page,$jsNum;
		$page->css2 = true;
		$page->scripts[] = '/include/js/editing.js?'.$jsNum;
		$page->scripts[] = '/include/js/editingAll.js?'.$jsNum;
		includeFile('tool/pluginEdit.php');
		ob_start();
		echo '<table style="width:100%">';
		echo '</table>';
		$link = '/Edit'.$this->uniqLink.'?cmd=edit';
		$page->contentB[$link] = wb::get_clean();
		$page->contentB[$link] .= saveBar();
	}
}