<?php
defined('WikyBlog') or die("Not an entry point...");



class configurationInstance extends configurationGeneric{
	
	
	function configurationInstance(){}
	
	
	function getPossible(){
		global $langA,$includeDir;
		
		$array['serverName1'] = '';
		$array['serverName2'] = '';
		$array['serverName3'] = '';
		$array['userLanguage'] = array(); //will be set lower
		$array['max_upload'] = '';
		$array['reservedWords'] = '';
// 		$array['include'] = '';

				
		//Language packages
		$langDir = $includeDir.'/lang';
		if ($dh = @opendir($langDir)) {
			while (($file = readdir($dh)) !== false){
				if( strpos($file,'.') === 0){
					continue;
				}
				if( strpos($file,'x_') === 0){
					continue;
				}				
				$fullPath = $langDir.'/'.$file;
				if( !is_dir($fullPath) ){
					continue;
				}
				$array['userLanguage'][$file] = $langA['lang'][$file];
			}
			closedir($dh);
		}
		

		return $array;
	}
	
	function getValues(){
		return $this->getConfig();
	}
	
	
	function saveConfig(){
		$newValues = $this->getFromPost();
		
		//check
		if( !$this->checkMaxUpload($newValues) ){
			return false;
		}		
		
		
		parent::saveToConfig($newValues);
	}
	
	//
	function checkMaxUpload(&$newValues){
		
		$maximumUpload = ini_get('upload_max_filesize');
		
		if( empty($maximumUpload) || empty($newValues['max_upload']) ){
			return true;
		}
		
		$maximumUpload = $this->getByteValue($maximumUpload);
		$newValues['max_upload'] = $this->getByteValue($newValues['max_upload']);
		
		if( $newValues['max_upload'] > $maximumUpload ){
			message('The Max Upload size cannot be more than the value set in php.ini '.$maximumUpload);
			return false;
		}
		
		return true;
	}	
	
	function getByteValue($value){
		if( empty($value) ){
			return 0;
		}
		if( is_numeric($value) ){
			return (int)$value;
		}
		
		$lastChar = $value{strlen($value)-1};
		$num = (int)substr($value,0,-1);
		
		switch(strtolower($lastChar)){
			
			case 'g':
				$num *= 1024;
			case 'm':
				$num *= 1024;
			case 'k':
				$num *= 1024;
			break;
		}
		return $num;
	}
}
		
	