<?php
defined('WikyBlog') or die("Not an entry point...");


class ConfigLinks{
	
	var $showGroup = false;
	var $userlevels = array();
	
	function ConfigLinks(){
		global $page,$pageOwner,$langA;
		$contentUri = $page->regLink('Link Configuration','/Admin/'.$pageOwner['username'].'/ConfigLinks');
		
		$page->autoForm = true;
		wbLang::getFile('SPEC');
		
		$this->userlevels[-1] = 'Unrestricted';
		$this->userlevels[0] = 'Anonymous';
		$this->userlevels[1] = 'Registered';
		$this->userlevels[2] = 'Workgroup';
		$this->userlevels[3] = 'Owner';
		$this->userlevels[4] = 'Owner (strict)';
		$this->userlevels[5] = 'Admin';
			
		ob_start();
		$show = true;
		switch($page->userCmd){
			case 'reset':
				ConfigLinks::setDefaults();
			break;
			case 'restore':
				ConfigLinks::restore();
			break;
			
			//options
			case 'disable':
				$this->disable();
			break;
			case 'enable':
				$this->enable();
			break;
			case 'show':
				$this->show();
			break;
			case 'hide':
				$this->hide();
			break;
			
			//moving
			case 'linkup':
				if( !$this->linkup() ){
					//$show = false;
				}
			break;
			case 'linkdown':
				$this->linkdown();
			break;
			case 'agroupup':
				ConfigLinks::groupUp(true);
			break;
			case 'agroupdown':
				ConfigLinks::groupDown(true);
			break;
			case 'groupup':
				ConfigLinks::groupUp();
			break;
			case 'groupdown':
				ConfigLinks::groupDown();
			break;
			
			//options
			case 'more':
				$this->moreOptions();
				$show = false;
			break;
			
			case 'save':
			case wbStrtolower($langA['save']):
				$this->saveOptions();
			break;
			
		}
		if( $show ){
			$this->organize();
		}
		
		
		$page->contentB[$contentUri] = wb::get_clean();
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//		Modify Entries
	//
	function saveOptions(){
		global $wbTables,$langA;
		$changedLevel = $changedHeader = false;
		
		if( !is_numeric($_POST['id']) ){
			message('INVALID_REQUEST');
			return false;
		}
		$page->css2 = true;
		
		
		//get current info
		$query = 'SELECT * FROM  '.$wbTables['config_links'];
		$query .= ' WHERE `id` = '.$_POST['id'];
		$query .= ' LIMIT 1 OFFSET 0';
		$result = wbDB::runQuery($query);
		if( mysql_num_rows($result) < 1 ){
			message('INVALID_REQUEST');
			return false;
		}
		$row = mysql_fetch_assoc($result);
		
		//userlevel (special only)
		if( (int)$row['userlevel'] < 5 ){
			if( (int)$_POST['userlevel'] !== (int)$row['userlevel'] ){
				$changedLevel = true;
				$row['userlevel'] = $_POST['userlevel'];
			}
		}
		
		//header
		$header = array_search($_POST['header'],$langA);
		if( !$header ){
			$header = $_POST['header'];
		}
		if( $header !== $row['header'] ){
			$changedHeader = true;
			$row['header'] = $header;
		}
		
		if( !$changedHeader && !$changedLevel ){
			return;
		}
		
		//update
		if( !$changedHeader ){
			$query = 'UPDATE '.$wbTables['config_links'];
			$query .= ' SET `userlevel` = "'.wbDB::escape($row['userlevel']).'" ';
			$query .= ' WHERE `id` = '.$_POST['id'];
			$num = wbDB::runQuery($query,true);
			
		}else{
		
			$newValues[$row['link']] = $row;
			$query = 'DELETE FROM  '.$wbTables['config_links'];
			$query .= ' WHERE `id` = '.$_POST['id'];
			wbDB::runQuery($query);
			$num = ConfigLinks::addLinks($newValues);
		}
		if( $num > 0 ){
			message('Saved');
		}else{
			message('Oops, that didn\'t work, please try again.');
		}
	}
	
	function moreOptions(){
		global $wbTables,$langA,$page;
		if( !is_numeric($_GET['id']) ){
			message('INVALID_REQUEST');
			return false;
		}
		$page->css2 = true;
		
		
		$query = 'SELECT * FROM  '.$wbTables['config_links'];
		$query .= ' WHERE `id` = '.$_GET['id'];
		$query .= ' LIMIT 1 OFFSET 0';
		$result = wbDB::runQuery($query);
		if( mysql_num_rows($result) < 1 ){
			message('INVALID_REQUEST');
			return false;
		}
		
		$row = mysql_fetch_assoc($result);
		echo '<input type="hidden" name="id" value="'.$row['id'].'" />';
		
		echo '<table style="margin-right:auto;margin-left:auto;" >';
		echo '<tr><td>';
		echo '<tr>';
		echo '<td style="text-align:center;" >';
		echo '<h3>';
			if( !empty($row['display']) ){
				echo $row['link'];
				echo ' <span style="font-weight:bold" title="Not Actual Display">*</span>';
			}elseif( (int)$row['userlevel'] ===  5 ){
				echo wbLinks::admin($row['link'],$row['label']);
			}else{
				echo wbLinks::special($row['link'],$row['label']);
			}
			echo '</h3>';
			
		echo '<table cellspacing="7" class="WBeditArea1">';
		echo '<tr>';
			echo '<td style="text-align:right;">';
			echo '<b>';
			echo 'Header';
			echo ':</b>';
			echo '</td>';
			echo '<td>';
			if( isset($langA[$row['header']]) ){
				$value = $langA[$row['header']];
			}else{
				$value = $row['header'];
			}
			echo ' <input type="text" name="header" size="15" value="'.wbHtmlspecialchars($value).'" />';
			echo '</td>';
			echo '</tr>';
		
		echo '<tr>';
			echo '<td style="text-align:right;">';
			echo '<b>';
			echo 'Userlevel';
			echo ':</b>';
			echo '</td>';
			echo '<td>';
			if( (int)$row['userlevel'] === 5 ){
				echo $this->userlevels[5];
			}else{
				echo '<select name="userlevel">';
				foreach($this->userlevels as $int => $label){
					
					if( $int === 5 ){
						continue;
					}
					
					if( $int === (int)$row['userlevel'] ){
						echo '<option value="'.$int.'" selected="selected">'.$label.' ('.$int.')</option>';	
					}else{
						echo '<option value="'.$int.'">'.$label.' ('.$int.')</option>';
					}
				}
				echo '</select>';
			}
			echo '</td>';
			echo '</tr>';
		
		echo '<tr>';
			echo '<td style="text-align:right;">';
			echo '</td>';
			echo '<td>';
			echo '<input type="submit" name="cmd" value="'.$langA['save'].'" />';
			echo ' &nbsp; ';
			echo '<input type="submit" name="" value="'.$langA['cancel'].'" />';
			echo ' &nbsp; ';
			echo '<input type="reset"  />';
			echo '</td>';
			echo '</tr>';
		
		echo '</table>';
		
		echo '</td></tr>';
		echo '</table>';
		
	}

	
	function linkdown(){
		global $wbTables;
		if( !is_numeric($_GET['id']) ){
			message('INVALID_REQUEST');
			return false;
		}
		
		$query = 'SELECT `order_group`, `order_link`, `userlevel` FROM  '.$wbTables['config_links'];
		$query .= ' WHERE `id` = '.$_GET['id'];
		$query .= ' LIMIT 1 OFFSET 0';
		$result = wbDB::runQuery($query);
		if( !$result ){
			message('INVALID_REQUEST');
			return false;
		}
		$row = mysql_fetch_assoc($result);
		
		
		
		//is there a following entry?
		$query = 'SELECT * FROM '.$wbTables['config_links'];
		$query .= ' WHERE ';
		$query .= '  `order_link` > '.($row['order_link']);
		$query .= ' AND `order_group` = '.$row['order_group'];
		if( (int)$row['userlevel'] === 5){
			$query .= ' AND `userlevel` = 5 ';
		}else{
			$query .= ' AND `userlevel` < 5 ';
		}
		$query .= ' ORDER BY `order_link` ASC '; //! ASC
		$query .= ' LIMIT 1 OFFSET 0 ';
		$result = wbDB::runQuery($query);
		if( mysql_num_rows($result) < 1){
			message('Cannot Move Any Further.');
			return false;
		}
		$row2 = mysql_fetch_assoc($result);
		
		
		$this->moveLink($row,$row2);
	}
	
	function moveLink($topLink,$bottomLink){
		global $wbTables;
		
		$query = 'UPDATE '.$wbTables['config_links'];
		$query .= ' SET ';
		$query .= ' `order_link` = CASE `order_link` WHEN '.$topLink['order_link'].' THEN '.($topLink['order_link']+1).' WHEN '.$bottomLink['order_link'].' THEN '.$topLink['order_link'].'  END ';
		$query .= ' WHERE ';
		$query .= ' ( `order_link` = '.$topLink['order_link'];
		$query .= ' OR `order_link` = '.($bottomLink['order_link']).' ) ';
		$query .= ' AND `order_group` = '.$topLink['order_group'];
		if( (int)$topLink['userlevel'] === 5){
			$query .= ' AND `userlevel` = 5 ';
		}else{
			$query .= ' AND `userlevel` < 5 ';
		}				
		$num = wbDB::runQuery($query,true);
		message('Moved ');
	}
	
	
	function linkup(){
		global $wbTables;
		if( !is_numeric($_GET['id']) ){
			message('INVALID_REQUEST');
			return false;
		}		
		
		$query = 'SELECT `order_group`, `order_link`, `userlevel` FROM  '.$wbTables['config_links'];
		$query .= ' WHERE `id` = '.$_GET['id'];
		$query .= ' LIMIT 1 OFFSET 0';
		$result = wbDB::runQuery($query);
		if( !$result ){
			message('INVALID_REQUEST');
			return false;
		}
		$row = mysql_fetch_assoc($result);
		
		//is there a previous entry?
		$query = 'SELECT * FROM '.$wbTables['config_links'];
		$query .= ' WHERE ';
		$query .= '  `order_link` < '.($row['order_link']);
		$query .= ' AND `order_group` = '.$row['order_group'];
		if( (int)$row['userlevel'] === 5){
			$query .= ' AND `userlevel` = 5 ';
		}else{
			$query .= ' AND `userlevel` < 5 ';
		}
		$query .= ' ORDER BY `order_link` DESC '; //! DESC
		$query .= ' LIMIT 1 OFFSET 0 ';
		$result = wbDB::runQuery($query);
		if( mysql_num_rows($result) < 1){
			message('Cannot Move Any Further.');
			return false;
		}
		$topRow = mysql_fetch_assoc($result);
		$this->moveLink($topRow,$row);
	}
	
	/* static */
	function groupUp($admin=false,$visible=false){
		global $wbTables;
		if( !is_numeric($_GET['grp']) ){
			message('INVALID_REQUEST');
			return;
		}
		
		
		//is there a previous group? not necessarily going to be grp-1
		$query = 'SELECT `order_group` FROM '.$wbTables['config_links'];
		$query .= ' WHERE `order_group` < '.$_GET['grp'];
		if( $admin ){
			$query .= ' AND `userlevel` = 5 ';
		}else{
			$query .= ' AND `userlevel` < 5 ';
		}
		if( $visible ){
			$query .= ' AND `visible` > 0 ';
		}
		$query .= ' ORDER BY  `order_group` DESC ';
		$query .= ' LIMIT 1 OFFSET 0';
		$result = wbDB::runQuery($query);
		if( mysql_num_rows($result) < 1){
			message('Cannot Move Any Further.');
			return;
		}
		$row = mysql_fetch_assoc($result);
		
		ConfigLinks::moveGroup($row['order_group'],$_GET['grp'],$admin);
	}
	
	/* static */
	function groupDown($admin=false,$visible=false){
		global $wbTables;
		if( !is_numeric($_GET['grp']) ){
			message('INVALID_REQUEST');
			return;
		}
		
		//is there a following group? not necessarily going to be grp+1
		$query = 'SELECT `order_group` FROM '.$wbTables['config_links'];
		$query .= ' WHERE `order_group` > '.$_GET['grp'];
		if( $admin ){
			$query .= ' AND `userlevel` = 5 ';
		}else{
			$query .= ' AND `userlevel` < 5 ';
		}
		if( $visible ){
			$query .= ' AND `visible` > 0 ';
		}
		$query .= ' ORDER BY  `order_group` ASC ';
		$query .= ' LIMIT 1 OFFSET 0';
		$result = wbDB::runQuery($query);
		if( mysql_num_rows($result) < 1){
			message('Cannot Move Any Further.');
			return;
		}
		
		$row = mysql_fetch_assoc($result);
		
		ConfigLinks::moveGroup($_GET['grp'],$row['order_group'],$admin);
	}
	
	/* static */
	function moveGroup($topNum,$bottomNum,$admin){
		global $wbTables;
		
		$query = 'UPDATE '.$wbTables['config_links'];
		$query .= ' SET ';
		$query .= ' `order_group` = CASE `order_group` WHEN '.$topNum.' THEN '.$bottomNum.' WHEN '.$bottomNum.' THEN '.$topNum.'  END ';
		$query .= ' WHERE ';
		$query .= ' ( `order_group` = '.$topNum;
		$query .= ' OR `order_group` = '.$bottomNum.' ) ';
		if( $admin ){
			$query .= ' AND `userlevel` = 5 ';
		}else{
			$query .= ' AND `userlevel` < 5 ';
		}
		$num = wbDB::runQuery($query,true);
		message('Moved ');		
	}
	
	function show(){
		global $wbTables;
		
		if( !is_numeric($_GET['id']) ){
			message('INVALID_REQUEST');
			return;
		}
		
		$query = 'UPDATE  '.$wbTables['config_links'];
		$query .= ' SET `visible` = 1 ';
		$query .= ' WHERE `id` = "'.$_GET['id'].'" ';
		$query .= ' AND `visible` = 0 ';
		$query .= ' LIMIT 1 ';
		$num = wbDB::runQuery($query,true);
		if( $num == 1 ){
			message('showing');
		}else{
			message('Oops, that didn\'t work, please try again.');
		}
	}
	function hide(){
		global $wbTables;
		
		if( !is_numeric($_GET['id']) ){
			message('INVALID_REQUEST');
			return;
		}
		
		$query = 'UPDATE  '.$wbTables['config_links'];
		$query .= ' SET `visible` = 0 ';
		$query .= ' WHERE `id` = "'.$_GET['id'].'" ';
		$query .= ' AND `visible` = 1 ';
		$query .= ' LIMIT 1 ';
		$num = wbDB::runQuery($query,true);
		if( $num == 1 ){
			message('hidden');
		}else{
			message('Oops, that didn\'t work, please try again.');
		}
	}
	function enable(){
		global $wbTables;
		
		if( !is_numeric($_GET['id']) ){
			message('INVALID_REQUEST');
			return;
		}
		
		$query = 'UPDATE  '.$wbTables['config_links'];
		$query .= ' SET `enabled` = 1 ';
		$query .= ' WHERE `id` = "'.$_GET['id'].'" ';
		$query .= ' AND `enabled` = 0 ';
		$query .= ' LIMIT 1 ';
		$num = wbDB::runQuery($query,true);
		if( $num == 1 ){
			message('enabled');
		}else{
			message('Oops, that didn\'t work, please try again.');
		}
	}
	function disable(){
		global $wbTables;
		
		if( !is_numeric($_GET['id']) ){
			message('INVALID_REQUEST');
			return;
		}
		
		$query = 'UPDATE  '.$wbTables['config_links'];
		$query .= ' SET `enabled` = 0 ';
		$query .= ' WHERE `id` = "'.$_GET['id'].'" ';
		$query .= ' AND `enabled` = 1 ';
		$query .= ' LIMIT 1 ';
		$num = wbDB::runQuery($query,true);
		if( $num == 1 ){
			message('disabled');
		}else{
			message('Oops, that didn\'t work, please try again.');
		}
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//		Show
	//
	
	
	function organize(){
		global $wbTables,$langA,$page,$jsNum;
		
		echo '<div style="border:1px solid #ccc;padding:5px;float:right;text-align:right">';
		echo wbLinks::admin('ConfigLinks?cmd=restore','Restore Defaults');
		echo '<br/><span class="sm">Will restore userlevel, <br/> enabled and visible  values.</span>';
		echo '</div>';
		
		echo 'This script is used to manage the special and admin links and their associated scripts.';
		
		echo '<ul>';
		echo '<li><a href="#special">Special Links</a>';
		echo '<li><a href="#admin">Admin Links</a>';
		echo '</ul>';
		
		
		//Special Links
		echo '<a name="special"></a>';
		echo '<h2>Special Links</h2>';
		$query = 'SELECT * FROM '.$wbTables['config_links'];
		$query .= ' WHERE `userlevel` < 5 ';
		$query .= ' ORDER BY `order_group`, `order_link` ';
		$result = wbDB::runQuery($query);
		$this->showResult($result);
		
		//Admin Links
		echo '<a name="admin"></a>';
		echo '<h2>Admin Links</h2>';
		$query = 'SELECT * FROM '.$wbTables['config_links'];
		$query .= ' WHERE `userlevel` = 5 ';
		$query .= ' ORDER BY `order_group`, `order_link` ';
		$result = wbDB::runQuery($query);
		$this->showResult($result);
		$page->scripts[] = '/include/js/editing.js?'.$jsNum;
		
		echo '<div class="WBsearchFooter">';
		echo '<ul>';
		echo '<li>Links noted with an asterisk (*) have special displays.</li>';
		echo '<li>The visible option determines whether or not the link will be displayed in the Control Panel.</li>';
		echo '</div>';
	}
	
	function showResult($result){
		global $langA;
		
		$classes[] = ' class="tableRowOdd" ';
		$classes[] = ' class="tableRowEven" ';
		$currHeading = '';
		$i = 0;
		$max = mysql_num_rows($result);
		while($row = mysql_fetch_assoc($result) ){
			
			
			if( $row['header'] != $currHeading ){
				
				if( $currHeading ){
					echo '</table>';
					echo '</fieldset>';
				}
				
				echo '<fieldset >';
				echo '<legend ';
					echo ' onmouseover="if(!WB)return;WB.SIO(this)"';
					echo ' onmouseout="if(!WB)return;WB.HI(this)"';
					echo '>';
					
					echo '<a href="#"  onclick="WB.SI(this.parentNode.parentNode)" >';
				
					if( isset($langA[$row['header']]) ){
						echo $langA[$row['header']];
					}else{
						echo $row['header'];
					}
					echo '</a>';

					echo ' &nbsp; ';

					if( (int)$row['userlevel'] < 5 ){
						$label =  '<img alt="" height="16" style="vertical-align:bottom" width="16" src="'.wbLinks::getDir('/imgs/icons/arrow_up.gif').'" />';
						echo wbLinks::admin('ConfigLinks?cmd=groupup&grp='.$row['order_group'],$label);
						echo ' &nbsp; ';
						$label =  '<img alt="" height="16" style="vertical-align:bottom" width="16" src="'.wbLinks::getDir('/imgs/icons/arrow_down.gif').'" />';
						echo wbLinks::admin('ConfigLinks?cmd=groupdown&grp='.$row['order_group'],$label);
					}else{
						$label =  '<img alt="" height="16" style="vertical-align:bottom" width="16" src="'.wbLinks::getDir('/imgs/icons/arrow_up.gif').'" />';
						echo wbLinks::admin('ConfigLinks?cmd=agroupup&grp='.$row['order_group'],$label);
						echo ' &nbsp; ';
						$label =  '<img alt="" height="16" style="vertical-align:bottom" width="16" src="'.wbLinks::getDir('/imgs/icons/arrow_down.gif').'" />';
						echo wbLinks::admin('ConfigLinks?cmd=agroupdown&grp='.$row['order_group'],$label);
					}
					echo ' &nbsp; ';
					echo '</legend>';
					
					
				//Start Table
				echo '<table style="clear:both;width:100%;margin:1em .5em 1em .5em;" class="loadHide">';
					echo '<tr>';
					echo '<td class="underline" width="20%">Link</td>';
					echo '<td class="underline" width="15%">Userlevel</td>';
					echo '<td class="underline" width="10%">Enabled</td>';
					echo '<td class="underline" width="10%">Visible</td>';
					echo '<td class="underline" width="10%">Options</td>';
					echo '<td class="underline" width="35%">About</td>';
					echo '</tr>';					
					
					$currHeading = $row['header'];
			}else{
				echo '<tr>';
			}
			
			echo '<td>';
				if( !empty($row['display']) ){
					echo $row['link'];
					echo ' <span style="font-weight:bold" title="Not Actual Display">*</span>';
				}elseif( (int)$row['userlevel'] ===  5 ){
					echo wbLinks::admin($row['link'],$row['label']);
				}else{
					echo wbLinks::special($row['link'],$row['label']);
				}
				echo '</td>';
			
			echo '<td>';
				echo $this->translateLevel($row['userlevel']);
				echo '</td>';
				
			echo '<td abbr="'.$row['enabled'].'">';
				if( (int)$row['enabled'] === 0 ){
					$label =  '<img alt="" height="16" width="16" src="'.wbLinks::getDir('/imgs/icons/delete.gif').'" />';
					echo wbLinks::admin('ConfigLinks?cmd=enable&id='.$row['id'],$label);
				}elseif( (int)$row['enabled'] === 2 ){
					echo 'always';
				}else{
					$label = '<img alt="" height="16" width="16" src="'.wbLinks::getDir('/imgs/icons/tick.gif').'" />';
					echo wbLinks::admin('ConfigLinks?cmd=disable&id='.$row['id'],$label);
				}
				echo '</td>';
			
			
			echo '<td abbr="'.$row['visible'].'">';
				if( (int)$row['visible'] === 0 ){
					$label = '<img alt="" height="16" width="16" src="'.wbLinks::getDir('/imgs/icons/delete.gif').'" />';
					echo wbLinks::admin('ConfigLinks?cmd=show&id='.$row['id'],$label);
				}elseif( (int)$row['visible'] === 2 ){
					echo 'always';
				}else{
					$label = '<img alt="" height="16" width="16" src="'.wbLinks::getDir('/imgs/icons/tick.gif').'" />';
					echo wbLinks::admin('ConfigLinks?cmd=hide&id='.$row['id'],$label);
				}
				echo '</td>';

			echo '<td style="white-space:nowrap">';
				$label =  '<img alt="" height="16" style="vertical-align:bottom" width="16" src="'.wbLinks::getDir('/imgs/icons/arrow_up.gif').'" />';
				echo wbLinks::admin('ConfigLinks?cmd=linkup&id='.$row['id'],$label);
				echo ' ';
				$label =  '<img alt="" height="16" style="vertical-align:bottom" width="16" src="'.wbLinks::getDir('/imgs/icons/arrow_down.gif').'" />';
				echo wbLinks::admin('ConfigLinks?cmd=linkdown&id='.$row['id'],$label);
				echo ' ';
				echo wbLinks::admin('ConfigLinks?cmd=more&id='.$row['id'],'more');
				
				echo '</td>';
				
			echo '<td class="sm">';
				echo $row['about'];
				echo '</td>';
			echo '</tr>';
			$i++;
		}
		if( $currHeading ){
			echo '</table>';
			echo '</fieldset>';
		}
	}
	
	function translateLevel($integer){
		return $this->userlevels[$integer];
	}
	
	function addLinks($linkArray,$overwrite=false){
		global $wbTables,$page,$wbNow;
		
		//get existing orders
		static $next_group_index = 0;
		static $special_groups = array();
		static $special_links = array();
		
		static $next_admin_index = 0;
		static $admin_groups = array();
		static $admin_links = array();
		
		//set static variables
		if( empty($special_groups) ){
		
			$query = 'SELECT `order_group`, MAX(`order_link`) as `order_link`, `header`, MAX(`userlevel`) as `userlevel` ';
			$query .= ', IF( `userlevel` = 5, 1, 0 ) as `is_admin` ';
			$query .= ' FROM '.$wbTables['config_links'];
			$query .= ' GROUP BY  `is_admin`, `order_group` ';
			$result = wbDB::runQuery($query);
			while($row = mysql_fetch_assoc($result)){
				
				$row['order_group'] = (int)$row['order_group'];
				
				//new
				if( (int)$row['userlevel'] === 5  ){
					if( $row['order_group'] > $next_admin_index ){
						$next_admin_index = $row['order_group'];
						
					}
					$admin_groups[$row['order_group']] = $row['header'];
					$admin_links[$row['order_group']] = ((int)$row['order_link']+1);
					
				}else{
					if( $row['order_group'] > $next_group_index ){
						$next_group_index = $row['order_group'];
					}
					$special_groups[$row['order_group']] = $row['header'];
					$special_links[$row['order_group']] = ((int)$row['order_link']+1);
				}
				
			}
			
			$next_group_index++;
			$next_admin_index++;
		}
		
		
		//Go through each link and add it if it doesn't alread exist
		$i = 0;
		foreach($linkArray as $link => $info){
			
			$info += array(	'img'=>''
						,'userlevel'=>-1
						,'label'=>''
						,'display'=>''
						,'script'=>''
						,'visible'=>'1'
						,'about'=>''
						,'enabled'=>'1'
						,'plugin_space'=>''
						,'plugin_dir'=>''
						);
			$info['userlevel'] = (int)$info['userlevel'];
			
			
			
			//update label, img, script, about, display
			// optionally plugin_space and plugin_dir
			$query = 'UPDATE '.$wbTables['config_links'];
			$query .= ' SET ';
			$query .= ' `img` = "'.wbDB::escape($info['img']).'" ';
			$query .= ', `label` = "'.wbDB::escape($info['label']).'" ';
			$query .= ', `script` = "'.wbDB::escape($info['script']).'" ';
			$query .= ', `about` = "'.wbDB::escape($info['about']).'" ';
			$query .= ', `modified` = "'.wbDB::escape($wbNow).'" ';
			$query .= ', `display` = "'.wbDB::escape($info['display']).'" ';
			$query .= ', `plugin_space` = "'.wbDB::escape($info['plugin_space']).'" ';
			$query .= ', `plugin_dir` = "'.wbDB::escape($info['plugin_dir']).'" ';
			$query .= ' WHERE ';
			$query .= ' `link` = "'.wbDB::escape($link).'" ';
			$query .= ' AND `modified` != "'.wbDB::escape($wbNow).'" ';
			
			if( $overwrite === false){
				$query .= ' AND `plugin_space` = "'.wbDB::escape($info['plugin_space']).'" ';
			}elseif( is_string($overwrite) ){
				$query .= ' AND `plugin_space` = "'.wbDB::escape($overwrite).'" ';
			}
			
			$query .= ' LIMIT 1 ';
			$num = wbDB::runQuery($query,true);
			
			// $num > 0 indicates the link exists and we don't need to go any further
			if( $num > 0 ){
				continue;
			}
			if( is_string($overwrite) ){
				continue;
			}
			
			//new
			if( $info['userlevel'] === 5  ){
				
				//current group?
				$current_admin_group = array_search($info['header'],$admin_groups);
				if( is_null($current_admin_group)){ //for versions < 4.2
					$current_admin_group = false;
				}
				//start new group if needed
				if( $current_admin_group === false){
					$current_admin_group = $next_admin_index;
					$admin_groups[$current_admin_group] = $info['header'];
					$admin_links[$current_admin_group] = 1;
					$next_admin_index++;
				}
				
			}else{
				//current group?
				$current_order_group = array_search($info['header'],$special_groups);
				if( is_null($current_order_group)){ //for versions < 4.2
					$current_order_group = false;
				}
				
				//start new group if needed
				if( $current_order_group === false){
					$current_order_group = $next_group_index;
					$special_groups[$current_order_group] = $info['header'];
					$special_links[$current_order_group] = 1;
					$next_group_index++;
				}
			}
			
			
			$query = 'INSERT IGNORE INTO '.$wbTables['config_links'];
			$query .= 'SET ';
			$query .= ' `plugin_space` = "'.wbDB::escape($info['plugin_space']).'" ';
			$query .= ', `plugin_dir` = "'.wbDB::escape($info['plugin_dir']).'" ';
			$query .= ', `link` = "'.wbDB::escape($link).'" ';
			$query .= ', `label` = "'.wbDB::escape($info['label']).'" ';
			$query .= ', `display` = "'.wbDB::escape($info['display']).'" ';
			$query .= ', `script` = "'.wbDB::escape($info['script']).'" ';
			$query .= ', `header` = "'.wbDB::escape($info['header']).'" ';
			$query .= ', `img` = "'.wbDB::escape($info['img']).'" ';
			$query .= ', `userlevel` = "'.wbDB::escape($info['userlevel']).'" ';
			$query .= ', `visible` = "'.wbDB::escape($info['visible']).'" ';
			$query .= ', `enabled` = "'.wbDB::escape($info['enabled']).'" ';
			$query .= ', `about` = "'.wbDB::escape($info['about']).'" ';
			$query .= ', `modified` = "'.wbDB::escape($wbNow).'" ';
			
			if( $info['userlevel'] === 5  ){
				$query .= ', `order_link` = "'.wbDB::escape($admin_links[$current_admin_group]).'" ';
				$query .= ', `order_group` = "'.wbDB::escape($current_admin_group).'" ';
				$admin_links[$current_admin_group]++;
			}else{
				$query .= ', `order_link` = "'.wbDB::escape($special_links[$current_order_group]).'" ';
				$query .= ', `order_group` = "'.wbDB::escape($current_order_group).'" ';
				$special_links[$current_order_group]++;
			}
			
			$i++;
			wbDB::runQuery($query);
		}
		
		
		return $i;
	}
	
	function cleanUnused($plugin_space){
		global $wbTables, $wbNow;
		
		if( $plugin_space === false ){
			$plugin_space = '';
		}
		
		//remove any links that weren't updated
		$query = 'DELETE FROM '.$wbTables['config_links'];
		$query .= ' WHERE ';
		$query .= ' `plugin_space` = "'.wbDB::escape($plugin_space).'" ';
		$query .= ' AND `modified` != "'.wbDB::escape($wbNow).'" ';
		
		$num = wbDB::runQuery($query,true);
		//message('deleted '.$num. ' for '.$plugin_space);
	}		
	
	
	//
	//	This should just be an update script..
	//
	function setDefaults($plugin_space=false){
		
		//add defaults back
		$linkArray = ConfigLinks::getDefaultLinks();
		$i = ConfigLinks::addLinks($linkArray,$plugin_space);
		ConfigLinks::cleanUnused($plugin_space);
	}
	
	
	
	//restore: visibile, enabled, userlevel
	function restore(){
		global $wbTables;
		$linkArray = ConfigLinks::getDefaultLinks();
		
		
		foreach($linkArray as $link => $info ){
			$info += array(	'userlevel'=>'-1',
						'visible'=>'1',
						'enabled'=>'1',
						);
			
			$query = 'UPDATE '.$wbTables['config_links'];
			$query .= 'SET ';
			$query .= ' `userlevel` = "'.wbDB::escape($info['userlevel']).'" ';
			$query .= ', `visible` = "'.wbDB::escape($info['visible']).'" ';
			$query .= ', `enabled` = "'.wbDB::escape($info['enabled']).'" ';
			$query .= ' WHERE  1 ';
			
			if( !empty($info['plugin_space']) ){
				$query .= ' AND `plugin_space` = "'.wbDB::escape($info['plugin_space']).'" ';
				$query .= ' AND `plugin_dir` = "'.wbDB::escape($info['plugin_dir']).'" ';
			}else{
				$query .= ' AND `plugin_space` = "" ';
				$query .= ' AND`plugin_dir` = "" ';
			}
			$query .= ' AND `link` = "'.wbDB::escape($link).'" ';
			wbDB::runQuery($query);
		}
		
		message('Defaults restored.');
	}
	
	//similar to plugin links
	//$linkArray[--name--][--variable--] = --value--
	//
	//		--display--		correlates to a specific value in ControlPanel.php
	//		--label--		when not using --display--, --label-- will determine the text of the link
	
	function getDefaultLinks(){
		global $wbWritable;
		
		$linkArray = array();
		
		//
		// User
		//
		
		//login
		$link = 'login';
		$linkArray[$link]['header'] = 'log_in';
		$linkArray[$link]['display'] = 'login';
		$linkArray[$link]['script'] = '/include/special/ControlPanel.php';
		$linkArray[$link]['visible'] = '2';
		$linkArray[$link]['enabled'] = '2';
		$linkArray[$link]['about'] = 'Shows the login form.';
		
		//register
		$link = 'register';
		$linkArray[$link]['header'] = 'user';
		$linkArray[$link]['display'] = 'register';
		$linkArray[$link]['script'] = '/include/special/SessRegister.php';
		$linkArray[$link]['about'] = 'Only shown in the Control Panel when user is not logged in.';
		
		
		//lostpass
		$link = 'lostpassword';
		$linkArray[$link]['header'] = 'user';
		$linkArray[$link]['display'] = 'lostpass';
		$linkArray[$link]['script'] = '/include/special/LostPass.php';
		$linkArray[$link]['about'] = 'Only shown in the Control Panel when user is not logged in.';
		
		
		
		//
		// General
		//
		

		//Preferences
		$link = 'Preferences';
		$linkArray[$link]['header'] = 'general';
		$linkArray[$link]['label'] = 'preferences';
		$linkArray[$link]['script'] = '/include/special/Preferences.php';
		$linkArray[$link]['img'] = '/imgs/icons/application_view_list.gif';
		$linkArray[$link]['userlevel'] = '4';
		
		//JSPrefs
		$link = 'JSPrefs';
		$linkArray[$link]['header'] = 'general';
		$linkArray[$link]['label'] = 'preferences';
		$linkArray[$link]['script'] = '/include/special/PreferencesJS.php';
		$linkArray[$link]['img'] = '/imgs/icons/application_view_list.gif';
		$linkArray[$link]['visible'] = '0';
		
		
		//Permissions
		$link = 'Permissions';
		$linkArray[$link]['header'] = 'general';
		$linkArray[$link]['label'] = 'permissions';
		$linkArray[$link]['script'] = '/include/special/WorkGroup.php';
		$linkArray[$link]['img'] = '/imgs/icons/group.gif';
		$linkArray[$link]['userlevel'] = '3';
		
		//Friends
		$link = 'Friends';
		$linkArray[$link]['header'] = 'general';
		$linkArray[$link]['label'] = 'friends';
		$linkArray[$link]['script'] = '/include/special/Friends.php';
		$linkArray[$link]['img'] = '/imgs/icons/group.gif';
		$linkArray[$link]['userlevel'] = '3';

		//Default Page Options
		$link = 'DefaultOptions';
		$linkArray[$link]['header'] = 'general';
		$linkArray[$link]['label'] = 'default_page_options';
		$linkArray[$link]['script'] = '/include/special/DefaultOptions.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_key.gif';
		$linkArray[$link]['userlevel'] = '3';
		
		//WatchList
		$link = 'Watchlist';
		$linkArray[$link]['header'] = 'general';
		$linkArray[$link]['label'] = 'watchlist';
		$linkArray[$link]['script'] = '/include/search/Watchlist.php';
		$linkArray[$link]['img'] = '/imgs/icons/application_view_list.gif';
		$linkArray[$link]['userlevel'] = '3';
		
		//
		// Account Display
		//
				
		//Tabs
		$link = 'Tabs';
		$linkArray[$link]['header'] = 'account_display';
		$linkArray[$link]['label'] = 'tabs';
		$linkArray[$link]['script'] = '/include/special/OwnerTabs.php';
		$linkArray[$link]['img'] = '/imgs/icons/tab.gif';
		$linkArray[$link]['userlevel'] = '3';
		
		//Links
		$link = 'Links';
		$linkArray[$link]['header'] = 'account_display';
		$linkArray[$link]['label'] = 'links';
		$linkArray[$link]['script'] = '/include/special/OwnerLinks.php';
		$linkArray[$link]['img'] = '/imgs/icons/link.gif';
		$linkArray[$link]['userlevel'] = '3';

		//LinkGroups
		$link = 'LinkGroups';
		$linkArray[$link]['header'] = 'account_display';
		$linkArray[$link]['label'] = 'link_groups';
		$linkArray[$link]['script'] = '/include/special/OwnerLinkGroups.php';
		$linkArray[$link]['img'] = '/imgs/icons/link.gif';
		$linkArray[$link]['userlevel'] = '3';
		$linkArray[$link]['visible'] = '0';

				
		//Edit Template
		if( !isset($wbWritable) || $wbWritable === true){
			$link = 'edittemplate';
			$linkArray[$link]['header'] = 'account_display';
			$linkArray[$link]['display'] = 'edittemplate';
		}
		
		//templates
		$link = 'Templates';
		$linkArray[$link]['header'] = 'account_display';
		$linkArray[$link]['label'] = 'pTemplate';
		$linkArray[$link]['script'] = '/include/special/Templates.php';
		$linkArray[$link]['img'] = '/imgs/icons/layout.gif';
		//$linkArray[$link]['userlevel'] = '3';
		
		//CCLicense
		$link = 'CCLicense';
		$linkArray[$link]['header'] = 'account_display';
		$linkArray[$link]['label'] = 'content_license';
		$linkArray[$link]['script'] = '/include/special/LicenseCC.php';
		$linkArray[$link]['img'] = '/imgs/icons/script.gif';
		$linkArray[$link]['userlevel'] = '3';
				
		//
		// Editing
		//
		
		//changelog
		$link = 'ChangeLog';
		$linkArray[$link]['header'] = 'editing';
		$linkArray[$link]['label'] = 'change_log';
		$linkArray[$link]['script'] = '/include/search/ChangeLog.php';
		$linkArray[$link]['img'] = '/imgs/icons/time.gif';
		
		//createnew
		$link = 'createnew';
		$linkArray[$link]['header'] = 'editing';
		$linkArray[$link]['display'] = 'createnew';
		
		//Reorganize
		$link = 'Reorganize';
		$linkArray[$link]['header'] = 'editing';
		$linkArray[$link]['label'] = 'reorganize';
		$linkArray[$link]['script'] = '/include/special/Reorganize.php';
		$linkArray[$link]['img'] = '/imgs/icons/wrench.gif';
		$linkArray[$link]['userlevel'] = '3';

		
		//Trash
		$link = 'Trash';
		$linkArray[$link]['header'] = 'editing';
		$linkArray[$link]['label'] = 'trash';
		$linkArray[$link]['script'] = '/include/search/Trash.php';
		$linkArray[$link]['img'] = '/imgs/icons/bin.gif';
		$linkArray[$link]['userlevel'] = '3';


		$link = 'MyEdits';
		$linkArray[$link]['header'] = 'editing';
		$linkArray[$link]['label'] = 'my_edits';
		$linkArray[$link]['script'] = '/include/search/MyEdits.php';
		$linkArray[$link]['img'] = '/imgs/icons/time.gif';
		$linkArray[$link]['userlevel'] = '3';
		
				
		//
		// Attachments
		//
		
		if( !isset($wbWritable) || $wbWritable === true){
			
			
			//manageimages
			$link = 'imagemanager';
			$linkArray[$link]['header'] = 'attachments';
			$linkArray[$link]['display'] = 'manageimages';
			$linkArray[$link]['script'] = '/include/special/FileManager.php';
			//$linkArray[$link]['userlevel'] = '3';
			

			//managefiles
			$link = 'filemanager';
			$linkArray[$link]['header'] = 'attachments';
			$linkArray[$link]['display'] = 'managefiles';
			$linkArray[$link]['script'] = '/include/special/FileManager.php';
			// $linkArray[$link]['userlevel'] = '3';
			
			
			//fileupload
			$link = 'uploadfiles';
			$linkArray[$link]['header'] = 'attachments';
			$linkArray[$link]['display'] = 'uploadfiles';
			$linkArray[$link]['script'] = '/include/special/ControlPanel.php';
			// $linkArray[$link]['userlevel'] = '0';
			// $linkArray[$link]['img'] = '/imgs/icons/picture_save.gif';

			
		}
		
		//
		// Search
		//
		
		//search
		$link = 'search';
		$linkArray[$link]['header'] = 'search';
		$linkArray[$link]['display'] = 'search';
		$linkArray[$link]['script'] = '/include/search/Search.php';
		
		
		//non tagged
		$link = 'keywordSearch?key=';
		$linkArray[$link]['header'] = 'search';
		$linkArray[$link]['label'] = 'non_tagged_files';
		$linkArray[$link]['script'] = '/include/search/Keywords.php';
		$linkArray[$link]['img'] = '/imgs/icons/folder_magnify.gif';
		
		//hidden
		$link = 'Flagged?flag=hidden';
		$linkArray[$link]['header'] = 'search';
		$linkArray[$link]['label'] = 'BROWSE_HIDDEN';
		$linkArray[$link]['script'] = '/include/search/Flagged.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_magnify.gif';
		$linkArray[$link]['userlevel'] = '3';
		
		//flagged
		$link = 'Flagged';
		$linkArray[$link]['header'] = 'search';
		$linkArray[$link]['label'] = 'flagged';
		$linkArray[$link]['script'] = '/include/search/Flagged.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_magnify.gif';
		$linkArray[$link]['userlevel'] = '3';
	
		//
		// Account Info
		//
				
		//account info
		$link = 'AccountDetails';
		$linkArray[$link]['header'] = 'account_info';
		$linkArray[$link]['label'] = 'account_details';
		$linkArray[$link]['script'] = '/include/special/AccountDetails.php';
		$linkArray[$link]['img'] = '/imgs/icons/chart_bar.gif';
		$linkArray[$link]['userlevel'] = '3';
		
		//WantedFiles
		$link = 'WantedFiles';
		$linkArray[$link]['header'] = 'account_info';
		$linkArray[$link]['label'] = 'wanted_files';
		$linkArray[$link]['script'] = '/include/search/WantedFiles.php';
		$linkArray[$link]['img'] = '/imgs/icons/link_add.gif';
		
		//DeadEnd
		$link = 'DeadEnd';
		$linkArray[$link]['header'] = 'account_info';
		$linkArray[$link]['label'] = 'dead_end';
		$linkArray[$link]['script'] = '/include/search/DeadEnd.php';
		$linkArray[$link]['img'] = '/imgs/icons/link_break.gif';

		//OrphanedFiles
		$link = 'OrphanedFiles';
		$linkArray[$link]['header'] = 'account_info';
		$linkArray[$link]['label'] = 'orphaned_files';
		$linkArray[$link]['script'] = '/include/search/Orphaned.php';
		$linkArray[$link]['img'] = '/imgs/icons/link_error.gif';
		
		//MostLinked
		$link = 'MostLinked';
		$linkArray[$link]['header'] = 'account_info';
		$linkArray[$link]['label'] = 'most_linked';
		$linkArray[$link]['script'] = '/include/search/mostlinked.php';
		$linkArray[$link]['img'] = '/imgs/icons/link.gif';

		//
		// Browse
		//
		
		//managefiles
		$link = 'blog';
		$linkArray[$link]['header'] = 'browse';
		$linkArray[$link]['display'] = 'blog';
		$linkArray[$link]['script'] = '/include/search/Blog.php';
		
		
		//BrowseAll
		$link = 'BrowseAll';
		$linkArray[$link]['header'] = 'browse';
		$linkArray[$link]['label'] = 'all';
		$linkArray[$link]['script'] = '/include/search/Keywords.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white.gif';
		
		//BrowsePages
		$link = 'BrowsePages';
		$linkArray[$link]['header'] = 'browse';
		$linkArray[$link]['label'] = 'CLASSpage';
		$linkArray[$link]['script'] = '/include/search/Files.php';
		$linkArray[$link]['img'] = '/imgs/icons/page.gif';
		
		//BrowseComments
		$link = 'BrowseComments';
		$linkArray[$link]['header'] = 'browse';
		$linkArray[$link]['label'] = 'CLASScomment';
		$linkArray[$link]['script'] = '/include/search/Files.php';
		$linkArray[$link]['img'] = '/imgs/icons/comments.gif';
		
		//managefiles
		$link = 'browsemaps';
		$linkArray[$link]['header'] = 'browse';
		$linkArray[$link]['display'] = 'browsemaps';
		
		
		//BrowseTemplates
		if( !isset($wbWritable) || $wbWritable === true){
			//$link = 'BrowseAll?space=template';
			$link = 'BrowseAll?space=theme';
			$linkArray[$link]['header'] = 'browse';
			$linkArray[$link]['label'] = 'CLASStemplate';
			$linkArray[$link]['script'] = '/include/search/Keywords.php';
			$linkArray[$link]['img'] = '/imgs/icons/layout.gif';
			
		}

		
		//
		// feeds
		//
		
		//atom_blog
		$link = 'atom_blog';
		$linkArray[$link]['header'] = 'feeds';
		$linkArray[$link]['display'] = 'atom_blog';
		$linkArray[$link]['script'] = '/include/search/Feeds.php';
			
		//atom
		$link = 'atom';
		$linkArray[$link]['header'] = 'feeds';
		$linkArray[$link]['display'] = 'atom';
		$linkArray[$link]['script'] = '/include/search/Feeds.php';
		
		//atomPosted
		$link = 'atom_posted';
		$linkArray[$link]['header'] = 'feeds';
		$linkArray[$link]['display'] = 'atom_posted';
		$linkArray[$link]['script'] = '/include/search/Feeds.php';
		
		//google_gadget
		$link = 'changeloggadget';
		$linkArray[$link]['header'] = 'feeds';
		$linkArray[$link]['display'] = 'google_gadget';
		$linkArray[$link]['script'] = '/include/search/GoogleGadget.php';
		
		
		//
		// Non Visible
		//
		
		//control panel
		$link = 'ControlPanel';
		$linkArray[$link]['header'] = 'Miscellaneous';
		$linkArray[$link]['label'] = 'control_panel';
		$linkArray[$link]['script'] = '/include/special/ControlPanel.php';
		$linkArray[$link]['enabled'] = '2';
		$linkArray[$link]['visible'] = '0';
		
		//UserEdits
		$link = 'UserEdits';
		$linkArray[$link]['header'] = 'Miscellaneous';
		$linkArray[$link]['label'] = 'user_edits';
		$linkArray[$link]['script'] = '/include/search/User.php';
		$linkArray[$link]['visible'] = '0';
		
		//keywords
		$link = 'keywordSearch';
		$linkArray[$link]['header'] = 'Miscellaneous';
		$linkArray[$link]['label'] = 'keywordsearch';
		$linkArray[$link]['script'] = '/include/search/Keywords.php';
		$linkArray[$link]['visible'] = '0';
		
		//whatlinkshere
		$link = 'whatlinkshere';
		$linkArray[$link]['header'] = 'Miscellaneous';
		$linkArray[$link]['label'] = 'what_links_here';
		$linkArray[$link]['script'] = '/include/search/WhatLinksHere.php';
		$linkArray[$link]['visible'] = '0';
		
		//wikyblog info
		$link = 'info';
		$linkArray[$link]['header'] = 'Miscellaneous';
		$linkArray[$link]['label'] = 'WikyBlog Info';
		$linkArray[$link]['script'] = '/include/special/WikyBlogInfo.php';
		$linkArray[$link]['visible'] = '0';
		
		
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//
		//		Admin Links
		//
		
		
		
		//
		//
		//
		
		//Configuration
		$link = 'Configuration';
		$linkArray[$link]['header'] = 'administration';
		$linkArray[$link]['label'] = 'configuration';
		$linkArray[$link]['script'] = '/include/admin/Config.php';
		$linkArray[$link]['img'] = '/imgs/icons/wrench.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//configLinks
		$link = 'ConfigLinks';
		$linkArray[$link]['header'] = 'administration';
		$linkArray[$link]['label'] = 'Link Configuration';
		$linkArray[$link]['script'] = '/include/admin/ConfigLinks.php';
		$linkArray[$link]['img'] = '/imgs/icons/link.gif';
		$linkArray[$link]['userlevel'] = '5';
		$linkArray[$link]['visible'] = '1';
		$linkArray[$link]['enabled'] = '2';
		
		
		//EnableMaps
		$link = 'EnableMaps';
		$linkArray[$link]['header'] = 'administration';
		$linkArray[$link]['label'] = 'Enable Maps';
		$linkArray[$link]['script'] = '/include/admin/Maps.php';
		$linkArray[$link]['img'] = '/imgs/icons/map.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//SearchOptions
		$link = 'SearchOptions';
		$linkArray[$link]['header'] = 'administration';
		$linkArray[$link]['label'] = 'search_options';
		$linkArray[$link]['script'] = '/include/admin/SearchOptions.php';
		$linkArray[$link]['img'] = '/imgs/icons/application_form_magnify.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		
		//htaccess
		$link = 'htaccess';
		$linkArray[$link]['header'] = 'administration';
		$linkArray[$link]['label'] = 'htaccess';
		$linkArray[$link]['script'] = '/include/admin/htaccess.php';
		$linkArray[$link]['img'] = '/imgs/icons/script.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//UserSearch
		$link = 'UserSearch';
		$linkArray[$link]['header'] = 'users';
		//$linkArray[$link]['header'] = 'administration';
		$linkArray[$link]['label'] = 'user_statistics';
		$linkArray[$link]['script'] = '/include/admin/Users.php';
		$linkArray[$link]['img'] = '/imgs/icons/chart_bar.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//UserGroups
		$link = 'UserGroups';
		$linkArray[$link]['header'] = 'users';
		$linkArray[$link]['label'] = 'User Groups';
		$linkArray[$link]['script'] = '/include/admin/UserGroups.php';
		$linkArray[$link]['img'] = '/imgs/icons/group.gif';
		$linkArray[$link]['userlevel'] = '5';
				
		//UserPermissions
		$link = 'Administrators';
		$linkArray[$link]['header'] = 'users';
		$linkArray[$link]['label'] = 'permissions';
		$linkArray[$link]['script'] = '/include/admin/Permissions.php';
		$linkArray[$link]['img'] = '/imgs/icons/group.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//
		//	More Configuration
		//
		
		$link = 'ConfigRegistration';
		$linkArray[$link]['header'] = 'administration';
		$linkArray[$link]['label'] = 'Configure Registration';
		$linkArray[$link]['script'] = '/include/admin/ConfigRegister.php';
		$linkArray[$link]['img'] = '/imgs/icons/wrench.gif';
		$linkArray[$link]['userlevel'] = '5';
		$linkArray[$link]['visible'] = '0';

		//
		//	Plugins
		//
		
		//Plugins
		$link = 'Plugins';
		$linkArray[$link]['header'] = 'plugins';
		$linkArray[$link]['label'] = 'Manage Plugins <span style="vertical-align:super;color:red;font-size:80%">(beta)</span>';
		$linkArray[$link]['script'] = '/include/admin/Plugins.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//ManageTypes
		$link = 'ManageTypes';
		$linkArray[$link]['header'] = 'plugins';
		$linkArray[$link]['label'] = 'Manage Data Type <span style="vertical-align:super;color:red;font-size:80%">(beta)</span>';
		$linkArray[$link]['script'] = '/include/admin/DataTypes.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//CreatePlugin
		$link = 'CreatePlugin';
		$linkArray[$link]['header'] = 'plugins';
		$linkArray[$link]['label'] = 'Custom Data Types <span style="vertical-align:super;color:red;font-size:80%">(beta)</span>';
		$linkArray[$link]['script'] = '/include/admin/PluginCreate.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//PluginSQL
		$link = 'PluginSQL';
		$linkArray[$link]['header'] = 'plugins';
		$linkArray[$link]['label'] = 'Plugin SQL <span style="vertical-align:super;color:red;font-size:80%">(beta)</span>';
		$linkArray[$link]['script'] = '/include/admin/PluginSQL.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//PluginSQL
		$link = 'PluginSQL';
		$linkArray[$link]['header'] = 'plugins';
		$linkArray[$link]['label'] = 'Plugin SQL <span style="vertical-align:super;color:red;font-size:80%">(beta)</span>';
		$linkArray[$link]['script'] = '/include/admin/PluginSQL.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//updateplugin
		$link = 'UpdatePlugin';
		$linkArray[$link]['header'] = 'plugins';
		$linkArray[$link]['label'] = 'Update Data Types <span style="vertical-align:super;color:red;font-size:80%">(beta)</span>';
		$linkArray[$link]['script'] = '/include/admin/PluginUpdate.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		$linkArray[$link]['visible'] = '0';
		

		
		
		//
		// Dynamic Content
		//

		//Directories
		$link = 'Directories';
		$linkArray[$link]['header'] = 'dynamic_content';
		$linkArray[$link]['label'] = 'Directories <span style="vertical-align:super;color:red;font-size:80%">(beta)</span>';
		$linkArray[$link]['script'] = '/include/admin/Directories.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//KeywordSpaces
		$link = 'KeywordSpaces';
		$linkArray[$link]['header'] = 'dynamic_content';
		$linkArray[$link]['label'] = 'Keyword Spaces <span style="vertical-align:super;color:red;font-size:80%">(beta)</span>';
		$linkArray[$link]['script'] = '/include/admin/KeywordSpaces.php';
		$linkArray[$link]['img'] = '/imgs/icons/page_white_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		
		//
		// Database
		//
		
		//Database
		$link = 'Database';
		$linkArray[$link]['header'] = 'Database';
		$linkArray[$link]['label'] = 'database_info';
		$linkArray[$link]['script'] = '/include/admin/Db.php';
		$linkArray[$link]['img'] = '/imgs/icons/database_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//Backup
		$link = 'Backup';
		$linkArray[$link]['header'] = 'Database';
		$linkArray[$link]['label'] = 'Database Backup';
		$linkArray[$link]['script'] = '/include/admin/DbBackup.php';
		$linkArray[$link]['img'] = '/imgs/icons/database_gear.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//ScheduledTasks
		$link = 'ScheduledTasks';
		$linkArray[$link]['header'] = 'Database';
		$linkArray[$link]['display'] = 'scheduled_tasks';
		$linkArray[$link]['script'] = '/include/admin/ScheduledTasks.php';
		$linkArray[$link]['userlevel'] = '5';
		
		//Cache
		$link = 'Cache';
		$linkArray[$link]['header'] = 'Database';
		$linkArray[$link]['label'] = 'Cache';
		$linkArray[$link]['script'] = '/include/admin/Cache.php';
		$linkArray[$link]['userlevel'] = '5';
		$linkArray[$link]['img'] = '/imgs/icons/database_gear.gif';
		
		
		//
		// Software Content
		//
		
		$link = 'SoftwareContent';
		$linkArray[$link]['header'] = 'Software Content';
		$linkArray[$link]['display'] = 'software_content';
		$linkArray[$link]['userlevel'] = '5';
		
		//
		// Software
		//
		$link = 'software_version';
		$linkArray[$link]['header'] = 'Software';
		$linkArray[$link]['display'] = 'software_version';
		$linkArray[$link]['userlevel'] = '5';
		
		//CheckInstallation
		$link = 'CheckInstallation';
		$linkArray[$link]['header'] = 'Software';
		$linkArray[$link]['label'] = 'Check Installation';
		$linkArray[$link]['script'] = '/include/admin/checkInstallation.php';
		$linkArray[$link]['img'] = '/imgs/icons/tick.gif';
		$linkArray[$link]['userlevel'] = '5';
		
		//
		// Development
		//
		
		//ErrorLog
		$link = 'ErrorLog';
		$linkArray[$link]['header'] = 'Development';
		$linkArray[$link]['label'] = 'error_log';
		$linkArray[$link]['script'] = '/include/admin/Errors.php';
		$linkArray[$link]['img'] = '/imgs/icons/error.gif';
		$linkArray[$link]['userlevel'] = '5';
		$linkArray[$link]['visible'] = '0';
		$linkArray[$link]['enabled'] = '0';
		$linkArray[$link]['about'] = 'When possible, WikyBlog will save errors in the error log. If you\'re developing, the errorlog can be useful.';
		
		//RawDbInfo
		$link = 'RawDbInfo';
		$linkArray[$link]['header'] = 'Development';
		$linkArray[$link]['label'] = 'Data Info';
		$linkArray[$link]['script'] = '/include/admin/RawDbInfo.php';
		$linkArray[$link]['img'] = '/imgs/icons/error.gif';
		$linkArray[$link]['userlevel'] = '5';
		$linkArray[$link]['visible'] = '0';
		$linkArray[$link]['enabled'] = '0';
		$linkArray[$link]['about'] = 'The $dbInfo array is the organization hub of WikyBlog.';
		
		
		//
		//	Miscellaneous
		//
		//confighistory
		$link = 'ConfigHistory';
		$linkArray[$link]['header'] = 'Miscellaneous';
		$linkArray[$link]['label'] = 'Configuration History';
		$linkArray[$link]['script'] = '/include/admin/ConfigRev.php';
		$linkArray[$link]['img'] = '/imgs/icons/wrench.gif';
		$linkArray[$link]['userlevel'] = '5';
		$linkArray[$link]['visible'] = '0';
		$linkArray[$link]['about'] = '';
		
		return $linkArray;
	}
}

global $initiateFileClass;
if( $initiateFileClass ){
	new ConfigLinks();
}
			
