<?php
defined('WikyBlog') or die("Not an entry point...");

global $page,$pageOwner,$dbObject,$langA;
$page->regLink('Custom Data Types','/Admin/'.$pageOwner['username'].'/CreatePlugin');
$page->regLink('Manage Types','/Admin/'.$pageOwner['username'].'/ManageTypes');
$page->autoForm = true;
$page->regLink('?','Manage Types?en=Manage_Types');
$page->displayTitle = 'Manage Types';

if( !isAdmin() ){
	$page->contentA[$page->displayTitle] = 'You must be an administrator to access this page.';
	return;
}

includeFile('admin/PluginAdd.php');

class dataTypes extends pluginAdd{
	//var $standardTypes = array('page'=>1,'comment'=>1,'map'=>1,'template'=>1,'special'=>1,'admin'=>1,'talk'=>1);
	var $dropTable;
	var $scriptName = 'ManageTypes';
	
	function dataTypes(){
		global $page,$langA;
	
		ob_start();
		$show = true;
		switch( $page->userCmd ){
			
			case wbStrtolower($langA['all_users']):
				$this->cnDisable();
			break;
			
			case 'up':
				$this->createNewUp();
			break;
			
			case 'admin only':
			case 'disabled':
				$this->cnEnable();
			break;
			
			
			case 'remove':
				$show = false;
				if( !$this->removePlugin() ){
					return;
				}
			break;
			
			case 'confirm removal':
				$this->removeConfirm();
				$show = false;
			break;
			
			case wbStrtolower($langA['edit']):
				$show = false;
				$this->editRawCode($page->cmdArg[0]);
			break;
			case 'save changes':
				$this->saveRawCode();
			break;
			
		}
		
		if( $show ){
			//$this->showExisting();
			//echo '<hr/>';
			$this->showCreateNew();

		}
		
		$page->contentA['Manage Types'] = wb::get_clean();
	}
	
// 	function showExisting(){
// 		global $dbInfo,$wbConfig,$langA,$page;
// 		
// 		
// 		echo '<table class="tableRows" style="width:100%">';
// 		echo '<tr><th style="white-space:nowrap">'.$langA['existing_types'].'</th>';
// 		echo '<th style="white-space:nowrap">'.$langA['create_new'].'</th>';
// 		echo '<th >'.$langA['options'].'</th>';
// 		echo '</tr>';
// 		
// 		$i = 0;
// 		$classes[] = ' class="tableRowOdd" ';
// 		$classes[] = ' class="tableRowEven" ';

// 		ksort($dbInfo);
// 		foreach($dbInfo as $space => $info){
// 			if( !isset($info['dbTable']) ){
// 				continue;
// 			}
// 			
// 			echo '<tr'.$classes[($i%2)].'>';
// 			echo '<td>';
// 			if( isset($langA[$space])){
// 				echo $langA[$space];
// 			}else{
// 				echo $space; //shouldn't happen.. 
// 			}
// 			echo '</td><td>';
// 			
// 				if( isset($info['dbTable']) && (!isset($info['dTitle']) || ($space == 'page')) ){
// 					
// 					// 1 .. admin and user
// 					// 2 .. admin only
// 					
// 					if( isset($wbConfig['createNew'][$space]) ){
// 						if( $wbConfig['createNew'][$space] === 1 ){
// 							echo '<input type="submit" name="cmd['.$space.']" value="'.$langA['all_users'].'"  title="Disable" />';
// 						}else{
// 							echo '<input type="submit" name="cmd['.$space.']" value="Admin Only"  title="Set to All Users"/>';
// 						}
// 					}else{
// 						echo '<input type="submit" name="cmd['.$space.']" value="Disabled" title="Set to Admin Only" />';
// 					}
// 				}
// 			
// 			echo '</td>';
// 			echo '<td style="white-space:nowrap">';
// 				if( isset($this->standardTypes[$space]) ){
// 					echo ' &nbsp; ';
// 				}else{
// 					if( isset($dbInfo[$space]['dbPlugin']) ){
// 						echo wbLinks::admin('updateplugin?plugin='.$space,'update');
// 						echo '<input type="submit" name="cmd['.$space.']" value="'.$langA['edit'].'" />';
// 					}
// 					echo '<input type="submit" name="cmd['.$space.']" value="Remove" />';
// 				}
// 			echo '</td>';
// 			echo '</tr>';
// 			$i++;
// 		}
// 		echo '</table>';
// 		
// 		
// 		
// 	}
	
	function showCreateNew(){
		global $langA,$dbInfo,$wbConfig;
		
		$i = 0;
		
		echo '<table class="tableRows" style="width:100%">';
		echo '<tr><th style="white-space:nowrap">'.$langA['existing_types'].'</th>';
		echo '<th style="white-space:nowrap">'.$langA['create_new'].'</th>';
		echo '<th colspan="2">'.$langA['options'].'</th>';
		echo '</tr>';
		
		//spaces in createNew
		foreach($wbConfig['createNew'] as $space => $user){
			
			if( !isset($dbInfo[$space]) ){
				continue;
			}
			
			$this->createNewRow($space,$dbInfo[$space],$i);
			
			$i++;
		}
		
		//spaces available for createNew
		$others = array();
		foreach($dbInfo as $space => $info){
			if( !isset($info['dbTable']) ){
				continue;
			}
			if( isset($wbConfig['createNew'][$space]) ){
				continue;
			}
			if( isset($info['keys']) && ($space != 'page') ){
			//if( isset($info['dTitle']) && ($space != 'page') ){
				$others[$space] = $info;
				continue;
			}
			$this->createNewRow($space,$info,$i);
			
			$i++;
		}
		
		//spaces not available for createNew
		foreach($others as $space => $info){
			$this->createNewRow($space,$info,$i);
			$i++;
		}
		echo '</table>';
		
	}
	
	function createNewRow($space,$info,$i){
		global $wbConfig,$langA,$dbInfo;
		
		
		$classes[] = ' class="tableRowOdd" ';
		$classes[] = ' class="tableRowEven" ';
		$enabled = false;
		
		echo '<tr'.$classes[($i%2)].'>';
		echo '<td>';
		if( isset($langA[$space])){
			echo $langA[$space];
		}else{
			echo $space; //shouldn't happen..
		}
		echo '</td><td>';
		
		if( isset($info['dbTable']) && (!isset($info['keys']) || ($space == 'page')) ){
		//if( isset($info['dbTable']) && (!isset($info['dTitle']) || ($space == 'page')) ){
			
			// 1 .. admin and user
			// 2 .. admin only
			
			if( isset($wbConfig['createNew'][$space]) ){
				$enabled = true;
				if( $wbConfig['createNew'][$space] === 1 ){
					
					echo '<input style="width:9em" type="submit" name="cmd['.$space.']" value="'.$langA['all_users'].'"  title="Disable" />';
				}else{
					echo '<input style="width:9em" type="submit" name="cmd['.$space.']" value="Admin Only"  title="Set to All Users"/>';
				}
			}else{
				echo '<input style="width:9em" type="submit" name="cmd['.$space.']" value="Disabled" title="Set to Admin Only" />';
			}
		}else{
			echo '<input style="width:9em" type="submit" name="" value="Unavailable" title="Unavailable" />';
		}
		
		//move up
			
			if( !$enabled ){
			//if( !$enabled || ($i == 0) ){
				echo ' <img alt="" height="16" width="16" src="'.wbLinks::getDir('/imgs/blank.gif').'" /> ';
			}else{
				$label = ' <img alt="" height="16" width="16" src="'.wbLinks::getDir('/imgs/icons/arrow_up.gif').'" /> ';
				echo wbLinks::admin('ManageTypes?cmd['.urlencode($space).']=up',$label);
			}
			echo '</td>';
		
		//options
			echo '<td style="white-space:nowrap">';
				if( !isset($info['dbPlugin']) && !isset($info['isPlugin']) ){
						echo ' &nbsp; ';
						echo '</td>';
						echo '<td style="white-space:nowrap">';
						echo ' &nbsp; ';
				}else{
					if( isset($dbInfo[$space]['dbPlugin']) ){
						echo wbLinks::admin('updateplugin?plugin='.$space,'update');
						echo '<input type="submit" name="cmd['.$space.']" value="'.$langA['edit'].'" />';
					}
					echo '</td>';
					echo '<td style="white-space:nowrap">';
					echo '<input type="submit" name="cmd['.$space.']" value="Remove" />';
				}
			echo '</td>';		
		
		echo '</tr>';
	}
	
	function createNewUp(){
		global $wbConfig,$page;
		
		$which = $page->cmdArg[0];
		if( !isset($wbConfig['createNew'][$which]) ){
			return;
		}
		
		$i = 0;
		$foundAt = false;
		foreach($wbConfig['createNew'] as $space => $user){
			
			if( $space == $which){
				$foundAt = $i;
			}
			$i++;
		}
		if( !$foundAt || $foundAt < 1 ){
			return;
		}
		$whichUser = $wbConfig['createNew'][$which];
		unset($wbConfig['createNew'][$which]);
		
		$temp = array();
		
		$i = 0;
		foreach($wbConfig['createNew'] as $space => $user){
			if( $i == ($foundAt-1)){
				$temp[$which] = $whichUser;
			}
			$temp[$space] = $user;
			$i++;
		}
		$wbConfig['createNew'] = $temp;
		$this->cnSaveConfig($temp);
	}
}

new dataTypes();