<?php
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



defined('WikyBlog') or die("Not an entry point...");

global $rootDir,$page,$errorEmail,$pageOwner,$dbInfo,$dbObject;

if( !isAdmin() ){
	$page->contentA['Admin Only'] = 'You must be an administrator to access this page.';
	return;
}

$page->regLink('?','Admin?en=Admin');

$page->regLink('Error Log','/Admin/'.$pageOwner['username'].'/ErrorLog');
$file = $rootDir.'/userfiles/error.log';
$page->autoForm = true;

includeFile('tool/errorClass.php');


switch($page->userCmd){
	case 'delete log':
	case 'delete':
		deleteLog($file);
		getLog($file);
	break;
	
	default:
		checkSize($file);
		getLog($file);
	break;
}

function checkSize($file){
	global $maxErrorFileSize;
	if( !isset($maxErrorFileSize) || empty($maxErrorFileSize) ){
		$maxErrorFileSize = 100000;
	}
	
	$currSize = fileSize($file);
	if( $currSize > $maxErrorFileSize){
		message('ERROR_LOG_MAXED',$currSize);
	}
}

function getLog($file){
	global $page,$errorEmail,$wbWritable;
	ob_start();
	

	if( !empty($errorEmail) ){
		echo '<p>';
		echo 'Error Handling has been configured to send errors to the $errorEmail.<br/>';
		echo 'Messages will not be logged if errors are emailed successfully.<br/>';
		echo 'To have errors recorded in error.log, delete the value for "Error Email" in your configuration.';
		echo '</p>';
		
	}elseif( isset($wbWritable) || ($wbWritable === false) ){
		echo '<p>';
		echo 'Your system cannot erase the errorlog because PHP is in safe mode. To erase your error log, open the file /userfiles/error.log and erase all of the text.';
		echo '</p>';
		
	}else{
	
		echo ' <p style="text-align:right"> <input type="submit" name="cmd" value="Reload" >'; 
		echo ' <input type="submit" name="cmd" value="Delete Log" >';
		echo '</p><hr/>';
		ob_start();
		@include($file);
		$text = wb::get_clean();
		echo wbError::decode($text);
		echo '<hr/>';
	}
	$page->contentA['Error Log'] = wb::get_clean();
}

function deleteLog($file){
	if( !is_file($file) ){
		return;
	}
	
	wbData::loadFileFunctions();
	$empty = '';
	if( saveFile($file,$empty) ){
		message('ERROR_LOG_DELETED');
	}else{
		message('ERROR_LOG_NOT_DELETED');
	}
	return;
}