<?php
defined('WikyBlog') or die("Not an entry point...");

if( !isAdmin() ){
	message('You must be an administrator to access this page.');
	return;
}


includeFile('admin/DirectoryFunctions.php');

class keywordSpaces extends directoryFunctions{
	
	function keywordSpaces(){
		global $page,$dbInfo,$pageOwner,$dbObject;
		
		$contentUri = $page->regLink('Keyword Spaces','/Admin/'.$pageOwner['username'].'/KeywordSpaces');
		$page->regLink('Directories','/Admin/'.$pageOwner['username'].'/Directories');

		$page->regLink('?','Keyword Spaces?en=Keyword_Spaces');
		$page->autoForm = true;
		
		$this->setSpaces();
		$this->setCurrentSpaces('keySpace');
		$show = true;
		
		ob_start();
		echo '<br/>';
		
		switch($page->userCmd){
			case 'finish':
				if( !$this->finish() ){
					$this->create();
					$show = false;
				}
			break;
			case 'edit':
				if( $this->editVals($_GET['name'])  ){
					$show = false;
				}
			break;
			case 'remove':
				$this->removeDirCheck();
				$show = false;
			break;
			case 'confirm removal':
				$this->removeDir('keySpace');
			break;
			case 'update':
				if( !$this->update() ){
					$show = false;
				}
			break;

			
			case 'create':
				if( $this->create() ){
					$show = false;
				}
			break;
			
			case 'export':
				$this->exportAsPlugin($_GET['space']);
				$show = false;
			break;
			
			//these function are in PluginAdd.php
			case 'rawedit';
				$this->editRawCode($_GET['name']);
				$show = false;
			break;
			case 'save changes':
				$this->saveRawCode();
			break;

		}
		
		if( $show ){
			echo '<table>';
			$this->form();
			$this->showCurrent();
			echo '</table>';
		}
		
		$page->contentB[$contentUri] = wb::get_clean();
	}
	
	
	function create($new=true){
		global $dbInfo,$page,$pageOwner;
			$_POST += array(
							'keyword'=>'',
							'where'=>'',
							'limit'=>'20',
							);
		//
		//	Check
		//
			if( $new && !$this->checkDirName() ){
				return false;
			}
			$this->setVariables($_POST['space']);

			
			echo '<table>';
			echo '<tr>';
			echo '<td>';
			
			echo '<fieldset style="padding:1em;">';
			echo '<legend>Keyword Space: '.$_POST['name'].'</legend>';
			
			echo '<table cellpadding="7" border="0">';
			
		//
		//	Keyword
		//
			echo '<tr>';
				echo '<td colspan="2">';
				echo '<h4 class="heading">Keyword Value</h4>';
				echo '</td>';
				echo '</tr>';
				
			echo '<tr>';	
				echo '<td></td>';
				echo '<td style="white-space:nowrap">';
				echo '<input type="text" size="20" name="keyword" value="'.wbHtmlspecialchars($_POST['keyword']).'" />';
				if( isset($pageOwner['keywords']) && is_array($pageOwner['keywords']) ){
					echo ' &nbsp; <input type="image" alt="" onclick="this.form.keyword.value=this.form.keywords.value;return false;" height="16" width="16" src="'.wbLinks::getDir('/imgs/icons/arrow_left.gif').'" /> &nbsp; ';
					echo '<select name="keywords" onchange="this.form.keyword.value=this.form.keywords.value;">';
					foreach($pageOwner['keywords'] as $keyword => $num){
						echo '<option value="'.wbHtmlspecialchars($keyword).'" >'.$keyword.'</option>';
					}
					echo '</select>';
				}
				echo '</td>';
				echo '</tr>';
				
			echo '<tr>';
				echo '<td colspan="2">';
				echo '<h4 class="heading">Limit</h4>';
				echo '</td>';
				echo '</tr>';
				
			echo '<tr>';
				echo '<td></td>';
				echo '<td>';
				echo '<input name="limit" type="text" size="4" value="'.wbHtmlspecialchars($_POST['limit']).'" />';
				echo '</td>';
				echo '</tr>';
				
			
		//
		//	Where
		//
			echo '<tr>';
				echo '<td colspan="2">';
				echo '<h4 class="heading">Where</h4>';
				echo '</td>';
				echo '</tr>';
				
			echo '<tr>';	
				echo '<td></td>';
				echo '<td>';
				echo '<textarea name="where" rows="5" cols="30">';
				echo wbHtmlspecialchars($_POST['where']);
				echo '</textarea>';
				echo '</td>';
				echo '</tr>';
				
		//
		//	Order By
		//
			echo '<tr>';
				echo '<td colspan="2">';
				echo '<h4 class="heading">Order By</h4>';
				echo '</td>';
				echo '</tr>';
				
			$order2['ASC'] = 'Ascending';
			$order2['DESC'] = 'Descending';
			echo '<tr>';
			echo '<td style="white-space:nowrap;"> &nbsp; &nbsp; &nbsp; </td>';
			echo '<td style="width:25em">';
			echo '<table cellpadding="0" cellspacing="0">';
			$i = 0;
			foreach($this->variables as $null){
				echo '<tr>';
					echo '<td>';
					$this->selectVariables('order',$i);
					echo '</td>';
					echo '<td>';
					echo '<select name="order2[]">';
					foreach($order2 as $value => $disp){
						if( isset($_POST['order2'][$i]) && ($_POST['order2'][$i] == $value)){
							echo '<option value="'.$value.'" selected="selected">'.$disp.'</option>';		
						}else{
							echo '<option value="'.$value.'">'.$disp.'</option>';
						}
					}
					echo '</select>';
					echo '</td>';
					echo '</tr>';
					$i++;
			}
			echo '</table>';
			echo '</td>';
			echo '</tr>';
			
			
			echo '</table>';					
					
				
				
			echo '</fieldset>';
			echo '</td>';
			echo '</tr><tr>';
			echo '<td style="text-align:center;">';
			
				if( $new ){
					// echo '<input type="submit" name="cmd" value="Check" />';
					// echo ' &nbsp; ';
					echo '<input type="submit" name="cmd" value="Finish" />';
				}else{
					echo '<input type="submit" name="cmd" value="Update" />';
				}
				echo ' &nbsp; <input type="submit" name="cmd" value="Start Over" />';
				echo '<input type="hidden" name="name" value="'.wbHtmlspecialchars($_POST['name']).'" />';
				echo '<input type="hidden" name="space" value="'.wbHtmlspecialchars($_POST['space']).'" />';
				
			echo '</td></tr>';
			
			
			echo '</table>';
		return true;			
	}
	
	function check(){
		if( !empty($_POST['limit']) && !is_numeric($_POST['limit'])){
			message('Limit was not a numeric value');
			return false;
		}
		
		if( empty($_POST['keyword']) ){
			message('You must provide a keyword value.');
			return false;	
		}
		if( !$this->checkWhere() ){
			return false;
		}
		
		return true;
	}
		
	function createClass(){
		$_POST += array('limit'=>'20','where'=>'');
		$this->setVariables($_POST['space']);
		
		//
		//	Start Class
		//
			$tab = "\t";
			$class = array();
			$class[] = '////////////////////////////////////////////////////////////';
			$class[] = '//';
			$class[] = '//		WikyBlog Generated Code';
			$class[] = '//		Edit with care';
			$class[] = '//';
			$class[] = '////////////////////////////////////////////////////////////';
			$class[] = '';
			$class[] = '';
			$class[] = 'includeFile(\'search/searchKeywordPage.php\');';
			$class[] = '';
			$class[] = 'class '.$this->className.' extends searchKeywordPage{';
			$class[] = '';
			
			$class[] = $tab.'function '.$this->className.'($name){';
			$class[] = $tab.$tab.'global $wbTablePrefix;';
			$class[] = '';
			$class[] = $tab.$tab.'$this->config[\'keyword\'] = '.$this->escape($_POST['keyword']).'; ';
			
			$class[] = $tab.$tab.'$this->config[\'where\'] = '.$this->escape($_POST['where']).'; ';
			$class[] = $tab.$tab.'$this->config[\'limit\'] = '.$this->escape($_POST['limit']).';';

		
			$orderBy = $this->createClassOrderBy();
			if( $orderBy ){
				$class[] = $tab.$tab.'$this->config[\'order\'] = '.$orderBy.'; ';
			}
			
			$class[] = '';
			$class[] = $tab.$tab.'$this->searchKeywordPage($name);';
			$class[] = $tab.'}';
			$class[] = '}';
			
		return implode("\n",$class);
	}
	
	
	function newDbInfo(){
		$name = wbStrtolower($_POST['name']);
		$newInfo= array();
		$displayName = toDisplay($_POST['name']);
		if( $name !== $displayName){
			$newInfo['alias'] = $displayName;
		}
		$newInfo['keySpace'] = $_POST['space'];
		$newInfo['class'] = $this->className;
		$newInfo['dbPlugin'] = true;
		
		//!! version 1.5.7 used this, but we'll just use keySpace from V1.5.8 on out
		$newInfo['useInfo'] = $_POST['space'];
		
		return $newInfo;
	}

	
	function showCurrent(){
		global $dbInfo,$langA;
		
		if( count($this->currentSpaces) < 1 ){
			return;
		}
		
		echo '<tr>';
		echo '<td>';
		echo '<fieldset style="padding:1em;">';
		echo '<legend>Current Keyword Spaces</legend>';

		echo '<table class="tableRows sortable"">';
			
		echo '<tr>';
			echo '<th>';
				echo 'Name';
				echo '</th>';
			echo '<th>';
				echo 'Built On Data Type';
				echo '</th>';
			echo '<th class="unsortable">';
				echo 'Options';
				echo '</th>';
			echo '</tr>';
		
		$i = 0;
		$classes[] = ' class="tableRowEven" ';
		$classes[] = ' class="tableRowOdd" ';
		foreach($this->currentSpaces as $nameSpace => $useInfo){
			$i++;
			echo '<tr'.$classes[($i%2)].'>';

			
				echo '<td>';
				$temp = $nameSpace;
				if( isset($langA[$nameSpace]) ){
					$temp = $langA[$nameSpace];
				}
				echo wbLinks::local('/'.$nameSpace,$temp);
				echo '</td>';
				
				echo '<td>';
				echo $useInfo;
				echo '</td>';
				
				echo '<td>';
				echo wbLinks::admin('KeywordSpaces?cmd=edit&name='.$nameSpace,'edit');
				echo ' &nbsp; &nbsp; ';
				echo wbLinks::admin('KeywordSpaces?cmd=rawedit&name='.$dbInfo[$nameSpace]['class'],'Raw Edit');
				echo ' &nbsp; &nbsp; ';
				if( function_exists('var_export') ){
					echo wbLinks::admin('KeywordSpaces?cmd=export&space='.$nameSpace,'Export');
					echo ' &nbsp; &nbsp; ';
				}
				echo wbLinks::admin('KeywordSpaces?cmd=remove&name='.$nameSpace,'Remove');
				echo '</td>';
				echo '</tr>';
		}
		echo '</table>';
		echo '</fieldset>';
		echo '</td>';
		echo '</tr>';
	}
	function form(){
		global $langA;
		$_POST += array('name'=>'','keyword'=>'');
		
		echo '<tr>';
		echo '<td>';
		echo '<fieldset style="padding:1em;">';
		echo '<legend>Create New Keyword Space</legend>';
		
		echo '<table>';
		echo '<tr>';
			echo '<td>';
			echo 'Name: ';
			echo '</td>';
			echo '<td>';
			echo '<input type="text" size="20" name="name" value="'.wbHtmlspecialchars($_POST['name']).'" />';
			echo '</td>';
			echo '</tr>';
			
		echo '<tr>';
			echo '<td>';
			echo 'Over Space: ';
			echo '</td>';
			echo '<td>';
			echo '<select name="space">';
			foreach($this->spaces as $space => $null){
				echo '<option value="'.$space.'">'.$langA[$space].'</option>';
			}
			echo '</select>';
			echo '</td>';
			echo '</tr>';
			
		echo '<tr>';
			echo '<td>';
			echo '</td>';
			echo '<td>';
			echo '<input type="submit" name="cmd" value="Create" />';
			echo '</td>';
			echo '</tr>';
		echo '</table>';
		
		echo '</fieldset>';
		echo '</td>';
		echo '</tr>';
	}	

	

	
	
}
new keywordSpaces();
