<?php

defined('WikyBlog') or die("Not an entry point...");

if( !isAdmin() ){
	global $page;
	$page->contentA['Admin Only'] = 'You must be an administrator to access this page.';
	return;
}

//
//	$array['serverName3'] .= $configData['wbDirPrefix'];
//


includeFile('admin/PluginAdd.php');

class enableMaps extends pluginAdd{
	function enableMaps(){
		global $page,$dbObject,$pageOwner,$serverName3,$googleMapKeys,$langA;
		$contentUri = $page->regLink($langA['googleMapKeys'],'/Admin/'.$pageOwner['username'].'/EnableMaps');
		$page->autoForm = true;
		
		
		ob_start();
		$show = true;
		switch($page->userCmd){
			case 'delete':
				$this->delete();
			break;
			
			case 'save':
				if( $this->save() ){
					break;
				}
			case 'new':
				$this->newKey();
				$show = false;
			break;
		}
		
		if( $show ){
			$this->show();
		}
		$page->contentB[$contentUri] = wb::get_clean();
		
	}
	
	function newKey(){
		global $googleMapKeys;
		
		$_GET += array('url'=>'http://  .  .  .  .  /');
		$_POST += array('url'=>$_GET['url'],'key'=>'');
		
		//for editing
		if( isset($googleMapKeys[$_POST['url']]) && empty($_POST['key']) ){
			$_POST['key'] = $googleMapKeys[$_POST['url']];
		}
		
		
		echo '<table style="margin:1em auto 1em auto">';
		echo '<tr><td style="text-align:center">';
		
		echo '<table class="WBeditArea1" cellspacing="9">';

			echo '<tr>';
				echo '<td style="white-space:nowrap">';
				echo '<b>1) Enter URL</b>';
				echo '</td>';
				echo '<td>';
				echo '<input type="text" size="40" name="url" value="'.wbHtmlspecialchars($_POST['url']).'" />';
				echo '</td>';
				echo '<td class="sm">';
				echo 'The domain of your site. See google\'s <a href="http://code.google.com/apis/maps/faq.html#keysystem" target="_blank">FAQ</a>';
				echo '</td>';
				echo '</tr>';
			echo '<tr>';
				echo '<td style="white-space:nowrap">';
				echo '<b>2) Get Key</b>';
				echo '</td>';
				echo '<td>';
				echo '<a target="_blank" href="http://www.google.com/apis/maps/signup.html">Google.com</a>';
				echo '</td>';
				echo '</tr>';

				
			echo '<tr>';
				echo '<td style="white-space:nowrap">';
				echo '<b>3) Enter API KEY</b>';
				echo '</td>';
				echo '<td>';
				echo '<input type="text" size="40" name="key" value="'.wbHtmlspecialchars($_POST['key']).'" />';
				echo '</td>';
			echo '</tr>';
		echo '</table>';
		
		echo '<input type="submit" name="cmd" value="Save" />';
		echo ' <input type="submit" name="cmd" value="Cancel" />';
		
		echo '</td></tr>';
		echo '</table>';
				
							
	}
	
	function show(){
		global $serverName3,$googleMapKeys,$langA,$wbAdminUser;
		
		if( isset($_SERVER['HTTP_HOST']) ){
			$url = $_SERVER['HTTP_HOST'];
		}else{
			$url = $_SERVER['SERVER_NAME'];
		}
		$url = 'http://'.$url;
		if( !isset($googleMapKeys[$url]) ){
			$googleMapKeys[$url] = false;
		}
		
		$temp = parse_url($url);
		if( strpos($temp['host'],'www.') === false ){
			$temp['host'] = 'www.'.$temp['host'];
		}else{
			$temp['host'] = str_replace('www.','',$temp['host']);
		}
		$url = $temp['scheme'].'://'.$temp['host'];
		if( !isset($googleMapKeys[$url]) ){
			$googleMapKeys[$url] = false;
		}
		
		
		echo '<p>';
		echo 'To enable the maps data type for your installation, you must first <a target="_blank" href="http://www.google.com/apis/maps/signup.html">sign up</a> for an API Key directly from Google.';
		echo ' Once you have enabled maps, you can modify your "Create New .." menus via '.wbLinks::admin('ManageTypes','Data Type Management').'.';
		echo '</p>';
		
		echo '<table class="tableRows" cellpadding="7" style="width:100%">';
		echo '<tr>';
			echo '<th>';
			echo 'URL';
			echo '</th>';
			echo '<th>';
			echo 'API Key';
			echo '</th>';
			echo '<th>';
			echo 'Options';
			echo '</th>';
			echo '</tr>';
			
		$classes[] = 'class="tableRowEven" ';
		$classes[] = 'class="tableRowOdd" ';
		$i = 0;
		foreach($googleMapKeys as $url => $apiKey){
			
			echo '<tr '.$classes[($i%2)].'>';
				echo '<td style="white-space:nowrap">';
				echo '<tt>';
				echo $url;
				echo '</tt>';
				echo '</td>';
				if( empty($apiKey) ){
					echo '<td>';
					echo wbLinks::admin('EnableMaps?cmd=new&url='.urlencode($url),'empty');
					echo '</td>';
					echo '<td>';
					echo wbLinks::admin('EnableMaps?cmd=new&url='.urlencode($url),'Add This Key');
					echo '</td>';
				}else{
					echo '<td class="sm">';
					echo substr($apiKey,0,30).' ... ';
					echo '</td>';
					echo '<td>';
					echo wbLinks::admin('EnableMaps?cmd=new&url='.urlencode($url),'edit');
					echo ' &nbsp; ';
					echo '<a href="'.dirname($url).'?wbRedir=true&root=/Map/'.$wbAdminUser.'/Test_Maps" target="_blank">Test</a>';
					echo ' &nbsp; ';
					echo wbLinks::admin('EnableMaps?cmd=delete&url='.urlencode($url),'delete');
					echo '</td>';
				}
				echo '</tr>';
				$i++;			
		}
		
		echo '<tr>';
			echo '<td style="white-space:nowrap;text-align:center">';
			echo wbLinks::admin('EnableMaps?cmd=new','Add Another URL');
			echo '</td>';
			echo '<td>';
			echo '</td>';
			echo '<td>';
			echo '</td>';
			echo '</tr>';
			
		echo '</table>';
		
	}

	
	function save(){
		global $dbObject,$dbInfo,$page,$googleMapKeys;
		
		if( empty($_POST['key']) ){
			message('Your map key cannot be empty.');
			return false;
		}
		
		//check url
		if( empty($_POST['url']) ){
			message('The URL cannot be empty.');
			return false;
		}
		$urlArray = parse_url($_POST['url']);
		if( empty($urlArray['scheme']) ){
			message('Invalid URL');
			return false;
		}
		if( empty($urlArray['host']) ){
			message('Invalid URL');
			return false;
		}
		if( !empty($urlArray['user']) || !empty($urlArray['pass']) || !empty($urlArray['query']) || !empty($urlArray['fragment']) ){
			message('Invalid URL');
			return false;
		}
		
		//save the information
		//$url = wbStrtolower($_POST['url']);
		$url = $_POST['url'];
		$data = $dbObject->getConfiguration();
		$data['googleMapKeys'][$url] = $_POST['key'];
		$googleMapKeys[$url] = $_POST['key'];
		if( !$dbObject->updateConfig($data) ){
			return false;
		}
		$this->cnEnable('map');
		$page->session = true; //send a new userMenu
		
		message('<strong>Remember:</strong> Test your key to make sure it is correct.');
		
		return true;
	}
	
	function delete(){
		global $dbObject,$dbInfo,$page,$googleMapKeys;
		$data = $dbObject->getConfiguration();
		
		$url = $_GET['url'];
		
		if( !isset($data['googleMapKeys']) || !isset($data['googleMapKeys'][$url]) ){
			message('INVALID_REQUEST');
			return;
		}
		
		unset($data['googleMapKeys'][$url]);
		unset($googleMapKeys[$url]);
		if( $dbObject->updateConfig($data) ){
			$this->cnDisable('map');
			$page->session = true; //send a new userMenu
		}
	}
	
}
new enableMaps();