<?php
defined('WikyBlog') or die("Not an entry point...");

if( !isAdmin() ){
	global $page;
	$page->contentA['Admin Only'] = 'You must be an administrator to access this page.';
	return;
}


class pluginAdd{
	var $classNames = false;

	////////////////////////////////////////////////////////////////////////////////////////
	//
	//		Exporting
	//
	function exportHeader($sql=true){
		global $rootDir;
		echo '<p>';
		echo 'The following textareas contain the generated code for your plugin.';
		echo '</p>';
		
		$files = array('class.php','config.php');
		if( $sql ){
			$files[] = 'sql.php';
		}
		
		echo '<h2>Manual Installation</h2>';
		echo '<ol>';
			echo '<li>Create a directory <tt>'.$rootDir.'/plugins/&lt;YourPluginName&gt;.</tt></li>';
			echo '<li>In this directory create these files: <tt>';
				echo implode(', ',$files);
				echo '.</tt>  </li>';
			echo '<li>Cut and paste the code in the following textareas into the corresponding files.  </li>';
			echo '<li>Go to '.wbLinks::admin('Plugins','Manage Plugins').' install your new plugin.</li>';
		echo '</ol>';

		echo '<h2>Plugin Code</h2>';
			
		
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////
	//
	//		Checking		
	//
	function checkName($checkName,$warn=true){
		global $wbTables,$dbInfo;
		
		$failed = false;
		$alphaNum = '^[A-Za-z0-9_]+$';
		$lowerName = wbStrtolower($checkName);

		
		$query = 'SELECT 1 FROM '.$wbTables['users'].' WHERE `username` = "'.wbDB::escape($checkName).'" LIMIT 1';
		$result = wbDB::runQuery($query);
		$num = mysql_num_rows($result);
		
		if( $num == 1){
			$failed = 'A user of that name already exists.';
			
		}elseif(!eregi($alphaNum,$checkName)){
			$failed = 'Name must only contain alphanumeric and underscore characters.';
			
		}elseif( isset($dbInfo[$lowerName])){
			$failed = ' A data type of that name already exists: '.$lowerName;
			
		}elseif( !ctype_alnum($checkName{0}) ){
			$failed = 'The name must begin with an alphanumeric character. (3)';
			
		}elseif( strlen($checkName) > 20 ){
			$failed = 'The name must be less than 20 characters long.';
		}
		
		
		if( $failed !== false ){
			if( $warn ){
				message('Please select a different name. '.$failed);
			}
			return false;
		}
		return true;
	}
	
	////////////////////////////////////////////////////////////////////////////////////////
	//
	//		Class Name
	//
	
	function getClassName($arg){
		
		//get alphaNumeric only
		$arg = str_replace(' ','_',$arg);
		$acceptableChars = array('_','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
		$name = '';
		while(strlen($arg) > 0){
			$char = substr($arg,0,1);
			$arg = substr($arg,1);
			if( in_array($char,$acceptableChars) ){
				$name .= $char;
			}
		}
		
		//trim chars off begining till we get an alphabetic character
		while( (strlen($name) > 0) && !ctype_alpha($name{0}) ){
			$name = substr($name,1);
		}
		$name = trim($name);
		if( $name == '' ){
			$name = 'random';
		}
		
		$int = 1;
		$origName = $name;
		while( !$this->checkClassName($name) ){
			$name = $origName.$int;
			$int++;
			if( $int > 50){
				message('Get Name Failed ');
				return false;
			}
			
		}
		
		return $name;
	}
	
	function setClassNames(){
		global $dbInfo;
		if( is_array($this->classNames) ){
			return;
		}
		foreach($dbInfo as $space => $info){
			if( isset($info['class']) ){
				$this->classNames[] = strtolower($info['class']);
			}
		}
		return;
	}
	
	function checkClassName($className){
		$lowerName = wbStrtolower($className);
		$this->setClassNames(); //these are lowercased
		
		if( class_exists($className) ){
			return false;
		}
		
		if( class_exists($lowerName) ){
			return false;
		}
		
		if( in_array($lowerName,$this->classNames) ){
			return false;
		}
		return true;
	}
	
	
	
	////////////////////////////////////////////////////////////////////////////////////////
	//
	//		addPlugin
	//
	
	
	//adds the plugin with supplied information
	//	- updates database
	//	- add admin links
	//	- updates configuration
	//
	function addPlugin($nameSpace,&$sql,&$config){
		global $wbTablePrefix,$wbTables,$dbObject,$rootDir,$dbInfo;
		$lowerName = wbStrtolower($nameSpace);
		
		
		//
		//	Create Tables
		//
			
			if( $sql ){
				includeFile('installDB.php');
				$alterDb = new dbAlter();
				$sqlA = unserialize($sql);
				if( !$alterDb->go($wbTablePrefix,$sqlA) ){
					message('Database update failed.');
					return false;
				}
				
				//add data to ad_objects
				$tables = array_keys($sqlA);
				$query = 'REPLACE INTO '.$wbTables['ad_objects'];
				$query .= ' SET ';
				$query .= ' `selector` = "installTables:'.wbDB::escape($nameSpace).'" ';
				$query .= ' , `data` = "'.wbDB::escape(serialize($tables)).'" ';
				wbDB::runQuery($query);
			}
			
			
		//
		//	Update Configuration
		//
			$displayName = toDisplay($nameSpace);
			$data = $dbObject->getConfiguration();
			if( $lowerName != $displayName){
				$config['alias'] = $displayName;
			}
			$data['dbInfo'][wbStrtolower($lowerName)] = $config;
			if( !$dbObject->updateConfig($data) ){
				return false;
			}
			
			$dbInfo[wbStrtolower($lowerName)] = $config; //update the current dbInfo
			
		return true;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// 		Thes functions work with addPlugin to add the links for plugin admin
	//
	
	function addPluginLinks($plugDir,$lowerName){
		global $rootDir,$wbTables,$dbObject, $wbNow;
		includeFile('admin/ConfigLinks.php',false);
		
		// Get New Configuration file
		$linkFile = $rootDir.'/plugins/'.$plugDir.'/links.php';
		if( !is_file($linkFile) ){
			return;
		}
		require($linkFile);
		
		$pluginLinks = array();
		
		//
		// admin links
		//
		if( isset($adminLinks) && is_array($adminLinks) ){
			foreach($adminLinks as $link => $info ){
				if( !isset($info['script'] ) ){
					return;
				}
				$this->cleanPluginLinks($link,$info,$lowerName,$plugDir);
				$info['userlevel'] = 5;
				$pluginLinks[$link] = $info;
			}
		}
		
		//
		// special links
		//
		if( isset($specialLinks) && is_array($specialLinks) ){
			foreach($specialLinks as $link => $info ){
				if( !isset($info['script'] ) ){
					return;
				}
				$this->cleanPluginLinks($link,$info,$lowerName,$plugDir);
				$pluginLinks[$link] = $info;
			}
		}
		
		//
		//	ConfigLinks
		//	
		if( count($pluginLinks) > 0 ){
			ConfigLinks::addLinks($pluginLinks,true);
		}
		$this->rmSpecialLinks($lowerName); //only removes links that weren't updated

		
		//remove existing data
		$this->rmPluginConfig($plugDir,$lowerName,false);
		
		
		
		//
		//	maintenance file
		//
		if( isset($maintenance) ){
			$file = $rootDir.'/plugins/'.$plugDir.'/'.$maintenance;
			
			if( is_file($file) ){
				$query = 'REPLACE INTO '.$wbTables['ad_objects'];
				$query .= ' SET ';
				$query .= ' `selector` = "maintenance:'.wbDB::escape($plugDir).'" ';
				$query .= ' , `data` = "'.wbDB::escape($maintenance).'" ';
				wbDB::runQuery($query);
			}
		}
		
		//
		//	adminlang
		//
		if( isset($langFile) ){
			$file = $rootDir.'/plugins/'.$plugDir.'/include/lang/en/'.$langFile;
			if( is_file($file) ){
				$query = 'REPLACE INTO '.$wbTables['ad_objects'];
				$query .= ' SET ';
				$query .= ' `selector` = "adminLang:'.wbDB::escape($plugDir).'" ';
				$query .= ' , `data` = "'.wbDB::escape($langFile).'" ';
				wbDB::runQuery($query);
			}
		}

		
		
		
		//
		//	Powered By
		//
		if( isset($poweredBy) ){
			$config = $dbObject->getConfiguration();
			if( !isset($config['wbConfig']['poweredBy']) ){
				$config['wbConfig']['poweredBy'] = array();
			}
			$config['wbConfig']['poweredBy'][$plugDir] = $poweredBy;
			
			$dbObject->updateConfig($config);
		}
		
		return;
	}
	
	function cleanPluginLinks(&$link,&$info,$lowerName,$plugDir){
		
		
		//deprecated
		if( !isset($info['visible']) && isset($info['hide']) && ($info['hide'] == true) ){
			$info['visible'] = 0;
		}
		
		$info += array(	'img'=>''
					,'userlevel'=>-1
					,'label'=>$link
					,'display'=>''
					,'visible'=>1
					,'header'=>$lowerName
					);
					
		if( isset($info['spacePrefix']) && ($info['spacePrefix'] === false) ){
			$link = $link;
		}else{
			$link = $lowerName.'/'.$link;
		}
		
		if( empty($info['img']) && isset($info['p_img']) ){
			$info['img'] = '/plugins/'.$plugDir.'/'.$info['p_img'];
			unset($info['p_img']);
		}
		
		$info['script'] = '/plugins/'.$plugDir.'/'.$info['script'];
		$info['script'] = str_replace('//','/',$info['script']);
		$info['plugin_space'] = $lowerName;
		$info['plugin_dir'] = $plugDir;
		
	}
	
	
	function rmPluginConfig($plugDir,$lowerName,$all=true){
		global $wbTables,$dbObject;
		
		
		//
		//	Delete maintenance:$plugDir
		//
		$query = 'DELETE FROM '.$wbTables['ad_objects'];
		$query .= ' WHERE  ';
		$query .= ' `selector` = "maintenance:'.wbDB::escape($plugDir).'" ';
		$query .= ' LIMIT 1';
		wbDB::runQuery($query);
		
		//
		//	Delete adminLang:$plugDir
		//
		$query = 'DELETE FROM '.$wbTables['ad_objects'];
		$query .= ' WHERE  ';
		$query .= ' `selector` = "adminLang:'.wbDB::escape($plugDir).'" ';
		$query .= ' LIMIT 1';
		wbDB::runQuery($query);

		
		
		//
		//	poweredBy
		//
		$config = $dbObject->getConfiguration();
		if( isset($config['wbConfig']['poweredBy']) ){
			if( isset($config['wbConfig']['poweredBy'][$plugDir]) ){
				unset($config['wbConfig']['poweredBy'][$plugDir]);
				$dbObject->updateConfig($config);
			}
		}
	}
	
	//Will only remove the special links that weren't updated
	function rmSpecialLinks($lowerName){
		global $wbTables,$wbNow;
		includeFile('admin/ConfigLinks.php',false);
		
		
		//
		//	Check for links that weren't updated.. hence non existent
		//
		$query = 'SELECT 1 FROM '.$wbTables['config_links'];
		$query .= ' WHERE  ';
		$query .= ' `plugin_space` = "'.wbDB::escape($lowerName).'" ';
		$query .= ' AND `modified` != "'.wbDB::escape($wbNow).'" ';
		$query .= ' LIMIT 1 OFFSET 0';
		$result = wbDB::runQuery($query);
		$removedLinks = mysql_num_rows($result);
				
		//add back any overwritten links.. links will have lost their order/placement
		if( $removedLinks > 0 ){
			ConfigLinks::setDefaults($lowerName);
		}
	}
	
		
	///////////////////////////////////////////////////////////////////////////
	//
	//	ad_object
	//
	function ad_object($selector,&$data){
		global $wbTables,$wbNow;
		
		$query = 'REPLACE INTO '.$wbTables['ad_objects'].' SET';
		$query .= ' `selector` = "'.wbDB::escape($selector).'" ';
		$query .= ' ,`data` = "'.wbDB::escape($data).'" ';
		$query .= ' ,`created` = "'.$wbNow.'" ';
		if( wbDB::runQuery($query) ){
			return true;
		}
		return false;
	}
	function removeObject($selector){
		global $wbTables;
		$query = 'DELETE FROM '.$wbTables['ad_objects'];
		$query .= ' WHERE ';
		$query .= ' `selector` = "'.wbDB::escape($selector).'" ';
		$query .= ' LIMIT 1';
		if( wbDB::runQuery($query) ){
			return true;
		}
		return false;
	}
	
	///////////////////////////////////////////////////////////////////////////
	//
	//	These functions are used to edit raw php stored in ad_objects
	//
	function editRawCode($name){
		global $wbTables;
		
		$query = 'SELECT `data` FROM '.$wbTables['ad_objects'].' WHERE `selector` = "class:'. wbDB::escape($name) .'" LIMIT 1;';
		$result = wbDB::runQuery($query);
		$row = mysql_fetch_assoc($result);
		if( !$row ){
			message('Invalid database entry.');
			return;
		}
		
		message('<strong>Warning:</strong> Be very careful when editing the following php code.');
		echo '<input type="hidden" name="name" value="'.$name.'" />';
		echo '<textarea name="code" style="width:100%" wrap="soft" rows="'.$_SESSION['textareaY'].'">';
		echo wbHtmlspecialchars($row['data']);
		
		echo '</textarea>';
		echo '<input type="submit" name="cmd" value="Save Changes" />';
		echo ' &nbsp; <input type="submit" name="cmd" value="Cancel" />';
	}
	
	function saveRawCode(){
		global $wbTables, $wbDisableFeatures;
		
		if( isset($wbDisableFeatures) && $wbDisableFeatures ){
			message('<b>Sorry, this feature was disabled.');
			return false;
		}
		
		$testCode = $_POST['code'].'$TEST="hello";';
		eval($testCode);
		if( $TEST !== "hello"){
			message('<strong>Warning:</strong> Your PHP code did not evaluate.');
			return;
		}
		
		$query = 'UPDATE '.$wbTables['ad_objects'].' SET ';
		$query .= ' `data` = "'.wbDB::escape($_POST['code']).'" ';
		$query .= ' WHERE `selector` = "class:'. wbDB::escape($_POST['name']) .'" LIMIT 1;';
		if( wbDB::runQuery($query) ){
			message('Your php code was updated.');
		}else{
			message('<strong>Warning:</strong> There was an error updating your php code.');
		}
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//	Create New Enable/Disable
	//
	function cnEnable($space=false){
		global $dbInfo,$wbConfig,$page;
		
		if( $space === false ){
			$space = $page->cmdArg[0];
		}
		
		if( isset($dbInfo[$space]) && isset($dbInfo[$space]['dbTable'])){
			
			if( isset($wbConfig['createNew'][$space]) ){
				$wbConfig['createNew'][$space] = 1; //all users
			}else{
				$wbConfig['createNew'][$space] = 2; //admin only
			}
			$this->cnSaveConfig($wbConfig['createNew']);
			return;
		}
	}

	function cnDisable($space=false){
		global $dbInfo,$wbConfig,$page;
		
		if( $space === false){
			$space = $page->cmdArg[0];
		}
		
		if( isset($wbConfig['createNew'][$space]) ){
			unset($wbConfig['createNew'][$space]);
			$this->cnSaveConfig($wbConfig['createNew']);
			return;
		}
	}
	
	//This should just update the create new config..
	function cnSaveConfig($arg=array()){
		global $wbTables,$dbObject,$page;
		
		$data = $dbObject->getConfiguration();
		$data['wbConfig']['createNew'] = $arg;
		
		if( $dbObject->updateConfig($data) ){
			$page->session = true; //send a new userMenu
			message('Your configuration has been updated.');
		}
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//	Plugin Removal
	//
	
	function removePluginInit(){
		global $dbInfo,$page;
		
		if( !isset($dbInfo[$page->cmdArg[0]]) ){
			message('Invalid plugin: '.$page->cmdArg[0]);
			return false;
		}
		return true;
	}
	
	function removePlugin(){
		global $page,$dbInfo;
		$page->css2 = true;
		
		if( !$this->removePluginInit() ){
			return false;
		}
		
		echo '<table style="margin:2em auto 0 auto;">';
		echo '<tr><td style="text-align:center">';
		
		echo '<table cellpadding="10" class="WBeditArea1">';
		echo '<tr><td>';
		
		echo '<p>';
		echo 'Please confirm the removal of '.$page->cmdArg[0].'.';
		echo '</p>';
		
		if( $this->getTables($page->cmdArg[0]) ){
		
			echo '<p><b>Notice:</b> ';
			echo 'Removing will delete database entries<br/> and optionally remove tables. Backup your<br/> data before continuing if you want to save it.';
			echo '</p>';
			
			$drop = false;
			if( $this->dropEnabled() ){
				$drop = true;
			}
			
			echo '<table border="0" >';
			echo '<tr><th>';
			echo '<b>Table Options</b>';
			echo '</th></tr><tr><td>';
			echo '<label><input type="radio" name="tables" value="" /> Keep tables and data</label>';
			echo '</td></tr><tr><td>';
			echo '<label><input type="radio" name="tables" value="empty" ';
				if( !$drop ){
					echo 'checked="checked" ';
				}
				echo '/> Keep tables but delete data</label>';
			
			if( $this->dropEnabled() ){
				echo '</td></tr><tr><td>';
				echo '<label><input type="radio" name="tables" value="drop" checked="checked" /> Drop Tables</label>';
			}
			echo '</td></tr></table>';
			echo '<br/>';
		}
		
		echo '</td></tr>';
		echo '</table>';

		
		echo '<p>';
		echo '<input type="submit" name="cmd['.$page->cmdArg[0].']" value="Confirm Removal" /> ';
		echo ' &nbsp; &nbsp; <input type="submit" name="cmd" value="Cancel" />';
		echo '</p>';
		
		echo '</td></tr>';
		echo '</table>';
		
		return true;
	}

	
	function removeConfirm(){
		global $page,$dbInfo,$wbTables,$dbObject;
		$page->css2 = true;
		
		if( !$this->removePluginInit() ){
			return false;
		}
		
		echo '<table style="margin: 1em auto 1em auto;" class="WBeditArea1">';
		echo '<tr><td style="text-align:center">';
		
		$this->cnDisable();
		$rmSpace = $page->cmdArg[0];
		
		//remove object from ad_objects
		if( isset($dbInfo[$rmSpace]['dbPlugin']) ){
			$this->removeObject('class:'.$dbInfo[$rmSpace]['class']);
		}
		
		//remove admin link info
		if( isset($dbInfo[$rmSpace]['isPlugin']) ){
			$this->rmPluginConfig($dbInfo[$rmSpace]['isPlugin'],$rmSpace);
			$this->rmSpecialLinks($rmSpace);
		}
		
		
		//delete from dbTables..
		if( isset($dbInfo[$page->cmdArg[0]]['dbTable'] ) ){
			//get rid of entries in all_files, all_search, all_history
			$table = $dbInfo[$page->cmdArg[0]]['dbTable'];
			
			//keyword_count
			$query = 'UPDATE '.$wbTables['users'].', '.$wbTables['all_files'].', '.$table;
			$query .= ' SET '.$wbTables['users'].'.`keyword_count` = "reset" ';
			$query .= ' ,'.$wbTables['users'].'.`modified` = '.$wbTables['users'].'.`modified` ';
			$query .= ' WHERE '.$wbTables['all_files'].'.`file_id` = '.$table.'.`file_id` ';
			$query .= ' AND '.$wbTables['all_files'].'.`owner_id` = '.$wbTables['users'].'.`user_id` ';
			$query .= ' AND ('.$wbTables['all_files'].'.`keywords` IS NOT NULL OR '.$wbTables['all_files'].'.`keywords` = "") ';
			wbDB::runQuery($query);
			
			
			//Delete from all_search
			$query = 'DELETE '.$wbTables['all_search'];
			$query .= ' FROM '.$wbTables['all_search'].', '.$table;
			$query .= ' WHERE '.$wbTables['all_search'].'.`file_id` = '.$table.'.`file_id` ';
			wbDB::runQuery($query);
			
			//Delete from all_history
			$query = 'DELETE '.$wbTables['all_history'];
			$query .= ' FROM '.$wbTables['all_history'].', '.$table;
			$query .= ' WHERE '.$wbTables['all_history'].'.`file_id` = '.$table.'.`file_id` ';
			wbDB::runQuery($query);
			
			//fix all_links
			$query = 'DELETE '.$wbTables['all_links'];
			$query .= ' FROM '.$wbTables['all_links'].', '.$table;
			$query .= ' WHERE '.$wbTables['all_links'].'.`file_id` = '.$table.'.`file_id` ';
			wbDB::runQuery($query);
			
			$query = 'UPDATE '.$wbTables['all_links'].', '.$table;
			$query .= ' SET '.$wbTables['all_links'].'.`to_id` = NULL ';
			$query .= ' WHERE '.$wbTables['all_links'].'.`to_id` = '.$table.'.`file_id` ';
			wbDB::runQuery($query);
			
			
			//Delete from all_files
			$query = 'DELETE '.$wbTables['all_files'];
			$query .= ' FROM '.$wbTables['all_files'].', '.$table;
			$query .= ' WHERE '.$wbTables['all_files'].'.`file_id` = '.$table.'.`file_id` ';
			wbDB::runQuery($query);
			echo '<p>Information tables cleaned.</p>';
		}
		
		$this->emptyTables($rmSpace);
		
		$data = $dbObject->getConfiguration();
		unset($data['dbInfo'][$page->cmdArg[0]]);
		if( $dbObject->updateConfig($data) ){
			echo '<p><tt>'.$page->cmdArg[0].'</tt> was uninstalled.</p>';
		}
		
		echo wbLinks::admin($this->scriptName.'?refresh','continue');
		echo '</td></tr>';
		echo '</table>';
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//		Table handling
	//
	
	function getTables($rmSpace){
		global $wbTables;
		
		$query = 'SELECT `data` FROM '.$wbTables['ad_objects'];
		$query .= ' WHERE ';
		$query .= ' `selector` = "installTables:'.wbDB::escape($rmSpace).'" ';
		$result = wbDB::runQuery($query);
		if( !$result ){
			return false;
		}
		$row = mysql_fetch_assoc($result);
		if( !$row ){
			return false;
		}
		$tables = unserialize($row['data']);
		if( !is_array($tables) ){
			return false;
		}		
		
		return $tables;
	}
	
	//empty/drop tables
	function emptyTables($rmSpace){
		global $wbTables,$wbTablePrefix;
		
		if( !isset($_POST['tables']) ){
			$this->deleteVariables($rmSpace);
			return;
		}
		
		if( empty($_POST['tables']) ){
			return;
		}
		
	 	$this->deleteVariables($rmSpace);
		
		$tables = $this->getTables($rmSpace);
		$query = 'DELETE FROM '.$wbTables['ad_objects'];
		$query .= ' WHERE ';
		$query .= ' `selector` = "installTables:'.wbDB::escape($rmSpace).'" ';
		wbDB::runQuery($query);
 		
		if( $tables === false){
			return;
		}
		
 		$withPrefix = array();
 		foreach($tables as $table){
	 		$temp = ' `'.$wbTablePrefix.$table.'` ';
	 		$withPrefix[] = $temp;
 		}
 		
 		
 		if( $this->dropEnabled()  && ($_POST['tables'] == 'drop') ){
	 		$this->dropTables($withPrefix);
	 		return;
 		}
 		
 		
 		//empty
 		foreach($withPrefix as $table){
	 		$query = 'DELETE FROM '.$table;
			wbDB::runQuery($query);
 		}
 		
		echo '<p>Deleted database entries in: '.implode(', ',$withPrefix).'</p>';
	}
	
	function dropTables($tables){
 		$query = 'DROP TABLE '.implode(',',$tables);
		wbDB::runQuery($query);
		echo '<p>Dropped Tables: '.implode(',',$tables).'.</p>';
	}
	
	
	function deleteVariables($space){
		global $wbTables;
		
		$query = 'DELETE FROM '.$wbTables['config_vars'];
		$query .= ' WHERE ';
		$query .= ' `plugin_space` = "'.wbDB::escape($space).'" ';
		$result = wbDB::runQuery($query);
	}
		
	
	function dropEnabled(){
		if( isset($this->dropTable) ){
			return $this->dropTable;
		}
		
		includeFile('admin/CheckPrivs.php');
		if( checkPrivs::isGrantedCheck(array('DROP')) ){
			$this->dropTable = true;
		}else{
			$this->dropTable = false;
		}
		return $this->dropTable;
	}	
	
}
