<?php

//	Thing I'd like this script to do..
//		1)	Create the SQL array.. similar to sql.php ..this would be used for installing and updating
//		2)	

defined('WikyBlog') or die("Not an entry point...");

global $page,$pageOwner,$dbObject;
$page->regLink('Plugins','/Admin/'.$pageOwner['username'].'/Plugins');
$page->regLink('Plugin SQL','/Admin/'.$pageOwner['username'].'/PluginSQL');
$page->regLink('?','Plugin SQL?en=Plugin_SQL');
$page->autoForm = true;
$page->displayTitle = 'Plugin SQL';

if( !isAdmin() ){
	$page->contentA[$page->displayTitle] = 'You must be an administrator to access this page.';
	return;
}

if( !defined('wbDebug') || wbDebug !== true){
	message('This installation is not set up for development and some features may be disabled for security reasons.
				To enable these features, open your wiki.php file and uncomment or add the line <pre>	"define(\'wbDebug\',true);"</pre>
				<b>Note:</b> This should not be done in systems accessible via the internet.');
}
 



class adminDevPlugins{
	
	function adminDevPlugins(){
		global $page,$dbInfo,$rootDir;
		
		ob_start();
		
		
		switch( $page->userCmd ){
			case 'create sql data':
				$this->getData();
			break;
			default:
				$this->start();
			break;
		}
		
		
		$page->contentA['Plugin SQL'] = wb::get_clean();
	}
	
	function start(){
		global $wbTablePrefix;
		
		//skip tables that are already part of wikyblog		
		//$skipTables = array('all_files'=>1,'all_search'=>1,'all_history'=>1,'comments'=>1,'config'=>1,'help'=>1,'maps'=>1,'pages'=>1,'templates'=>1,'users'=>1,'workgroup'=>1);
		$skipTables = array();
		
		$query = 'SHOW TABLE STATUS ';
		if( !empty($wbTablePrefix) ){
			$query .= ' LIKE "'.wbDB::like($wbTablePrefix).'%"';
		}
		$result = wbDB::runQuery($query);
		//showRows($result);
		while($row = mysql_fetch_assoc($result)){
			$table = $row['Name'];
			if( strlen($wbTablePrefix) > 0 ){
				$pos = strpos($table,$wbTablePrefix);
				if( $pos === 0){
					$table = substr($table,strlen($wbTablePrefix));
				}
			}
			if( isset($skipTables[$table]) ){
				continue;
			}
			
			$tables[] = $table;
		}
		
		echo '<p>';
		echo 'This feature should be used by plugin developers to create the required sql.php file.';
		echo '</p>';
		
		echo '<table cellpadding="7"><tr><td>';
			echo '<p>Table Creation and Maintenance</p>';
			echo '<p>Select the table(s) from the list that are integral to your plugin.</p>';
		echo '</td><td>';
			echo '<select name="tables[]" multiple="multiple">';
			if( count($tables) === 0){
				message('All of the tables found in this database are already in use by the WikyBlog software. You must first create a table for your plugin.');
				echo '<option value="" > ---- ';
			}else{
				foreach( $tables as $table){
					echo '<option value="'.wbHtmlspecialchars($table).'" >'.wbHtmlspecialchars($table);
				}
			}
			echo '</select>';
			echo '<p>';
			echo '<input type="submit" name="cmd" value="Create SQL Data" />';
			echo '</p>';
		echo '</td></tr></table>';
		
	}
	
	//
	//	Database Info functions
	//
	function getData(){
		global $wbTablePrefix,$packageVersion;
		
		if( !isset($_POST['tables']) || !is_array($_POST['tables']) ){
			message('Please select table(s).');
			return false;
		}
		
		includeFile('installDB.php');
		$dbData = getDatabaseArray($wbTablePrefix,false,$_POST['tables']);
		
		$text = '<'.'?'."php\n";
		$text .= "//\n";
		$text .= "//\t\tWikyBlog Generated File\n";
		$text .= "//\t\tpackage version ".$packageVersion."\n";
		$text .= "//\t\tadminPluginSQL.php\n";		
		$text .= "//\t\t********************************************************************************************************\n";
		$text .= "//\t\tThis file contains a serialized array used to create/alter database tables used by the WikyBlog software\n";
		$text .= "//\t\tDon't edit anything in this file!\n";
		$text .= "//\n\n";
		$text .= 'defined(\'WikyBlog\') or die(\'Not an entry point...\');';
		$text .= "\n\n";
		$text .= '$dbData = \'';
		$text .= addcslashes(serialize($dbData),"\'");
		$text .= '\';';
		$text .= "\n";
		
		echo '<p>Save this data in your plugin\'s <tt>sql.php</tt> file.</p>';
		echo '<textarea style="width:100%" rows="15" wrap="off" readonly="readonly" onclick="this.select()">';
		echo wbHtmlspecialchars($text);
		echo '</textarea> ';
		
		echo '<input type="submit" name="cmd" value="Back" />';
		
		return false;
	}
}

new adminDevPLugins();