<?php
defined('WikyBlog') or die("Not an entry point...");

includeFile('search/all.php');

class userTools extends query{
	
	var $mod_flags = array('nofollow','disabled','suspended');
	
	//select unique sets of flags
	function UpdateUserFlags($where,$flags,$set = false){
		global $wbTables;
		
		$flags = explode(',',$flags);
		
		
		$query = 'SELECT DISTINCT `flags` FROM '.$wbTables['users'];
		$query .= ' WHERE '.$where;
		$result = wbDB::runQuery($query);
		$case = 'CASE `flags` ';
		$changeFlags = false;
		while($row = mysql_fetch_assoc($result) ){
			$currentFlags = explode(',',$row['flags']);
			$newFlags = array_diff($currentFlags,$this->mod_flags);
			$newFlags = array_merge($newFlags,$flags);
			$newFlags = array_diff($newFlags,array(''));
			$newFlags =  implode(',',$newFlags);
			
			if( $row['flags'] != $newFlags ){
				$case .= ' WHEN "'.wbDB::escape( $row['flags'] ).'" ';
				$case .= ' THEN "'.wbDB::escape( $newFlags ).'" ';
				$changeFlags = true;
			}
		}
		$case .= 'END';
		
		
		$query = ' UPDATE '.$wbTables['users'];
		$query .= ' SET `modified` = `modified` ';
		if( $changeFlags ){
			$query .= ' , `flags` = '.$case;
		}
		if( $set !== false ){
			$query .= $set;
		}
		$query .= ' WHERE '.$where;
		return wbDB::runQuery($query);
	}
		
	
	function getGroupInfo($id){
		global $page,$wbTables,$langA;
		if( !is_numeric($id) ){
			return false;
		}
		if( $id == 0){
			return $this->getDefaultInfo();
		}
		
		//get groups
		$query = 'SELECT '.$wbTables['config_ugroups'].'.*, `restricted` ';
		$query .= ' FROM '.$wbTables['config_ugroups'];
		$query .= ' LEFT JOIN '.$wbTables['users'];
		$query .= ' USING (`ugroup_id`) ';
		$query .= ' WHERE '.$wbTables['config_ugroups'].'.`ugroup_id` = "'.wbDB::escape($id).'" ';
		$query .= ' LIMIT 1 OFFSET 0 ';
		$result = wbDB::runQuery($query);
		if( $row = mysql_fetch_assoc($result) ){
			return $row;
		}
		return false;
	}
	
	
	function adminCompatible(&$groupInfo){
		
		if( (strpos($groupInfo['flags'],'suspended') === false) 
			&& (strpos($groupInfo['flags'],'disabled') === false) 
			&& empty($groupInfo['restricted'])
			){
			return true;
		}
		return false;
	}	
	
	
	function getAllGroups($count = false){
		global $page,$wbTables,$langA;
		$groups = array();
		$groups[] = $this->getDefaultInfo($count);
		
		// $query = 'SELECT * ';
		// $query .= ' FROM '.$wbTables['config_ugroups'];
		// $result = wbDB::runQuery($query);
		
		
		$query = 'SELECT ';
		$query .= $wbTables['config_ugroups'].'.* ';
		if( $count ){
			$query .= ', count('.$wbTables['users'].'.`ugroup_id`) AS `user_count` ';
		}
		$query .= ', '.$wbTables['users'].'.`restricted` ';
		$query .= ' FROM '.$wbTables['config_ugroups'];
		$query .= ' LEFT JOIN '.$wbTables['users'];  //LEFT JOIN because there might not be any users
		$query .= ' USING(`ugroup_id`) ';
		$query .= ' GROUP BY `ugroup_id` ';
		$result = wbDB::runQuery($query);
		
		
		while($row = mysql_fetch_assoc($result) ){
			$groups[$row['ugroup_id']] = $row;
		}
		return $groups;
	}
	
	/* static */
	function getDefaultInfo($count = false){
		global $page,$wbTables,$langA;
		
		
		//get non grouped
		$query = 'SELECT `flags` ';
		$query .= ', `max_history`, `max_usage`,`restricted` ';
		if( $count ){
			$query .= ', count(*) as `user_count` ';
		}
		$query .= ' FROM '.$wbTables['users'];
		$query .= ' WHERE `ugroup_id` = 0 ';
		$query .= ' GROUP BY `ugroup_id` ';
		//$query .= '  LIMIT 1 OFFSET 0 ';
		$result = wbDB::runQuery($query);
		$row = mysql_fetch_assoc($result);
		$row['flags'] = $this->cleanFlags($row['flags']); //we don't want the admin flag (or others) to be included!
		$row['name']  = 'Default Group';
		$row['ugroup_id'] = 0;
		return $row;
	}
	
	function cleanFlags($flags){
		$flags = explode(',',$flags);
		$flags = array_intersect($flags,$this->mod_flags);
		$flags = array_diff($flags,array(''));
		return implode(',',$flags);
	}
	
	
}