<?php

defined('WikyBlog') or die("Not an entry point...");

class checkInstallation{
	var $missing = array();
	var $zerosize = array();
	var $badsize = array();
	var $complete = true;
	var $message = '';
	
	function checkInstallation(){
		global $includeDir,$page,$page;
		
		includeFile('/maintenance/files.php');
		$files = returnFiles();
		clearstatcache();
		
		foreach($files as $file => $size){
			if( $file == '/maintenance/files.php'){
				continue;
			}
			
			$fullPath = $includeDir.$file;
			if( !is_file($fullPath) ){
				$this->missing[] = $file;
				continue;
			}
			$localSize = filesize($fullPath);
			if( ($size !== 0) && ($localSize === 0)){
				$this->zerosize[] = $file;
				continue;
			}
			
			if( (($size-100) > $localSize) || (($size+100) < $localSize)){
				$this->badsize[] = $file;
			}
		}
		
		if( count($this->missing) > 0 ){
			$this->complete = false;
			$this->message .= '<br/>The following files were missing:';
			$this->message .= '<ul>';
			foreach($this->missing as $file){
				$this->message .= '<li><tt>/include'.$file.'</tt></li>';
			}
			$this->message .= '</ul>';
		}
		if( count($this->zerosize) > 0 ){
			$this->complete = false;
			$this->message .= '<br/>The following files had a size of zero:';
			$this->message .= '<ul>';
			foreach($this->zerosize as $file){
				$this->message .= '<li><tt>/include'.$file.'</tt></li>';
			}
			$this->message .= '</ul>';
		}
		if( count($this->badsize) > 0 ){
			$this->complete = false;
			$this->message .= '<p>The following files appear to have the incorrect size:';
			$this->message .= '<ul>';
			foreach($this->badsize as $file){
				$this->message .= '<li><tt>/include'.$file.'</tt></li>';
			}
			$this->message .= '</ul>';
			$this->message .= '</p>';
		}
		
		if( $this->complete ){
			$this->message = 'All of the files in the include directory have been checked and appear up to date.';
		}else{
			$this->message = '<b>Warning:</b> Some of the files on your server appear out of date. Try uploading the follwing files again.'.$this->message;
		}
	}
	
	function checkPage(){
		global $includeDir,$page,$page,$dbObject,$pageOwner;
		$page->regLink('Check Installation','/Admin/'.$pageOwner['username'].'/CheckInstallation');
		$page->autoForm = true;
		$page->displayTitle = 'Check Installation';
		$page->contentA['Check Installation'] = $this->message;
	}
}

global $initiateFileClass;
if( $initiateFileClass ){
	$temp = new checkInstallation();
	$temp->checkPage();
}