<?php
defined('WikyBlog') or die("Not an entry point...");


if( !isAdmin() ){
	$page->contentA[$page->displayTitle] = 'You must be an administrator to access this page.';
	return;
}

class htaccess{
	function htaccess(){
		global $page,$pageOwner,$dbObject;
		$contentUri = $page->regLink('htaccess','/Admin/'.$pageOwner['username'].'/htaccess');
		$page->autoForm = true;
		
		$page->regLink('?','htaccess?en=htaccess');
		
		
		
		// $mods = apache_get_modules(); //only available since 4.3.2
		// echo showArray($mods);
		
		// if( file_exists($fileLocation) ){
		// 	message('file exists');
		// }
		
		//
		$this->avail = array();
		$this->avail['index.php'] = true;
		$this->avail['redir_home'] = true;
		$this->avail['negotiation'] = true;
		$this->avail['negotiation_rewrite'] = true;
		
		if( function_exists('apache_get_modules') ){
			$mods = array_flip(apache_get_modules());
			
			//index.php
			if( !isset($mods['mod_rewrite']) ){
				$this->avail['index.php'] = false;
			}
			
			//redir_home
			if( !isset($mods['mod_rewrite']) || !isset($mods['mod_alias']) ){
				$this->avail['redir_home'] = false;
			}
			
			//negotiation
			if( !isset($mods['mod_negotiation']) || !isset($mods['mod_mime']) ){ //mod_mime for AddHandler/AddType
				$this->avail['negotiation'] = false;
			}
			
			//rewrite negotiation
			if( !isset($mods['mod_rewrite']) || !isset($mods['mod_setenvif']) || !isset($mods['mod_header']) ){
				$this->avail['negotiation_rewrite'] = false;
			}
			
			
			//message('here '.showArray($mods));
		}else{
			message('Your installation of php does not have the <em>apache_get_modules()</em> function so this script could not determine which options are actually available.');
		}
		
		
		ob_start();
		
		switch($page->userCmd){
			
			case 'create code':
				$this->output();
			break;
			
			default:
				$this->options();
			break;
		}
		
		$page->contentB[$contentUri] = wb::get_clean();
	}
	
	function options(){
		global $wbConfig, $serverName3;
		echo '<p>';
		echo 'If you are using an Apache HTTP Server you may be able to take advantage of .htaccess files. ';
		echo 'Having an .htaccess file on your server enables url\'s that look like <tt>www.server.com/Main/'.$GLOBALS['wbDefaultTitle'].'</tt> instead of <tt>www.server.com/index.php/Main/'.$GLOBALS['wbDefaultTitle'].'</tt>.';
		echo '</p>';
		
		
		$defaultUrl = '/'.$wbConfig['pUser'].'/'.$GLOBALS['wbDefaultTitle'];
		
		
		echo '<table  border="0" cellspacing="7" cellpadding="7"  class="WBeditArea1" style="margin:1em auto 1em auto;">';
		
		echo '<tr>';
			echo '<td style="white-space:nowrap">';
			echo '<b>';
			echo 'index.php';
			echo '</b>';
			echo '</td>';
			echo '<td>';
			if( $this->avail['index.php'] ){
				echo '<input type="checkbox" name="index" value="true" />';
			}else{
				echo 'Unavailable';
			}
			echo '</td>';
			echo '<td class="sm">';
			echo 'Enable requests like <em>'.$defaultUrl.'</em> instead of <em>/index.php'.$defaultUrl.'</em>';
			echo '</td>';
			echo '</tr>';

		echo '<tr>';
			echo '<td style="white-space:nowrap">';
			echo '<b>';
			echo $defaultUrl;
			echo '</b>';
			echo '</td>';
			echo '<td>';
			if( $this->avail['redir_home'] ){
				echo '<input type="checkbox" name="redir_home" value="true" />';
			}else{
				echo 'Unavailable';
			}
			echo '</td>';
			echo '<td class="sm">';
			echo 'Redirect requests for <em>'.$serverName3.'</em> to <em>'.$serverName3.'/'.$wbConfig['pUser'].'/'.$GLOBALS['wbDefaultTitle'].'</em>';
			echo '</td>';
			echo '</tr>';
			
		echo '<tr>';
			echo '<td style="white-space:nowrap">';
			echo '<b>';
			echo 'Content Negotiation';
			echo '</b>';
			echo '</td>';
			echo '<td>';
			echo '<input type="radio" name="negotiation" value="none" />';
			echo '</td>';
			echo '<td class="sm">';
			echo 'None';
			echo '</td>';
			echo '</tr>';
			
		echo '<tr>';
			echo '<td>';
			echo '</td>';
			echo '<td>';
			if( $this->avail['negotiation'] ){
				echo '<input type="radio" name="negotiation" value="negotiation" />';
			}else{
				echo 'Unavailable';
			}
			echo '</td>';
			echo '<td class="sm">';
			echo 'Allow the server to send compressed versions of static files like <em>script.js.gz</em> instead of <em>script.js.js</em>. Requires alternate installation of WikyBlog.';
			echo '</td>';
			echo '</tr>';

		echo '<tr>';
			echo '<td>';
			echo '</td>';
			echo '<td>';
			if( $this->avail['negotiation_rewrite'] ){
				echo '<input type="radio" name="negotiation" value="rewrite" />';
			}else{
				echo 'Unavailable';
			}
			echo '</td>';
			echo '<td class="sm">';
			echo 'Use mod_rewrite to send the compressed <em>script.js.gz</em> instead of <em>script.js</em>.';
			echo '</td>';
			echo '</tr>';

			
		echo '<tr>';
			echo '<td>';
			echo '</td>';
			echo '<td colspan="2">';
			echo '<input type="submit" name="cmd" value="Create Code" />';
			echo '</td>';
			echo '</tr>';			
			
		echo '</table>';
	}
	
	
	function output(){
		global $rootDir;
		$fileLocation = $rootDir.'/.htaccess';
		
		echo '<ol>';
		echo '<li>Create the file <em>'.$fileLocation.'</em> containing the following code.</li>';
		echo '<li>Test your installation and modify your .htaccess file as needed.</li>';
		echo '</ol>';
		
		echo '<h2>Code</h2>';
		echo '<textarea style="width:100%" rows="15" cols="80" wrap="off" readonly="readonly" onclick="this.select()">';
		echo $this->getContents();
		echo '</textarea>';
		echo '<input type="submit" name="" value="Start Over" />';
	}
	
	function getContents(){
		global $wbConfig,$serverName3,$wbDirPrefix, $packageVersion;
		$tab = "\t";
		$t = array();
		
		if(empty($wbDirPrefix) ){
			$htaccessDir = '/';
		}else{
			$htaccessDir = addcslashes($wbDirPrefix,'.&$').'/';
		}
		
		$defaultUrl = '/'.$wbConfig['pUser'].'/'.$GLOBALS['wbDefaultTitle'];
		
		
		$t[] = '#WikyBlog generated .htaccess file';
		$t[] = '#Version '.$packageVersion;
		$t[] = '';
		$t[] = '';
		
		
		//
		//	Rewrite
		//
			if( isset($_POST['redir_home']) ){
				$t[] = '#Redirect to '.$defaultUrl;
				$t[] = '<IfModule mod_rewrite.c>';
				$t[] = $tab.'<IfModule mod_alias.c>';
				$t[] = $tab.$tab.'RedirectMatch permanent ^'.$htaccessDir.'$ '.$serverName3.'/'.$wbConfig['pUser'].'/'.$GLOBALS['wbDefaultTitle'];
				$t[] = $tab.'</IfModule>';
				$t[] = '</IfModule>';
				$t[] = '';
				$t[] = '';
			}
		
		//
		//	Rewrite
		//
			if( isset($_POST['index']) ){
				$t[] = '#Enable '.$defaultUrl.' instead of /index.php'.$defaultUrl;
				$t[] = '<IfModule mod_rewrite.c>';
				$t[] = $tab.'RewriteEngine On';
				$t[] = '';
							
				$t[] = $tab.'# Don\'t Rewrite For Existing Files';
				$t[] = $tab.'RewriteCond %{REQUEST_FILENAME} !-f [NC]';
				$t[] = '';
				
				
				$t[] = $tab.'# Don\'t Rewrite For Existing Directories Except for the root directory';
				$t[] = $tab.'RewriteCond %{REQUEST_FILENAME} !-d [NC,OR]';
				$t[] = $tab.'RewriteCond %{REQUEST_URI}	^'.$htaccessDir.'$';
				$t[] = '';
				
				$t[] = $tab.'RewriteRule .* wiki.php [L]';
				$t[] = '</IfModule>';
				$t[] = '';
				$t[] = '';
			}
			
		//
		//	Negotiation
		//
			
			if( isset($_POST['negotiation']) ){
				
				if( $_POST['negotiation'] == 'rewrite' ){
				
					$t[] = '# send script.js.gz instead of script.js when possible';
					$t[] = '<IfModule mod_rewrite.c>';
					$t[] = '	<IfModule mod_setenvif.c>';
					$t[] = '		<IfModule mod_header.c>';
					$t[] = '';
					$t[] = '			SetEnvIf Accept-Encoding "gzip" WB_GZ_JS=yes';
					$t[] = '';
					$t[] = '			#some browsers dont handle gz files correctly';
					$t[] = '			#see mod_deflate for more info';
					$t[] = '			BrowserMatch ^Mozilla/4		WB_GZ_JS=no';
					$t[] = '			BrowserMatch \bMSI[E]		WB_GZ_JS=yes';
					$t[] = '';
					$t[] = '			RewriteCond %{REQUEST_URI}	\.js$ [NC]';
					$t[] = '			RewriteCond %{ENV:WB_GZ_JS}	yes';
					$t[] = '			RewriteCond %{REQUEST_FILENAME}.gz	-f';
					$t[] = '			RewriteRule ^(.*)$ $1.gz [T=application/x-gzip]	#force gzip mime type';
					$t[] = '';
					$t[] = '			#for proxies';
					$t[] = '			Header append Vary User-Agent';
					$t[] = '			#the encoding';
					$t[] = '			Header append Vary Accept-Encoding';
					$t[] = '		</IfModule>';
					$t[] = '	</IfModule>';
					$t[] = '</IfModule>';
					$t[] = '';
					$t[] = '';
				
				}elseif( $_POST['negotiation'] == 'negotiation' ){
					
					$t[] = '#Content Negotiation';
					$t[] = '#send script.js.gz instead of script.js.js';
					$t[] = '#requires alternate installation of WikyBlog';
					$t[] = '<IfModule mod_negotiation.c>';
					$t[] = '';
					$t[] = '	Options +MultiViews';
					$t[] = '	AddEncoding x-gzip .gz';
					$t[] = '';
					// $t[] = '	AddType application/x-javascript .gz';
					// $t[] = '	AddType text/html .gz';
					// $t[] = '	AddType text/css .gz';
					
					$t[] = '';
					$t[] = '</IfModule>';
					$t[] = '';
					$t[] = '';
				}
			}
		
		//
		//	php values
		//
			$t[] = '#php values';
			$t[] = 'php_value magic_quotes_gpc 0';
			$t[] = 'php_value magic_quotes_runtime 0';
			$t[] = 'php_value magic_quotes_sybase 0';
			$t[] = 'php_flag mbstring.func_overload off';
			$t[] = 'php_flag register_globals off';
			$t[] = '';

		return wbHtmlspecialchars(implode("\n",$t));
	}
}
new htaccess();

