<?php
//	Some Standards for creating new entries
// 
//		UPPER CASE keys should be used when the text is a phrase
//			$langA['UPPER_CASE'] = 'This is an UPPER_CASE entry in $langA';
//			$langA['COPY_TO'] = 'Copy  &nbsp; <b>%s</b> &nbsp; to &nbsp; <b>%s</b>.<br/>Click "Save" to finalize the copy.';
//
//		lower case keys should be used for more simple word for word tanslations
//			$langA['lower_case'] = 'lower case';
//			$langA['copy_to'] = 'Copy To...';
//
//		Use _ (uderscore) for spaces in keys
//			$langA['A_SPACE']  .. instead of $langA['A SPACE']
//
//		Prefer <tt> to <i>


//
//	wiki2.php
//

$langA['NEW_PAGE_FORMAT'] = 'l,_F_j,_Y'; //format to be used with php's date() function

$langA['file'] = 'File';
$langA['edit'] = 'Edit';
$langA['edits'] = 'Edits';
$langA['view_source'] = 'View Source';
$langA['talk'] = 'Talk';
//$langA['reply'] = 'Reply';
$langA['history'] = 'History';
$langA['diff'] = 'Diff';
$langA['watch'] = 'Watch';
$langA['unwatch'] = 'Unwatch';
$langA['options'] = 'Options';


$langA['messages'] = 'Messages';
$langA['current'] = 'Current';
$langA['blog'] = 'Blog';
$langA['possible'] = 'Possible';

$langA['DEFAULT_CONTENT'] = 'This is a new file, would you like to [[%s?cmd=edit|create it]]?'; //replaced with url to current page
$langA['DEFAULT_CONTENT_PROTECTED'] = 'This is a new file. To create this file, you need to be logged in with appropriate privileges.';

$langA['NOT_OWNER'] = 'You do not have the appropriate privileges for this feature.';
$langA['LONG_PATH'] = 'The title for this file was too long and has been truncated.';
$langA['EMPTY_CONTENT'] = 'Content is a required field';
$langA['INCOMPLETE_PATH'] = 'The supplied path is incomplete.';
$langA['ADMIN_DISABLED_ALL_USERS'] = 'Sorry, the website administrator has disabled user blogging. To create a bliki with the same features found here, visit <a href="http://www.wikyblog.com">WikyBlog.com</a>.';
$langA['TITLE_EXISTS'] = 'This title already exists, please select a different one then save again.';

$langA['HIDDEN_FILE'] = 'Access to this file has been restricted by it\'s owner. To view this file, you need the appropriate privileges.';
$langA['HIDDEN_FILE2'] = 'This file is "hidden". ';
$langA['DELETED_FILE'] = 'This file is currently in the "trash". If you are the owner of this account, you can restore this file via your control panel.';
$langA['PROTECTED_FILE'] = 'This file is protected. Any changes made to this file were not saved.';
$langA['INVALID_THEME'] = 'Invalid theme name defined in preferences. Using default theme.';
$langA['link_text'] = 'Link Text';
$langA['SURPASSED_MAX'] = '<b>Warning:</b> Disk usage has exceeded the allotted amount. Any changes made to this file were not saved.';


$langA['REDIRECTED'] = 'Redirected from %s.';
$langA['REDIRECT_TO'] = 'This page redirects to %s.';

//	Data Types
$langA['all'] = 'All';
$langA['page'] = 'Page';
$langA['comment'] = 'Comment';
$langA['map'] = 'Map';
$langA['template'] = 'Template';
$langA['help'] = 'Help';
$langA['skeleton'] = 'Skeleton';
$langA['attach'] = 'Attachment';

$langA['theme'] = 'Theme';

$langA['comments'] = 'Comments';

//exceptions to our standards because we use the name of datatypes 
$langA['CLASSpage'] = 'Pages';
$langA['CLASScomment'] = 'Comments';
$langA['CLASSmap'] = 'Maps';
$langA['CLASStemplate'] = 'Themes';
$langA['CLASShelp'] = 'Help';
$langA['IS_CONTENT_TEMPLATE'] = 'This file is a content template and won\'t be shown on your blog.';


$langA['seconds'] = ' secs';
$langA['queries'] = ' queries';

$langA['QUERY_TIME'] = ' for queries';
$langA['INVALID_PATH'] = 'Invalid file path supplied: <tt>%s</tt>.';							//replaced with path
$langA['INVALID_REQUEST'] = 'Invalid Request.';


//	CLASStemplate.php
$langA['THEME_DEFAULT_CONTENT'] = 'This is a new theme. Edit this theme by clicking the "Edit" link above.<br/>When creating themes remember to include all of the required content variables:';
$langA['your_theme'] = 'Your Theme';
$langA['CURRENT_THEME'] = 'You are currently using theme <b>%s</b>.'; //replaced with template name

$langA['use_this_theme'] = 'Use this theme instead';
$langA['using_this_theme'] = 'You are currently using this theme.';
$langA['MAKE_THEME'] = 'Make a personalized theme using a copy of this one as a starter.';
$langA['EDIT_THEME_TEXT'] = '<p><h2>Editing</h2> When editing themes, your changes will not be immediately visible.<br />You may have to use your browser\'s "refresh" button to review changes after saving.';

//	CLASShelp.php
$langA['HELP_FOOTER'] = 'As an integrated part of the software, this help file is stored on a central server.<br/> You can edit the contents of %sthis%s and other help files at %s.';

$langA['NEW_HELP'] = 'Create a new help file';



//	Special Files that need to be in with main lang file
$langA['browse'] = 'Browse';
$langA['change_log'] = 'Change Log';
$langA['control_panel'] = 'Control Panel';
$langA['administration'] = 'Administration';
$langA['preferences'] = 'Preferences';
$langA['watchlist'] = 'Watchlist';
$langA['wanted_files'] = 'Wanted Files';
$langA['dead_end'] = 'Dead-End Files';
$langA['search'] = 'Search';
$langA['orphaned_files'] = 'Orphaned Files';
$langA['most_linked'] = 'Most Linked To Files';
$langA['scrl'] = 'Enhanced Scroll';
$langA['nWin'] = 'External Links';
$langA['enhanced_tabs'] = 'AJAX Browsing';

$langA['MORE_RECENT_POST'] = 'More Recent Posts.';
$langA['NEED_INTERNET'] = 'This feature is only available for systems connected to the internet.';


//	SESSION
$langA['COOKIES_REQUIRED'] = '<b>Warning:</b> Cookies are required to continue. Refresh this page if you have cookies enabled.';
$langA['LOGIN_REQUIRED'] = 'You must be signed in to use this feature.';

$langA['ENTER_USERNAME'] = 'Please enter your Username.';
$langA['ENTER_PASSWORD'] = 'Please enter your Password.';
$langA['LOGGED_OUT'] = 'You have successfully logged out.';
$langA['AUTO_LOGOUT'] = 'Your session has expired.';

$langA['LOGIN_FAILED'] = 'Log in failed: Incorrect Password.<ul><li>Is Caps Lock on?<li> Have you %sforgotten your password%s?</li></ul>'; //replacements are for <a href=""> and </a>
$langA['LOGIN_BLOCK'] = 'The maximum number of %s login attempts has been exceeded. You will not be allowed to login for the next %s minutes.';
						
$langA['create_new'] = 'Create&nbsp;New ';
$langA['remember_me'] = 'Remember Me';
$langA['log_out'] = 'Log Out';
$langA['log_in'] = 'Log In';

//	SAVING 
$langA['syntax_error'] = 'syntax error';
//$langA['SYNTAX_WARNING'] = 'A %s was detected within this file and may result in undesired formatting.'; //%s will be replaced with a link and $langA['syntax_error']
$langA['SYNTAX_WARNING'] = 'A <a %s>syntax error</a> was detected within this file and may result in undesired formatting.';

$langA['OTHER_ACCOUNT'] = 'Would you like to create files for %s instead of %s.';
$langA['MAKE_ADMIN'] = 'Set the <a %s>file options</a> to "<tt>Admin Only</tt>" to skip syntax checking.';


$langA['THEME_SYNTAX_WARN'] = '<b>Syntax Error:</b> Unable to Save/Display the most recent changes to this file due to an incompatible syntax.';
$langA['SYNTAX_FIXED'] = 'The syntax error has been fixed.';


$langA['NO_CHANGES'] = 'No changes were made to this file. (%s)';								//replaces with 1 or 2.. there are two checks for changes
$langA['UNABLE_TO_SAVE'] = 'Unable to save this File. (%s)';									//replaces with 1,2,3 or 4..
$langA['SAVED_FILE'] = 'Changes to this file have been saved.';
$langA['HIDDEN_FILE3'] = '<b>Note:</b> This is a hidden file, therefore tags for this file will not be included in the user menu totals.';

$langA['VERSION_CONFLICT'] = 'Warning: We could not save your changes because we detected a version conflict.';
$langA['VERSION_CONFLICT_2'] = 	'Warning: We could not save your changes because we detected a version conflict.
								The following events could have resulted in this discrepancy.
								<ul><li>You may be trying to overwrite an existing file.</li>
								<li>Your session may have expired.</li>
								<li>Someone else may have saved changes to this file.</li></ul>';

$langA['COPY_TO'] = 'Copy  &nbsp; <b>%s</b> &nbsp; to &nbsp; <b>%s</b>.<br/>Click "Save" to finalize the copy.'; //replaced with paths

$langA['FLOOD_WARN'] = 'Editing has been limited to one file every %s seconds. Please try again in %s seconds.';
$langA['INCORRECT_CAPTCHA'] = 'The CAPTCHA image did not match your text, please try again.';

//	toolOptions .. see /lang/../toolOptions.php
$langA['save_options'] = 'Save Options';
$langA['blog_this'] = 'Blog This';



//	toolHistory2.php
$langA['differences'] = 'difference(s)';
$langA['line_num'] = 'Line #';


//	toolHistory1.php
$langA['revision'] = 'Revision ';
$langA['revision_as_of'] = 'Revision as of ';
$langA['revision_num_as_of'] = 'Revision %s as of %s'; //replaced with revision num and timestamp
$langA['edit_revision'] = 'Edit Revision';
$langA['revert_to_revision'] = 'Revert To This Revision';
$langA['reverted_to_rev'] = 'Reverted to revision #';
$langA['SET_USER_PERMISSIONS'] = 'Set your permissions for this user: '; 
$langA['compare_with_prev'] = '← Compare with Previous Revision';
$langA['current_revision'] = 'Current Revision';
$langA['compare_with_next'] = 'Compare with Next Revision →';
$langA['lines'] = 'Lines';
$langA['text'] = 'Text';
$langA['vs'] = ' vs ';
$langA['content'] = 'Content';
$langA['your_text'] = 'Your Text';
$langA['show_prev_revision'] = '← Revision %s'; //%s replaced with a revision number
$langA['show_next_revision'] = 'Revision %s →'; //%s replaced with a revision number

$langA['EDITING_REVISION'] = '<b>Warning:</b> You are not editing the most recent version of this page.<br /> Saving will replace the newest version with this out-of-date version.';
$langA['SELECT_TWO_VERSIONS'] = 'Please select two distinct versions to compare.';
$langA['NO_UNIQUE_REVISION'] = 'Could not find a unique revision for this request.';
$langA['INVALID_REVISION'] = '<b>Error:</b> Invalid Revision Number.';
$langA['NO_DIFFERENCES'] = 'The two revisions being compared are identical.';
$langA['NO_REVISIONS'] = 'There must be two distinct revisions before a comparison can be made.';
$langA['NON_EXISTANT'] = 'This file does not exist yet.';

//	toolEditPage.php
$langA['bold_text'] = 'Bold text';
$langA['italic_text'] = 'Italic text';
$langA['headline_text'] = 'Insert Heading';
$langA['title'] = 'Title';
$langA['unordered_list'] = 'Unordered List';
$langA['ordered_list'] = 'Ordered List';


$langA['internal_link'] = 'Internal Link';
$langA['link'] = 'Link';
$langA['external_link'] = 'External Link';
$langA['embed_image'] = 'Embed Image';
$langA['find_images'] = 'Find Images';
$langA['image'] = 'Image';
$langA['nowiki'] = 'nowiki';
$langA['NOWIKI_TEXT'] = 'Insert non-formatted text here';
$langA['signature'] = 'Signature';
$langA['SIGNATURE_TEXT'] = 'Insert your Signature';
$langA['preview'] = 'Preview';
$langA['PREVIEW_TEXT'] = 'Preview your changes [%s-p]';
$langA['PREVIEW_WARN'] = 'This is only a preview. Your changes have not been saved yet!';
$langA['SAVE_TEXT'] = 'Save your changes [%s-s]';
$langA['reset'] = 'Reset';
$langA['RESET_TEXT'] = 'Reset this form to it\'s original state [%s-c]';
$langA['changes'] = 'Changes';
$langA['CHANGES_TEXT'] = 'Show the changes you\'ve made to this file. [%s-d]';

$langA['DEFAULT_KEYWORD_FIELD'] = 'Organize your posts with comma separated keywords'; //should not contain ( or )
$langA['keywords'] = $langA['tags'] = 'Tags';
$langA['edit_summary'] = 'Edit Summary';
$langA['syntax_warning'] = 'Syntax Warning';
$langA['NO_IMAGES'] = 'No Images Found';
$langA['insert_emoticons'] = 'Insert Emoticons';
$langA['upload'] = 'Upload';



//searchHistory
$langA['show'] = 'Show';
$langA['hide'] = 'Hide';
$langA['compare'] = 'Compare';
$langA['timeline'] = 'Timeline';
$langA['summary'] = 'Summary';
$langA['COMPARE_REVISONS'] = 'Compare with the selected version.';
$langA['unchecked'] = 'Unchecked';



//
//	toolBatch
//
$langA['INVALID_FILE_TYPE'] = 'Invalid File Type supplied.';


//	SEARCH
$langA['next'] = 'Next';
$langA['previous'] = 'Previous';
$langA['order_by'] = 'Order by:';
$langA['ascending'] = 'Ascending';
$langA['descending'] = 'Descending';
$langA['search_from'] = 'Search From: ';
$langA['all_users'] = 'All Users';
$langA['user'] = 'User';
$langA['from_file_type'] = 'Search From File Type: ';
$langA['read_more'] = 'Read More';
$langA['words'] = ' words';

$langA['RESULTS'] = 'Results %s to %s of %s'; //  Results 1 to 25 of 65 
$langA['EMPTY_SET'] = 'No entries found for the search criteria.';

//searchTalk
$langA['add_comment'] = 'Add New Topic';



//	myParser
$langA['BAD_DUPLICATE_ENTRY'] = 'Could not include warning. Poorly formatted data for duplicate entry.';
$langA['duplicate_entry'] = 'Duplicate Entry';
$langA['DUPLICATE_ENTRY'] = 'This is a duplicate entry for the page found at %s. <br/>Any non redundant information found here should be transfered to the original before this page is deleted.'; //pages can be flagged as being a duplicate of another page, the text from this entry will shown to users when a page is flagged as a "duplicate entry"
$langA['not_found'] = 'Not found: '; //used for the alt attribute in an <img> tag when an image is not found

//	error
$langA['ERROR_OCCURED'] = '<b>Error:</b><br /> An error occurred while executing this script.<br /> Please check your request and we will attempt to debug the script with the error log. %s'; //replaced with link to error log for admin

//	CLASStemplate
$langA['DELETE_DEFAULT_TEMPLATE'] = 'Cannot delete the default template.';
$langA['THEME_MISSING_VARS'] = 'Missing required variable(s): <tt>%s</tt>.';
$langA['css1'] = 'CSS1';
$langA['css2'] = 'CSS2';
$langA['INVALID_THEME'] = 'The specified theme was invalid.';

//
//	CLASSmap
//
$langA['new_marker']='New Marker';
$langA['new_route']='New Route';
$langA['SAVE_HEADER']='Before Saving Remember';
$langA['save_map']='Save Map';
$langA['continue_editing']='Continue Editing';
$langA['miles/km'] = 'miles/km';
$langA['MAP_DEFAULT_CONTENT'] = '<b>This is a new map.</b><br/> To create/edit this map, click "Edit" above.';
$langA['MAP_DEFAULT_CONTENT_PROTECTED'] = 'Sorry, you don\'t have sufficient privileges to edit this map.';
$langA['play'] = 'Play';
$langA['stop'] = 'Stop';
$langA['import'] = 'Import';
$langA['export'] = 'Export';
$langA['gpx_data'] = 'GPX Data';
$langA['gpx_exchange_format'] = 'GPX Exchange Format';
$langA['CLICK_EDIT'] = 'To edit the map, click "edit" above';


//	smileys
$langA['smiles'][':D'] = 'Very Happy';
$langA['smiles'][':)'] = 'Smile';
$langA['smiles'][':('] = 'Sad';
$langA['smiles'][':o'] = 'Surprised';
$langA['smiles'][':shock:'] = 'Shocked';
$langA['smiles'][':?'] = 'Confused';
$langA['smiles']['8)'] = 'Cool';
$langA['smiles'][':lol:'] = 'Laughing';
$langA['smiles'][':x'] = 'Mad';
$langA['smiles'][':P'] = 'Razz';
$langA['smiles'][':oops:'] = 'Embarassed';
$langA['smiles'][':cry:'] = 'Crying or Very sad';
$langA['smiles'][':evil:'] = 'Evil or Very Mad';
$langA['smiles'][':twisted:'] = 'Twisted Evil';
$langA['smiles'][':roll:'] = 'Rolling Eyes';
$langA['smiles'][':wink:'] = 'Wink';
$langA['smiles'][':!:'] = 'Exclamation';
$langA['smiles'][':?:'] = 'Question';
$langA['smiles'][':idea:'] = 'Idea';
$langA['smiles'][':arrow:'] = 'Arrow';
$langA['smiles'][':|'] = 'Neutral';
$langA['smiles'][':mrgreen:'] = 'Mr. Green';

//
//	General Language
//
$langA['or'] = 'or';
$langA['username'] = 'Username';
$langA['password'] = 'Password';
$langA['email'] = 'E-mail';
$langA['register'] = 'Register';
$langA['cancel'] = 'Cancel';
$langA['language'] = 'Language';
$langA['use'] = 'Use';
$langA['copy'] = 'Copy';
$langA['rename'] = 'Rename';

$langA['on'] = 'On';
$langA['partial'] = 'Partial';
$langA['off'] = 'Off';
$langA['save'] = 'Save';
$langA['save_now'] = 'Save Now';
$langA['undefined'] = 'Undefined';
$langA['homepage'] = 'Homepage';
$langA['home'] = 'Home';
$langA['go'] = 'Go';
$langA['user_menu'] = 'User Menu';

$langA['last_modified'] = 'Last Modified';
$langA['LAST_MODIFIED'] = 'Last modified %s by %s.';//%s replaced with date and username
$langA['accessed_times'] = 'Accessed %s times';// %s replaced with a number
$langA['modified'] = 'Modified';
$langA['posted'] = 'Posted';
$langA['created'] = 'Created';
$langA['hidden'] = 'Hidden';
$langA['what_links_here'] = 'What Links Here';
$langA['share'] = 'Share';
$langA['INVALID_LINK'] = 'The requested page title was invalid. It may contain one more characters which cannot be used in titles.';
$langA['FILE_MUST_EXIST'] = 'The file must be saved before you can perform this operation.';

$langA['OOPS'] = 'Oops, that didn\'t work, please try again.';


$langA['size'] = 'Size ';
$langA['bytes'] = 'bytes';
$langA['kb'] = 'KB';
$langA['mb'] = 'MB';
$langA['gb'] = 'GB';
$langA['update'] = 'Update';
$langA['editing'] = 'Editing';
$langA['workgroup'] = 'Workgroup';
$langA['BROWSE_HIDDEN'] = 'Find hidden files';

$langA['delete'] = 'Delete';
$langA['confirm_delete'] = 'Confirm Delete';
$langA['continue'] = 'Continue';
$langA['back'] = 'Back';
$langA['close'] = 'Close';
$langA['view'] = 'View';
$langA['empty'] = '-empty-';
$langA['none'] = 'None';
$langA['total'] = 'Total ';
$langA['files'] = 'Files';
$langA['other'] = 'Other';
$langA['trash'] = 'Trash';
$langA['flagged'] = 'Flagged';

$langA['today'] = 'Today';
$langA['yesterday'] = 'Yesterday';
$langA['days_ago'] = ' days ago';
$langA['page_contents'] = 'Page Contents';
$langA['more'] = 'More';
$langA['download'] = 'Download';


//Date
$langA['date_l'][0] = 'Sunday';
$langA['date_l'][1] = 'Monday';
$langA['date_l'][2] = 'Tuesday';
$langA['date_l'][3] = 'Wednesday';
$langA['date_l'][4] = 'Thursday';
$langA['date_l'][5] = 'Friday';
$langA['date_l'][6] = 'Saturday';

$langA['date_D'][0] = 'Sun';
$langA['date_D'][1] = 'Mon';
$langA['date_D'][2] = 'Tue';
$langA['date_D'][3] = 'Wed';
$langA['date_D'][4] = 'Thu';
$langA['date_D'][5] = 'Fri';
$langA['date_D'][6] = 'Sat';


$langA['date_F'][1] = 'January';
$langA['date_F'][2] = 'February';
$langA['date_F'][3] = 'March';
$langA['date_F'][4] = 'April';
$langA['date_F'][5] = 'May';
$langA['date_F'][6] = 'June';
$langA['date_F'][7] = 'July';
$langA['date_F'][8] = 'August';
$langA['date_F'][9] = 'September';
$langA['date_F'][10] = 'October';
$langA['date_F'][11] = 'November';
$langA['date_F'][12] = 'December';

$langA['date_M'][1] = 'Jan';
$langA['date_M'][2] = 'Feb';
$langA['date_M'][3] = 'Mar';
$langA['date_M'][4] = 'Apr';
$langA['date_M'][5] = 'May';
$langA['date_M'][6] = 'Jun';
$langA['date_M'][7] = 'Jul';
$langA['date_M'][8] = 'Aug';
$langA['date_M'][9] = 'Sept';
$langA['date_M'][10] = 'Oct';
$langA['date_M'][11] = 'Nov';
$langA['date_M'][12] = 'Dec';

$langA['date_a']['am'] = 'am';
$langA['date_a']['pm'] = 'pm';

$langA['date_A']['am'] = 'AM';
$langA['date_A']['pm'] = 'PM';

$langA['lang']['ar'] = 'Arabic (ar)';
$langA['lang']['bn'] = 'Bengali (bn)';
$langA['lang']['de'] = 'German (de)';
$langA['lang']['el'] = 'Greek (el)';
$langA['lang']['en'] = 'English (en)';
$langA['lang']['es'] = 'Spanish (es)';
$langA['lang']['fr'] = 'French (fr)';
$langA['lang']['hu'] = 'Hungarian (hu)';
$langA['lang']['it'] = 'Italian (it)';
$langA['lang']['ja'] = 'Japanese (ja)';
$langA['lang']['ko'] = 'Korean (ko)';
$langA['lang']['ml'] = 'Malayalam (ml)';
$langA['lang']['nl'] = 'Dutch (nl)';
$langA['lang']['pl'] = 'Polish (pl)';
$langA['lang']['ro'] = 'Romanian (ro)';
$langA['lang']['ru'] = 'Russian (ru)';
$langA['lang']['tr'] = 'Turkish (tr)';
$langA['lang']['vi'] = 'Vietnamese (vi)';
$langA['lang']['zh'] = 'Chinese (zh)';
$langA['lang']['zh-cn'] = 'Chinese Simplified (zh-cn)';



