<?php
defined('WikyBlog') or die('Not an entry point...');

includeFile('tool/UploadFiles.php',false);

class upgradeFiles extends uploadFiles{
	
	
	function upgradeFiles(){
		global $pageOwner,$rootDir;

		if( !isset($pageOwner['imgs']) && !isset($pageOwner['files']) ){
			return;
		}
		
		if( !isOwner(false,true,false) ){
			return;
		}
		
		if( empty($pageOwner['imgs']) && empty($pageOwner['files']) ){
			$this->finished();
			return;
		}

		
		$this->path = $rootDir.'/userfiles/'.toStorage($pageOwner['username'],true).'/uploaded';
		$_POST += array('keywords'=>'','summary'=>'V1.6 Upgrade');
		
		
		//imgs
		foreach($pageOwner['imgs'] as $fName => $size){
			$fullPath = $this->path .'/'. $fName;
			if( !file_exists($fullPath) ){
				//message($fName.' missing');
				continue;
			}
			$checkName = $this->checkFileName($fName);
			if( !$checkName || ( $checkName != $fName ) ){
				continue;
			}

			$fileSize = filesize($fullPath);
			if( $this->addFile2($fName, $fullPath, $fileSize) ){
				//message($fName.' upgraded');
			}else{
				//message($fName.' not upgraded');
			}
		}
		
		//imgs
		foreach($pageOwner['files'] as $fName => $null){
			$fullPath = $this->path .'/'.$fName;
			$fName = str_replace('.wb~','.',$fName);
			if( !file_exists($fullPath) ){
				//message($fName.' missing');
				continue;
			}
			
			$checkName = $this->checkFileName($fName);
			if( !$checkName || ( $checkName != $fName ) ){
				continue;
			}
			
			$fileSize = filesize($fullPath);
			if( $this->addFile2($fName, $fullPath, $fileSize) ){
				//message($fName.' upgraded');
			}else{
				//message($fName.' not upgraded');
			}
		}		
		$this->finished();
	}
	
	function finished(){
		global $pageOwner;
		
		unset($pageOwner['imgs']);
		unset($pageOwner['files']);
		//message('Upgraded');
	}
		
}
