<?php
defined('WikyBlog') or die("Not an entry point...");

global $pageOwner,$dbObject,$langA,$page;
$page->displayTitle = $langA['change_log'];
$page->regLink('?',$langA['change_log'].'?en=Change Log');


includeFile('search/all.php');

class queryChangeLog extends query{
	var $classes;
	
	var $day,$month,$year = false;
	
	var $syntaxError = false;
	var $uncheckedFile = false;
	var $users = array();
	
	function queryChangeLog(){
		global $page,$dbInfo,$pageOwner,$langA,$wbTables,$jsNum;
		$page->css2 =true;

		$this->rowLimit = 25;
		
		$this->classes[] = ' class="tableRowOdd" ';
		$this->classes[] = ' class="tableRowEven" ';
		
		
		$this->allSelect = array('modified','created','username','ip','flags','file_id');
		$this->infoSelect[] = 'summary';

		$this->queryAllFiles();
		
		$this->query .= ' AND '.$wbTables['all_files'].'.`owner_id` = "'.$pageOwner['user_id'].'" ';
		$this->query .= ' AND '.$wbTables['all_files'].'.`visible` = 1 ';
		
		if( isset($_GET['flagged']) ){
			$this->query .= ' AND FIND_IN_SET("notchecked", '.$wbTables['all_files'].'.`flags`) ';
		}
		$this->query .= ' ORDER BY '.$wbTables['all_files'].'.`modified` DESC '; //won't need to specify all_files once completely developed
		
		$this->searchUrl = '/Special/'.$pageOwner['username'].'/ChangeLog';
		$this->browse($langA['change_log']);		
	}
	
	
	function displayPre(){
		global $langA;
		echo '<table cellpadding="2" cellspacing="0" border="0">';
		echo '<tr class="tableRows"><th>'.$langA['timeline'].'</th>';
		echo '<th colspan="2">'.$langA['file'].'</th>';
		echo '<th>'.$langA['user'].'</th>';
		echo '<th>'.$langA['edit_summary'].'</th></tr>';
	}
	function displayPost(&$prev,&$pages,&$next){
		global $langA;
		echo '</table>';
		$list = '';
		$more = '';
		
		
		if( $this->isOwner ){
			$list .= '<li>';
			if( isset($_GET['flagged']) ){
				$list .= wbLinks::local($this->searchUrl,$langA['all']);
				$list .= ' &nbsp; <strong>'.$langA['flagged'].'</strong>';
			}else{
				$list .= '<strong>'.$langA['all'].'</strong> &nbsp; ';
				$list .= wbLinks::local($this->searchUrl.'?flagged=true','unchecked');
			}
			$list .= '</li>';
		}
		if( $this->syntaxError || $this->uncheckedFile){
			$more .= '<p>';
			if( $this->syntaxError ){
				$more .= '<img src="'.wbLinks::getDir('/imgs/icons/bullet_error.gif').'" border="0" width="16" height="16" style="vertical-align:middle" alt="'.$langA['syntax_warning'].'" /> '.$langA['indicates_syntax_error'];
				if( $this->uncheckedFile ){
					$more.= '<br/>';
				}
			}
			if( $this->uncheckedFile ){
				$more .= '<img src="'.wbLinks::getDir('/imgs/icons/bullet_flag_yellow.gif').'" border="0" width="16" height="16" style="vertical-align:middle" alt="'.$langA['unchecked'].'" /> '.$langA['indicates_unchecked'];
			}
			$more .= '</p>';
		}
		
		parent::displayPost($prev,$pages,$next,$list,$more);
	}
		
	function abbrevOutput(&$row,$i){
		global $langA;
		
		$this->queryAllResult($row);
		$this->isOwner = isOwner();
		

		////////	2)	For Odd rows
			$class3 = $this->classes[($i%2)];

		////////	3)	Echo a row

			echo '<tr>';
			$this->timelineTD($row['modified']);
			
			echo '<td '.$class3.' style="white-space:nowrap;padding:0 !important;">';
			
			if( $this->isOwner ){
				if( strpos($row['flags'],'notchecked') !== false){
					$this->uncheckedFile = true;
					echo '<img src="'.wbLinks::getDir('/imgs/icons/bullet_flag_yellow.gif').'" border="0" width="16" height="16" style="vertical-align:middle" alt="'.$langA['unchecked'].'" />';
				}else{
					echo '<img src="'.wbLinks::getDir('/imgs/blank.gif').'" border="0" width="16" height="16" style="vertical-align:middle" alt="" />';
				}
			}
			
			if( strpos($row['flags'],'flag3') !== false){
				$this->syntaxError = true;
				echo '<img src="'.wbLinks::getDir('/imgs/icons/bullet_error.gif').'" border="0" width="16" height="16" style="vertical-align:middle" alt="'.$langA['syntax_warning'].'" />';
			}else{
				echo '&nbsp;'; //for css display of rows in explorer
			}
			
			echo '</td>';
			echo '<td '.$class3;
				echo ' onmouseover="if(!WB)return;WB.SIO(this)"';
				echo ' onmouseout="if(!WB)return;WB.HI(this)"';
				echo '>';

			//////	DB method of creating links
				if( $row['modified'] != $row['created']){
					echo '('.wbLinks::local('/Edit'.$row['uniqLink'].'?cmd=difference',$langA['diff'],'title="'.$langA['DIFF_TITLE'].'"').') ';
				}else{
					echo '('.$langA['new'].') ';
				}
			
				echo ' .. ';
				
				if( strpos($row['flags'],'redirect') === false){
					echo wbLinks::local($row['uniqLink'],toDisplay($row['dTitle'],30),' title="'.toDisplay($row['dTitle']).'"');
				}else{
					echo wbLinks::local($row['uniqLink'].'?cmd=showOriginal',toDisplay($row['dTitle'],30),' title="'.toDisplay($row['dTitle']).'"');
				}
				
				echo '<span class="sm" style="display:none">';
					$editLink = '/Edit'.$row['uniqLink'];
					$editLink = str_replace('?','',$editLink);
					echo wbLinks::local($editLink.'?cmd=edit','edit');
					echo ' &nbsp; ';
					echo wbLinks::local($editLink.'?cmd=history','history');
					if( $this->isOwner ){
						echo ' &nbsp; ';
						echo wbLinks::local($editLink.'?cmd=options','options');
						echo ' &nbsp; ';
						
						//this will work for any type of file..
						$linkPrefix = '/Edit/'.$row['space'].'/'.$row['owner'].'/'.$row['file_id'];
						echo wbLinks::local($linkPrefix.'?cmd=delete','delete');
					}
					echo '</span>';
					
				
				
			echo '</td><td '.$class3.'>';
			
			if( !empty($row['username']) ){
				echo wbLinks::user($row['username']);
				$guest = $row['username'];
			}else{
				echo $row['ip'];
				$guest = $row['ip'];
			}

			
			if( !isset($this->users[$guest]) ){
				echo '<span class="sm">';
				echo '&nbsp; ';
				echo wbLinks::special('UserEdits?user='.$guest,'edits');
				if( isset($_SESSION['username']) && ($_SESSION['username'] != $guest)){
					echo '&nbsp; ';
					echo wbLinks::special('Permissions?guest='.$guest,'+/-','title="'.$langA['SET_USER_PERMISSIONS'].$guest.'"',$_SESSION['username']);
				}
				echo '</span>';
				$this->users[$guest] = true;
			}
			
			
			
			
			
			echo '</td><td '.$class3.'><span class="sm">';
			
			echo $row['summary'];
			echo '&nbsp;</span></td></tr>';
			
	}
}

new queryChangeLog();

