<?php

/*
Types of feeds..

	rss
	atom
		.. then modified/posted/created option
		
		
	Technorati
		http://www.technorati.com/developers/help/tags/
		
		
	http://www.atompub.org/2005/08/17/draft-ietf-atompub-format-11.html
			
*/


defined('WikyBlog') or die("Not an entry point...");

global $pageOwner,$dbObject,$langA,$page;

includeFile('search/all.php');


class searchFeed extends query{
	var $numTables = 0;
	var $numFields = 0;
	
	function searchFeed(){
		global $page,$dbInfo,$pageOwner,$langA,$wbTables;
		$this->rowLimit = 7;
		
		//				--display--			--database--
		$this->fields[$langA['modified']] = 'modified';
		$this->fields[$langA['posted']] = 'posted';
		$this->allSelect = array('modified','posted','created','username','file_id','keywords');
		
		
		
		$this->queryAllFiles();
		$this->query .= ' AND '.$wbTables['all_files'].'.owner_id = "'.$pageOwner['user_id'].'" ';
		$this->query .= ' AND '.$wbTables['all_files'].'.`visible` = 1 ';
		$this->query .= ' AND !FIND_IN_SET("redirect", '.$wbTables['all_files'].'.`flags`) ';
		
		//modifications for blog
		if( isset($_GET['field']) && $_GET['field'] =='blog'){
			$_GET['field'] = $langA['posted'];
			
			if( isset($pageOwner['sBlog']) && ($pageOwner['sBlog'] == 'On') ){
				$this->query .= ' AND FIND_IN_SET("blogged", '.$wbTables['all_files'].'.`flags`) '; //!!only unused flag.. will need to rename this in a later update
			}
		}
		
		
		$this->orderBy();
		
		$this->searchUrl = '/Special/'.$pageOwner['username'].'/searchFeed';
		$this->browse('searchFeed');	//!!$lang
	}
	function displayEmpty(){
		return true;
	}
		
	function displayNumbers(&$from,&$to,&$rowsFound,&$prev,&$next){}
}



//      <updated>2003-12-13T18:30:02Z</updated>
//      <author>
//        <name>John Doe</name>
//      </author>
//      <id>urn:uuid:60a76c80-d399-11d9-b93C-0003939e0af6</id>

//      <entry>
//        <title>Atom-Powered Robots Run Amok</title>
//        <link href="http://example.org/2003/12/13/atom03"/>
//        <id>urn:uuid:1225c695-cfb8-4ebb-aaaa-80da344efa6a</id>
//        <updated>2003-12-13T18:30:02Z</updated>
//        <summary>Some text.</summary>
//      </entry>

//    </feed>

class searchFeedAtom extends searchFeed{
	function searchFeedAtom(){
		$this->searchFeed();
	}
	
	function displayPre(){
		global $langA,$serverName2,$pageOwner,$serverName4;
		global $page,$serverName1;
		
		
		header('Content-Type: text/xml; charset=UTF-8');
		//header('Content-Type: text/plain; charset=UTF-8'); //for testing

		
		echo '<?xml version="1.0" encoding="utf-8"?>';
		//echo "\n".'<feed xmlns:dc="http://purl.org/dc/elements/1.1/">';
		echo "\n".'<feed xmlns="http://www.w3.org/2005/Atom" xmlns:dc="http://purl.org/dc/elements/1.1/">';
		
		echo "\n".'<title>'.$pageOwner['username'].' - '.$serverName1.'</title>';
		$self = $serverName4.'/Special/'.$pageOwner['username'].'/atom';//.my_http_build_query($_GET);
		echo "\n".'<link rel="self" type="application/atom+xml" href="'.$self.'" />';
		echo "\n".'<link rel="alternate" type="text/html" href="'.$serverName4.'/'.$pageOwner['username'].'/" />';
		
		//echo '<id>tag:'.strtolower($serverName2).',2006:'.strtolower($pageOwner['username']).'</id>';
		echo '<id>tag:'.strtolower($serverName2).',2006:'.$pageOwner['user_id'].'</id>';
		
		$modified = date('Y-m-d 0:0:0'); //mimic a database timestamp
		echo '<updated>'.dbFromDate($modified,6).'</updated>';
		echo "\n".'<author>';
		echo '<name>'.$pageOwner['username'].'</name>';
		echo '<uri>'.$serverName4.'/'.$pageOwner['username'].'</uri>';
		echo '</author>';

		
	}
	function displayPost(&$prev,&$pages,&$next){
		echo "\n</feed>";
		exit();//must end it here
	}
		
	function abbrevOutput(&$row){
		global $langA,$serverName2,$serverName4,$pageOwner;
	
		$this->queryAllResult($row);
		
		
		echo "\n".'<entry>';
		echo '<title>'.toDisplay($row['dTitle']).'</title>';
		echo '<link rel="alternate" type="text/html" href="'.$serverName4.$row['uniqLink'].'" />';
		echo '<published>'.dbFromDate($row['posted'],6).'</published>';
		echo '<updated>'.dbFromDate($row['modified'],6).'</updated>';
		
		//must be unique! use the file_id!
		//echo '<id>tag:'.strtolower($serverName2).','.dbFromDate($row['created'],4).':'.$row['file_id'].'</id>';
		//echo '<id>tag:'.strtolower($serverName2).','.$row['file_id'].'</id>';
		echo '<id>tag:'.strtolower($serverName2).',2006:'.$pageOwner['user_id'].'.'.$row['file_id'].'</id>';

		//content isn't available because of the database structure
		$keyArray = explode(',',$row['keywords']);
		foreach($keyArray as $key){
			$key = str_replace(array(': ',':'),'/',$key);
			$key = str_replace(' ','+',$key);
			echo '<dc:subject>'.$key.'</dc:subject>';
		}
		
		echo '</entry>';
	}
}


//RSS 2.0 Feeds
//
class searchFeedRSS extends searchFeed{
	
	function searchFeedRSS(){
		$this->searchFeed();
	}
	
	function displayPre(){
		global $langA,$serverName1,$serverName4,$pageOwner;
		
		
		header('Content-Type: text/xml; charset=UTF-8');
		//header('Content-Type: text/plain; charset=UTF-8');
		
		$this->serverPrefix =& $serverName4;

		
		//new
		echo '<?xml version="1.0" encoding="utf-8" ?>';
		echo "\n". '<rss version="2.0">';
		echo '<channel>';
		echo '<title>'.$pageOwner['username'].' - '.$serverName1.'</title>';
		echo '<link>'.$this->serverPrefix.'/'.$pageOwner['username'].'</link>';
		echo '<description>'.$pageOwner['username'].' - '.$serverName1.'</description>';
	}
	function displayPost(&$prev,&$pages,&$next){
		echo "\n".'</channel></rss>';
		exit();//must end it here
	}
		
	function abbrevOutput(&$row){
		global $langA,$serverName1;
	
		$this->queryAllResult($row);
		
		
		echo "\n".'<item>';
		echo '<guid isPermaLink="true">'.$this->serverPrefix.$row['uniqLink'].'</guid>';
		echo '<pubDate>'.dbFromDate($row['posted'],5).'</pubDate>';
		echo '<title>'.toDisplay($row['dTitle']).'</title>';
		echo '<link>'.$this->serverPrefix.$row['uniqLink'].'</link>';
		
		$keyArray = explode(',',$row['keywords']);
		foreach($keyArray as $key){
			$key = str_replace(array(': ',':'),'/',$key);
			$key = str_replace(' ','+',$key);
			echo '<category>'.$key.'</category>';
		}
		
		
		//content isn't available because of the database structure
		
		echo '</item>';
	}
}

//
//
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/* 	class displayAtom{
// 		function displayPre(){
// 			global $langA,$serverName1,$serverName4,$pageOwner;
// 			
// 			header('Content-type: text/xml; charset=UTF-8');
// 			//header('Content-type: text/plain; charset=UTF-8');
// 			
// 			$this->serverPrefix =& $serverName4;
// 	
// 			
// 			//new
// 			echo '<?xml version="1.0" encoding="utf-8" ?>';
// 			echo "\n". '<rss version="2.0">';
// 			echo '<channel>';
// 			echo '<title>'.$pageOwner['username'].' - '.$serverName1.'</title>';
// 			echo '<link>'.$this->serverPrefix.'/'.$pageOwner['username'].'</link>';
// 			echo '<description>'.$pageOwner['username'].' - '.$serverName1.'</description>';
// 		}
// 		function displayPost($prev,$pages,$next){
// 			echo "\n".'</channel></rss>';
// 			exit();//must end it here
// 		}
// 			
// 		function abbrevOutput(&$row){
// 			global $langA,$serverName1;
// 			
// 			//echo showArray($row);
// 			//echo '<hr>';
// 			
// 			echo "\n".'<item>';
// 			echo '<guid isPermaLink="true">'.$this->serverPrefix.$row->uniqLink.'</guid>';
// 			echo '<pubDate>'.dbFromDate($row->posted,5).'</pubDate>';
// 			echo '<title>'.toDisplay($row->dTitle).'</title>';
// 			echo '<link>'.$this->serverPrefix.$row->uniqLink.'</link>';
// 			
// 			$keyArray = explode(',',$row->keywords);
// 			foreach($keyArray as $key){
// 				$key = str_replace(array(': ',':'),'/',$key);
// 				$key = str_replace(' ','+',$key);
// 				echo '<category>'.$key.'</category>';
// 			}
// 			
// 			
// 			//content isn't available because of the database structure
// 			
// 			echo '</item>';
// 		}	
// 	}
*/
	
	class displayAtom{
		
		function displayPre(){
			global $langA,$serverName2,$pageOwner,$serverName4;
			global $page,$serverName1;
			
			header('Content-type: text/xml; charset=UTF-8');
			echo '<?xml version="1.0" encoding="utf-8"?>';
			
// 			echo "\n".'<feed xmlns:dc="http://purl.org/dc/elements/1.1/">';
			echo "\n".'<feed xmlns="http://www.w3.org/2005/Atom" xmlns:dc="http://purl.org/dc/elements/1.1/">';
			
			echo "\n".'<title>'.$pageOwner['username'].' - '.$serverName1.'</title>';
			echo "\n".'<link rel="alternate" type="text/html" href="'.$serverName4.'/'.$pageOwner['username'].'/" />';
			//echo "\n".'<link rel="self" type="application/atom+xml" href="'.$serverName4.'/Special/'.$pageOwner['username'].'/atom" />';
			$self = $serverName4.'/Special/'.$pageOwner['username'].'/atom?'; //.my_http_build_query($_GET);
			echo "\n".'<link rel="self" type="application/atom+xml" href="'.$self.'" />';
			
			//echo '<id>tag:'.strtolower($serverName2).',2006:'.strtolower($pageOwner['username']).'</id>';
			echo '<id>tag:'.strtolower($serverName2).',2006:'.$pageOwner['user_id'].'</id>';
			
			$modified = date('Y-m-d 0:0:0'); //mimic a database timestamp
			echo '<updated>'.dbFromDate($modified,6).'</updated>';
			echo "\n".'<author>';
			echo '<name>'.$pageOwner['username'].'</name>';
			echo '<uri>'.$serverName4.'/'.$pageOwner['username'].'</uri>';
			echo '</author>';
	
			
		}
		function displayPost($prev,$pages,$next){
			echo "\n</feed>";
			exit();//must end it here
		}
			
		function abbrevOutput(&$row){
			global $langA,$serverName2,$serverName4,$pageOwner;
		
			
			echo "\n".'<entry>';
			echo '<title>'.toDisplay($row->dTitle).'</title>';
			echo '<link rel="alternate" type="text/html" href="'.$serverName4.$row->uniqLink.'" />';
			echo '<published>'.dbFromDate($row->posted,6).'</published>';
			echo '<updated>'.dbFromDate($row->modified,6).'</updated>';
			
			//must be unique! use the file_id!
			//echo '<id>tag:'.strtolower($serverName2).','.dbFromDate($row['created'],4).':'.$row['file_id'].'</id>';
			//echo '<id>tag:'.strtolower($serverName2).','.$row['file_id'].'</id>';
			echo '<id>tag:'.strtolower($serverName2).',2006:'.$pageOwner['user_id'].'.'.$row->file_id.'</id>';
	
			//content isn't available because of the database structure
			$keyArray = explode(',',$row->keywords);
			foreach($keyArray as $key){
				$key = str_replace(array(': ',':'),'/',$key);
				$key = str_replace(' ','+',$key);
				echo '<dc:subject>'.$key.'</dc:subject>';
			}
			if( isset($row->content) && !empty($row->content)){
				echo '<content type="application/xhtml+xml" xml:lang="en">';
				echo '<div xmlns="http://www.w3.org/1999/xhtml">';
				
				$bool = outputWiki($row->content,400,$row->flags);
				if($bool == true){
					echo '... ';
					echo '<a href="'.$serverName4.$row->uniqLink.'">'.$langA['read_more'].'</a> ('.$bool.$langA['words'].')';
				}
				
				echo '</div>';
				echo '</content>';
			}
			
			echo '</entry>';
		}
	}
	
	
	class blogFeed extends displayAtom{
		
		function blogFeed(){
			global $dbInfo, $pageOwner;
			
			includeFile('tool/BlogContent.php');
			$query = BlogContent::blogQuery(false,array('posted','modified','keywords'));
			$query .= ' LIMIT '.$pageOwner['nBlog'];
	
			$result = wbDB::runQuery($query);
			
			
			
			$this->displayPre();
			while( $row = BlogContent::fetch_object($result) ){
				$this->abbrevOutput($row);
			}
			$this->displayPost(false,false,false);
	
	
			
// 			$displayObj = new displayAtom();
// 			$displayObj->objectType = $GLOBALS['pageOwner']['blogT'];
// 			$displayObj->dbInfo = $dbInfo[$GLOBALS['pageOwner']['blogT']];
// 			
// 			$displayObj->displayPre();
// 			echo includeBlog($displayObj,false);
// 			$displayObj->displayPost(false,false,false);
		}
		
		
		function abbrevOutput(&$row){
			global $langA,$serverName2,$serverName4,$pageOwner;
		
			echo "\n".'<entry>';
			
			$title = '';
			$slashPos = strrpos($row->info,'/');
			if( $slashPos > 0 ){
				$title = substr($row->info,($slashPos+1));
			}
			
			echo '<title>'.toDisplay($title).'</title>'; //if it's missing, the feed won't validate, but it can be empty
			echo '<link rel="alternate" type="text/html" href="'.$serverName4.$row->info.'" />';
			echo '<published>'.dbFromDate($row->posted,6).'</published>';
			echo '<updated>'.dbFromDate($row->modified,6).'</updated>';
			
			echo '<id>tag:'.strtolower($serverName2).',2006:'.$pageOwner['user_id'].'.'.$row->file_id.'</id>';
	
			//content isn't available because of the database structure
			$keyArray = explode(',',$row->keywords);
			foreach($keyArray as $key){
				$key = str_replace(array(': ',':'),'/',$key);
				$key = str_replace(' ','+',$key);
				echo '<dc:subject>'.$key.'</dc:subject>';
			}
			if( isset($row->content) && !empty($row->content)){
				echo '<content type="application/xhtml+xml" xml:lang="en">';
				echo '<div xmlns="http://www.w3.org/1999/xhtml">';
				
				$row->content = str_replace('&nbsp;','&#160;',$row->content);
				echo $row->content;
				
				
				echo '</div>';
				echo '</content>';
			}
			
			echo '</entry>';
		}
		
	}

//
//
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//



	global $dbObject;
	
	$_GET += array('field'=>'');
	
	switch($_GET['field']){
		
		case 'blog':
			new blogFeed();
		break;
	}
	
	
	switch($dbObject->title){
		case 'atom':
			new searchFeedAtom();
		break;
		case 'rss':
			new searchFeedRSS();
		break;
	}

	
		function my_http_build_query($data,$prefix=null,$sep='',$key='') {
			$ret = array();
			foreach((array)$data as $k => $v) {
			    $k = urlencode($k);
			    if(is_int($k) && $prefix != null) {
					$k = $prefix.$k;
			    }
			    if(!empty($key)) {
					$k = $key."[".$k."]";
			    }
			
			    if(is_array($v) || is_object($v)) {
					array_push($ret,my_http_build_query($v,"",$sep,$k));
			    }else{
					array_push($ret,$k."=".urlencode($v));
			    }
			}
			
			if(empty($sep)) {
				$sep = ini_get("arg_separator.output");
			}
			
			return implode($sep, $ret);
		}
	
