<?php
//$langA checked

defined('WikyBlog') or die("Not an entry point...");

global $pageOwner,$dbObject,$langA,$page;
$page->displayTitle = $langA['keyword_search']; //'Keyword Search';
$page->regLink('?',$langA['keyword_search'].'?en=Keyword_Search');

includeFile('search/all.php');
	
class queryKeywords extends query{
	var $classes;
	var $label;
	var $space;
	
	function queryKeywords(){
		global $page,$dbInfo,$pageOwner,$langA,$dbObject,$wbTables;
		$page->css2 =true;
		$this->rowLimit = 25;
		
		$this->searchUrl = '/Special/'.$pageOwner['username'].'/'.$dbObject->title;
		
		//$this->fields[--shown to user--] = --database column--
		$this->fields[$langA['posted']] = 'posted';
		$this->fields[$langA['modified']] = 'modified';
		$this->fields[$langA['created']] = $wbTables['all_files'].'.`file_id`';
		
		//Space
			if( isset($_GET['space']) && isset($dbInfo[$_GET['space']]['dbTable']) ){
				$this->space = $dbInfo[$_GET['space']]['class'];		//!! finish getting rid of $this->space by using $this->useTables instead
				$this->useTables[$_GET['space']] = true;
				$this->fields[$langA['created']] = $dbInfo[$_GET['space']]['dbTable'].'.`file_id`';
			}
			
		
		//New
			$this->queryAllFiles();
			$this->query .= ' AND '.$wbTables['all_files'].'.`visible` = 1 ';
		
		//owner
			if( isset($_GET['owner']) && $_GET['owner'] === 'false' ){
				//no owner
			}else{
				$this->query .= ' AND '.$wbTables['all_files'].'.owner_id = "'.$pageOwner['user_id'].'" ';
			}
			
		
		// Keyword Search
			if( !empty($_GET['key']) ){
				
				//prepare $key and $_GET['key] so that multiple tabs aren't created for a single (case different) key
				//	we get the $key as it's stored in $pageOwner because files may have the same key typed with different cases in multiple files
				
				$key = wbHtmlspecialchars($_GET['key']);
				if( ':' === substr($key,-1) ){
					$key = substr($key,0,-1);
				}
				$_GET['key'] = str_replace('&','%26',$_GET['key']);
				$_GET['key'] = trim($_GET['key']);
				
				$key = getUserKeyword($key);
				$this->label = wbUcwords($key);
				$page->displayTitle .= ' > '.$this->label;
				
				//first case... find exact
				$pos= strpos($_GET['key'],':');
				if(($pos === false)||($pos+1) == strlen($_GET['key'])){
					//Get all with a loose query
					$_GET['key'] = $key.':';
					$this->query .= ' AND (';
					$this->query .= ' (FIND_IN_SET("'.wbDB::escape(wbHtmlspecialchars($key)).'", '.$wbTables['all_files'].'.`keywords` )>0) ';
					$this->query .= ' OR ('.$wbTables['all_files'].'.`keywords` LIKE "'.wbDB::like(wbHtmlspecialchars($_GET['key'])).'%") ';
					$this->query .= ' OR ('.$wbTables['all_files'].'.`keywords` LIKE "%,'.wbDB::like(wbHtmlspecialchars($_GET['key'])).'%") ';
					$this->query .= ')';
				}else{
					$this->query .= ' AND (FIND_IN_SET("'.wbDB::escape(wbHtmlspecialchars($_GET['key'])).'", '.$wbTables['all_files'].'.`keywords` )>0) ';
				}
				
			}elseif( !isset($_GET['key']) ){
				
				if( !empty($this->space) ){
					$this->label = $langA['browse'].' '.$langA[$this->space];
				}else{
					$this->label = $langA['browse'].' '.$langA['all'];
				}
				$page->displayTitle = $this->label;
				
			}else{
				
				$whereA[] = ' IF( LENGTH(keywords)>0 ,0,1) ';
				$this->label = $langA['non_tagged_files'];
				$page->displayTitle = $langA['non_tagged_files'];
			}
		
		$this->orderBy();
		$this->browse($this->label);
	}
	
	function mysqlFetch(&$result){
		return mysql_fetch_row($result);
	}

	function displayPre(){}	
	function displayEmpty(){
		parent::displayEmpty();
		return true;
	}

	function displayPost(&$prev,&$pages,&$next){
		global $pageOwner,$dbInfo,$langA;
		$more = '';
		///	Owner
			if( isset($_GET['owner']) && $_GET['owner'] === 'false' ){
				$overWrite['owner'] = false;
				$more .= '<li>'.$langA['search_from'];
				$more .= wbLinks::local($this->searchUrl.'?'.$this->browseString($overWrite),$langA['user'].': '.$pageOwner['username']);
				$more .= ' &nbsp; <b>'.$langA['all_users'].'</b> </li>';
			}else{
				$overWrite['owner'] = 'false';
				$more .= '<li>'.$langA['search_from'];
				$more .= ' <b>'.$langA['user'].': '.$pageOwner['username'].'</b> &nbsp; ';
				$more .= wbLinks::local($this->searchUrl.'?'.$this->browseString($overWrite),$langA['all_users']).'</li>';
			}
			unset($overWrite);
		
		
		/// Space
			$more .= '<li> '.$langA['from_file_type'];
			if( !isset($_GET['space']) || !isset($dbInfo[$_GET['space']]['dbTable']) ){
				$more .= ' <b>'.$langA['all'].'</b> &nbsp; ';
			}else{
				$overWrite['space'] = false;
				
				$temp = $this->browseString($overWrite);
				$more .= browseLink2($this->searchUrl,0,$temp,$langA['all']).' &nbsp; ';
			}
			foreach($dbInfo as $space => $array){
				if( !isset($array['dbTable']) ){
					continue;
				}
				
				if( isset($_GET['space']) && $_GET['space'] == $space){
					$more .= ' <b>'.$langA[$array['class']].'</b> &nbsp; ';
					continue;
				}
				
				$overWrite['space'] = $space;
				$temp = $this->browseString($overWrite);
				$label = wbLang::text($array['class']);
				$more .= browseLink2($this->searchUrl,0,$temp,$label).' &nbsp; ';
			}
			$more .= '</li>';
		
		parent::displayPost($prev,$pages,$next,$more);
	}	
}

new queryKeywords();

//
//
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		Supp Functions
//

function getUserKeyword($arg){
	global $pageOwner;
	
	if( !is_array($pageOwner['keywords']) ){
		return $arg;
	}
	
	foreach($pageOwner['keywords'] as $key => $num){
		if(strcasecmp($arg,$key) === 0){
			return $key;
		}
	}
	return $arg;
}
