<?php

// Try doing a union of two searches.. 
//
//	(SELECT .. FROM all_files ...) UNION (SELECT .. FROM all_history)
//		except.. 
//			how would I keep the entries of "hidden"/"deleted" files out of the list when selecting from all_history?
//

defined('WikyBlog') or die("Not an entry point...");
includeFile('search/all.php');

global $pageOwner,$dbObject,$langA,$page;
$page->displayTitle = $langA['user_edits'];
$page->regLink('?',$langA['user_edits'].'?en=User_Edits');


class searchUser extends query{
	var $user;
	var $isIp = false;
	
	function searchUser(){
		global $page,$dbInfo,$pageOwner,$langA,$wbTables,$jsNum;
		$page->css2 =true;
		$this->overWrite[$langA['go']] = false;


		if( empty($_GET['user']) ){
			$this->user = $pageOwner['username'];
			
			//message('INVALID_REQUEST');
			//sreturn;
		}else{
			$this->user = $_GET['user'];
		}
		$this->user = wbHtmlspecialchars($this->user); //won't have an effect on valid requests
		
		$page->displayTitle .= ' > '.$this->user;
		$test = str_replace('.','',$this->user);
		if( is_numeric($test) ){
			$this->isIp = true;
		}
		
		$this->searchUrl = '/Special/'.$pageOwner['username'].'/UserEdits';
		$this->rowLimit = 25;
		$this->calcFound = false;
		$this->estimateQuery();
		
		$this->classes[] = ' class="tableRowOdd" ';
		$this->classes[] = ' class="tableRowEven" ';
		
		
			$this->joinAllTo = $wbTables['all_files'];
			$this->selectFrom = $wbTables['all_history'].' FORCE INDEX(`username`) LEFT JOIN '.$wbTables['all_files'];
			$this->selectFrom .= ' USING(`file_id`) ';
			
			$this->allSelect = array('file_id','modified');
			$this->allSelect[$wbTables['all_history'].'.`summary`'] = 'summary';
			$this->allSelect[$wbTables['all_history'].'.`modified`'] = 'hist_modified';
			$this->allSelect[$wbTables['all_history'].'.`revision`'] = 'revision';
			
			$this->queryAllFiles();
			
			if( $this->isIp ){
				$this->query .= ' AND '.$wbTables['all_history'].'.`ip` = "'.wbDB::escape($this->user).'" ';
				$this->query .= ' AND '.$wbTables['all_history'].'.`username` IS NULL ';
			}else{
				$this->query .= ' AND '.$wbTables['all_history'].'.`username` = "'.wbDB::escape($this->user).'" ';
			}
			
			//these don't affect the speed significantly
			$this->query .= ' AND '.$wbTables['all_files'].'.`visible` = 1 ';
			
			$this->query .= ' ORDER BY '.$wbTables['all_history'].'.`modified` DESC ';		

		$this->browse($langA['user_edits']);		
	}
	function estimateQuery(){
		global $wbTables;
		$this->estQuery = 'SELECT COUNT(*) as `count` FROM '.$wbTables['all_history'];
		$this->estQuery .= ' WHERE ';
		
		if( $this->isIp ){
			$this->estQuery .= $wbTables['all_history'].'.`ip` = "'.wbDB::escape($this->user).'" ';
			$this->estQuery .= ' AND '.$wbTables['all_history'].'.`username` IS NULL ';
		}else{
			$this->estQuery .= $wbTables['all_history'].'.`username` = "'.wbDB::escape($this->user).'" ';
		}
	}
	
	function displayPre(){
		global $langA;
		
		$this->userLinks = array();
		
		if( !$this->isIp ){
			$this->userLinks[] = wbLinks::local('/'.$this->user,$this->user);
			$this->userLinks[] = wbLinks::special('ControlPanel','control_panel','',$this->user);
		}
		if( !empty($_SESSION['username']) ){
			$this->userLinks[] = wbLinks::special('Permissions?guest='.$this->user,'permissions','title="'.$langA['SET_USER_PERMISSIONS'].$this->user.'"',$_SESSION['username']);
		}
		
		if( !empty($this->userLinks) ){
			echo '<div style="text-align:right">';
			echo implode(' &nbsp; ',$this->userLinks);
			echo '</div>';
		}
		
		echo '<table cellpadding="2" cellspacing="0" border="0">';
		echo '<tr class="tableRows">';
		echo '<th>'.$langA['modified'].'</th>';
		echo '<th>'.$langA['account'].'</th>';
		echo '<th>'.$langA['file'].'</th>';
		echo '<th>'.$langA['summary'].'</th>';
		echo '</tr>';
	}
	function displayPost(&$prev,&$pages,&$next){
		global $langA,$pageOwner;
		$more = '';
		if( !empty($this->userLinks) ){
			$more = '<br/>'. implode(' &nbsp; ',$this->userLinks);
		}
		
		$more .= '<p><form ';
		$more .= ' onsubmit="return WB.RS(event)" ';
		$more .= ' action="'.wbLinks::getUrl('/Special/'.$pageOwner['username'].'/UserEdits').'"';
		$more .= ' method="get" enctype="application/x-www-form-urlencoded">';
		$more .= '<input type="text" name="user" value="'.$this->user.'" />';
		$more .= '<input type="submit" name="cmd" value="'.$langA['go'].'" />';
		$more .= '</form></p>';
		
		
		echo '</table>';
		parent::displayPost($prev,$pages,$next,'',$more);
	}
	
	function abbrevOutput(&$row,$i){
		global $pageOwner,$langA;
		
		$this->queryAllResult($row);
		
		$class3 = $this->classes[($i%2)];
		//echo '<tr '.$this->classes[($i%2)].'>';
		echo '<tr>';
		
		$this->timelineTD($row['hist_modified']);
		
		echo '<td '.$class3.'>';
			echo $row['owner'];
			echo '</td>';
		
		echo '<td '.$class3;
			echo ' onmouseover="if(!WB)return;WB.SIO(this)"';
			echo ' onmouseout="if(!WB)return;WB.HI(this)"';
			echo '>';
			echo wbLinks::local($row['uniqLink'],toDisplay($row['dTitle']));
			$current = false;
			if( $row['modified'] == $row['hist_modified'] ){
				$current = true;
				echo '&nbsp; <span class="sm">'.$langA['current'].'</span>';
			}
			
			$editLink = '/Edit'.$row['uniqLink'];
			echo '<span class="sm" style="display:none">';
				if(!$current){
					echo wbLinks::local($editLink.'?cmd=show&revNum='.$row['revision'],'show');
				}else{
					echo wbLinks::local($editLink.'?cmd=edit','edit');
				}
				if( $row['revision'] > 1){
					echo ' &nbsp; ';
					echo wbLinks::local($editLink.'?cmd=compare&rev1='.($row['revision']-1).'&rev2='.$row['revision'],($row['revision']-1).$langA['vs'].$row['revision']);
				}
				if(!$current){
					echo ' &nbsp; ';
					echo wbLinks::local($editLink.'?cmd=compare&rev1='.$row['revision'].'&rev2='.($row['revision']+1),$row['revision'].$langA['vs'].($row['revision']+1));
				}
				echo ' &nbsp; ';
				echo wbLinks::local($editLink.'?cmd=history','history');
				echo '</span>';			
			
			echo '</td>';
			
			
		echo '<td '.$class3.'>';
			echo '<span class="sm">';
			echo $row['summary'];
			echo '</span>';
			echo '</td>';
			
		echo '</tr>';
	}
	
}

new searchUser();
